// --------------------------------------------------------------------
// CZipStreamFile.hxx
// Whatis:	Some flags
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-FEB-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CZip.hxx instead.
// --------------------------------------------------------------------
#ifndef	CZipStreamFile_hxx
#define	CZipStreamFile_hxx

#include	"IZipStream.hxx"

// --------------------------------------------------------------------
// Declaration of the CZipStreamFile class
// --------------------------------------------------------------------
class	CZipStreamFile : public IZipStream {

	// ----------------------------------------------------------------
	public:		// Constructor
	// ----------------------------------------------------------------
	CZipStreamFile	( const char * aFileName );

	// ----------------------------------------------------------------
	public:		// Destructor
	// ----------------------------------------------------------------
	virtual ~CZipStreamFile	();

	// ----------------------------------------------------------------
	private:	// Copy constructor and assignment operator disabled
	// ----------------------------------------------------------------
	CZipStreamFile				( const CZipStreamFile & );
	CZipStreamFile & operator =	( const CZipStreamFile & );

	// ----------------------------------------------------------------
	public:		// Local Interface
	// ----------------------------------------------------------------
	void		Create		( void );
	void		Truncate	( void );
	void		OpenRO		( void );
	void		OpenRW		( void );
	void		Append		( void );
	void		Close		( void );
    bool		Exist		( void ) const;
    void		SetTime		( time_t );

	// ----------------------------------------------------------------
	public:		// Virtual Interface
	// ----------------------------------------------------------------
	bool			CanSeek		( void );
	bool			CanRead		( void );
	bool			CanWrite	( void );
	void			Seek		( int4_t, zip_stream_seek_t );
	int4_t			Tell		( void );
	bool			Eof			( void );
	dword_t			Read		( void *, dword_t );
	void			Write		( const void *, dword_t );
	const char *	Name		( void );
    dword_t			Size		( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	char *		itsFileName;
	FILE *		itsStream;
	bool		itsReadOnly;
};

#endif	// #ifdef  CZipStreamFile_hxx
// --------------------------------------------------------------------
// EOF:	CZipStreamFile.hxx
// --------------------------------------------------------------------
