// --------------------------------------------------------------------
// CZipStreamSock.hxx
// Whatis:	Throttled streamer
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-FEB-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CZip.hxx instead.
// --------------------------------------------------------------------
#ifndef	CZipStreamSock_hxx
#define	CZipStreamSock_hxx

#include	"IZipStream.hxx"
#include	"CTcpSocket.hxx"

// --------------------------------------------------------------------
// Declaration of the CZipStreamSock class
// --------------------------------------------------------------------
class	CZipStreamSock : public IZipStream {

	// ----------------------------------------------------------------
	public:		// Constructor
	// ----------------------------------------------------------------
	CZipStreamSock	( CTcpSocket * aSock, dword_t aThrottle = 0 );

	// ----------------------------------------------------------------
	public:		// Destructor
	// ----------------------------------------------------------------
	virtual ~CZipStreamSock	();

	// ----------------------------------------------------------------
	private:	// Copy constructor and assignment operator disabled
	// ----------------------------------------------------------------
	CZipStreamSock				( const CZipStreamSock & );
	CZipStreamSock & operator =	( const CZipStreamSock & );

	// ----------------------------------------------------------------
	public:		// Virtual Interface
	// ----------------------------------------------------------------
	bool			CanSeek		( void );
	bool			CanRead		( void );
	bool			CanWrite	( void );
	void			Seek		( int4_t, zip_stream_seek_t );
	int4_t			Tell		( void );
	bool			Eof			( void );
	dword_t			Read		( void *, dword_t );
	void			Write		( const void *, dword_t );
	const char *	Name		( void );
    dword_t			Size		( void );

	void			StartPoint	( dword_t aV );
	void			EndPoint	( dword_t aV );
	void			Throttle	( dword_t aV );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	dword_t			itsThrottle;
	dword_t			itsTransferCount;
	dword_t			itsTransferBytes;
	time_t			itsTransferTime;
	dword_t			itsStartPoint;
	dword_t			itsEndPoint;
	CTcpSocket *	itsSock;

};

#endif	// #ifdef  CZipStreamSock_hxx
// --------------------------------------------------------------------
// EOF:	CZipStreamSock.hxx
// --------------------------------------------------------------------
