// --------------------------------------------------------------------
// CZipStreamStdout.hxx
// Whatis:	Throttled streamer
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-FEB-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CZip.hxx instead.
// --------------------------------------------------------------------
#ifndef	CZipStreamStdout_hxx
#define	CZipStreamStdout_hxx

#include	"IZipStream.hxx"

// --------------------------------------------------------------------
// Declaration of the CZipStreamStdout class
// --------------------------------------------------------------------
class	CZipStreamStdout : public IZipStream {

	// ----------------------------------------------------------------
	public:		// Constructor
	// ----------------------------------------------------------------
	CZipStreamStdout	( dword_t aThrottle = 0 );

	// ----------------------------------------------------------------
	public:		// Destructor
	// ----------------------------------------------------------------
	virtual ~CZipStreamStdout	();

	// ----------------------------------------------------------------
	private:	// Copy constructor and assignment operator disabled
	// ----------------------------------------------------------------
	CZipStreamStdout				( const CZipStreamStdout & );
	CZipStreamStdout & operator =	( const CZipStreamStdout & );

	// ----------------------------------------------------------------
	public:		// Virtual Interface
	// ----------------------------------------------------------------
	bool			CanSeek		( void );
	bool			CanRead		( void );
	bool			CanWrite	( void );
	void			Seek		( int4_t, zip_stream_seek_t );
	int4_t			Tell		( void );
	bool			Eof			( void );
	dword_t			Read		( void *, dword_t );
	void			Write		( const void *, dword_t );
	const char *	Name		( void );
    dword_t			Size		( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	dword_t		itsThrottle;
	dword_t		itsTransferCount;
	time_t		itsTransferTime;

};

#endif	// #ifdef  CZipStreamStdout_hxx
// --------------------------------------------------------------------
// EOF:	CZipStreamStdout.hxx
// --------------------------------------------------------------------
