// --------------------------------------------------------------------
// CZipStreamTar.hxx
// Whatis:	Throttled streamer
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-FEB-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CZip.hxx instead.
// --------------------------------------------------------------------
#ifndef	CZipStreamTar_hxx
#define	CZipStreamTar_hxx

#include	"IZipStream.hxx"
#include	"CZipNotification.hxx"

// --------------------------------------------------------------------
// Declaration of the CTarFile class
// --------------------------------------------------------------------
class	CTarFile {
	// ----------------------------------------------------------------
	public:		// Constructors
	// ----------------------------------------------------------------
	CTarFile	( 	const char *	aLocalFile,
    				const char *	aTarName );

	CTarFile	( 	const byte_t *	aDataBlock,
    				dword_t			aDataSize,
                    const char *	aTarName );

	// ----------------------------------------------------------------
	public:		// Destructor
	// ----------------------------------------------------------------
	~CTarFile	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CTarFile				( const CTarFile & );
	CTarFile & operator =	( const CTarFile & );

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
    const char *		LocalFile	( void ) const;
    const char *		TarName     ( void ) const;
    const byte_t *		DataBlock   ( void ) const;
    dword_t				DataSize    ( void ) const;

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void		Free	( void );
    void		Cleanup	( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
    char *			itsLocalFile;
    char *			itsTarName;
    const byte_t *	itsDataBlock;
    dword_t			itsDataSize;
};

typedef list <class CTarFile>		CTarFile_l;
typedef CTarFile_l::iterator       	CTarFile_li;
typedef CTarFile_l::const_iterator	CTarFile_lci;

// --------------------------------------------------------------------
// Declaration of the CZipStreamTar class
// --------------------------------------------------------------------
class	CZipStreamTar : public IZipStream {

	// ----------------------------------------------------------------
	public:		// Constructor
	// ----------------------------------------------------------------
	CZipStreamTar	( const CTarFile_l & aList );

	// ----------------------------------------------------------------
	public:		// Destructor
	// ----------------------------------------------------------------
	virtual ~CZipStreamTar	();

	// ----------------------------------------------------------------
	private:	// Copy constructor and assignment operator disabled
	// ----------------------------------------------------------------
	CZipStreamTar				( const CZipStreamTar & );
	CZipStreamTar & operator =	( const CZipStreamTar & );

	// ----------------------------------------------------------------
	public:		// Virtual Interface
	// ----------------------------------------------------------------
	bool			CanSeek		( void );
	bool			CanRead		( void );
	bool			CanWrite	( void );
	void			Seek		( int4_t, zip_stream_seek_t );
	int4_t			Tell		( void );
	bool			Eof			( void );
	dword_t			Read		( void *, dword_t );
	void			Write		( const void *, dword_t );
	const char *	Name		( void );
    void			FillNote	( CZipNotification * );
    dword_t			Size		( void );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void			Refill			( void );
    void			Cleanup			( void );
    void			Free			( void );
    void			PrepareHeader	( const char * );
    void			PrepareHeader	( const byte_t *, dword_t );
    void			MakeHeader		( dword_t, time_t );
    dword_t			Checksum		( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	char			itsDataBuf	[512];	// Output buffer
	dword_t			itsDataOffs;		// And current offset in it
	FILE *			itsStream;			// File stram in
	const byte_t *	itsDataPtr;			// Data pointer (if manipulates data)
	dword_t			itsDataLeft;		// Number of bytes left
	const char *	itsTarName;
    CTarFile_l		itsTarFileList;
    CTarFile_li		itsTarFileLoop;
    dword_t			itsCounter;
    dword_t			itsDataSize;
    dword_t			itsDataDone;
};

#endif	// #ifdef  CZipStreamTar_hxx
// --------------------------------------------------------------------
// EOF:	CZipStreamTar.hxx
// --------------------------------------------------------------------
