// --------------------------------------------------------------------
// CZipVersion.hxx
// Whatis:	Zip version
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-FEB-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CZip.hxx instead.
// --------------------------------------------------------------------
#ifndef	CZipVersion_hxx
#define	CZipVersion_hxx

#include	"IZipStream.hxx"

// --------------------------------------------------------------------
//	The upper byte indicates the compatibility of the file
//	attribute information.  If the external file attributes
//	are compatible with MS-DOS and can be read by PKZIP for
//	DOS version 2.04g then this value will be zero.  If these
//	attributes are not compatible, then this value will
//	identify the host system on which the attributes are
//	compatible.  Software can use this information to determine
//	the line record format for text files etc.  The current
//	mappings are:
//
//	0 - MS-DOS and OS/2 (FAT / VFAT / FAT32 file systems)
//	1 - Amiga                     2 - OpenVMS
//	3 - Unix                      4 - VM/CMS
//	5 - Atari ST                  6 - OS/2 H.P.F.S.
//	7 - Macintosh                 8 - Z-System
//	9 - CP/M                     10 - Windows NTFS
//	11 thru 255 - unused
//
//	The lower byte indicates the version number of the
//	software used to encode the file.  The value/10
//	indicates the major version number, and the value
//	mod 10 is the minor version number.
// --------------------------------------------------------------------
typedef	enum {
	zip_data_compat_msdos	= 0,
	zip_data_compat_amiga	= 1,
	zip_data_compat_vms		= 2,
	zip_data_compat_unix	= 3,
	zip_data_compat_vmcms	= 4,
	zip_data_compat_atarist	= 5,
	zip_data_compat_os2hpfs	= 6,
	zip_data_compat_mac		= 7,
	zip_data_compat_zsystem	= 8,
	zip_data_compat_cpm		= 9,
	zip_data_compat_winntfs	= 10
}	zip_data_compat_t;


// --------------------------------------------------------------------
// Declaration of the CZipVersion class
// --------------------------------------------------------------------
class	CZipVersion {

	// ----------------------------------------------------------------
	public:		// Constructors
	// ----------------------------------------------------------------
	CZipVersion	();
	~CZipVersion();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CZipVersion				( const CZipVersion & );
    CZipVersion & operator =( const CZipVersion & );

	// ----------------------------------------------------------------
	public:		// Comparing versions
	// ----------------------------------------------------------------
	bool operator == ( const CZipVersion & ) const;
	bool operator != ( const CZipVersion & ) const;
	bool operator <= ( const CZipVersion & ) const;
	bool operator >= ( const CZipVersion & ) const;
	bool operator <  ( const CZipVersion & ) const;
	bool operator >  ( const CZipVersion & ) const;

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	void		Read	( IZipStream & );
	void		Write	( IZipStream & );
	void		Cleanup	( void );

	// ----------------------------------------------------------------
    dword_t		ZippedSize	( void ) const;

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	zip_data_compat_t	Compatibility	( void ) const;
	byte_t				MajorVersion	( void ) const;
	byte_t				MinorVersion	( void ) const;
    word_t				Version			( void ) const;
    void				SetVersion		( byte_t, byte_t, zip_data_compat_t );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void		Free				( void );
	void		Clear				( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	zip_data_compat_t	itsCompatibility;
	byte_t				itsMajorVersion;
	byte_t				itsMinorVersion;
};

#endif	// #ifdef  CZipVersion_hxx
// --------------------------------------------------------------------
// EOF:	CZipVersion.hxx
// --------------------------------------------------------------------
