// --------------------------------------------------------------------
// IZipStream.hxx
// Whatis:	Streaming base class
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-FEB-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CZip.hxx instead.
// --------------------------------------------------------------------
#ifndef	IZipStream_hxx
#define	IZipStream_hxx

#include	"Platform.hxx"

// --------------------------------------------------------------------
// Data type for seeking
// --------------------------------------------------------------------
typedef	enum {
	zip_stream_seek_set,
	zip_stream_seek_offset,
	zip_stream_seek_end
}	zip_stream_seek_t;

// --------------------------------------------------------------------
// Declaration of the IZipStream class
// --------------------------------------------------------------------
class	IZipStream {

	// ----------------------------------------------------------------
	public:		// Constructor
	// ----------------------------------------------------------------
	IZipStream	();

	// ----------------------------------------------------------------
	public:		// Destructor
	// ----------------------------------------------------------------
	virtual ~IZipStream	();

	// ----------------------------------------------------------------
	public:		// Interface - must be instantiated somewhere
	// ----------------------------------------------------------------
	virtual	bool			CanSeek		( void ) 						= 0;
	virtual	bool			CanRead		( void ) 						= 0;
	virtual	bool			CanWrite	( void ) 						= 0;
	virtual	void			Seek		( int4_t, zip_stream_seek_t )	= 0;
	virtual	int4_t			Tell		( void )						= 0;
	virtual	bool			Eof			( void )						= 0;
	virtual	dword_t			Read		( void *, dword_t )				= 0;
	virtual	void			Write		( const void *, dword_t )		= 0;
	virtual const char *	Name		( void )						= 0;
    virtual dword_t			Size		( void )						= 0;

	// ----------------------------------------------------------------
	public:		// Non-virtual methods for general use
	// ----------------------------------------------------------------
    void	Copy	( IZipStream & aReader, dword_t aSize );

};

#endif	// #ifdef  IZipStream_hxx
// --------------------------------------------------------------------
// EOF:	IZipStream.hxx
// --------------------------------------------------------------------
