// --------------------------------------------------------------------
// CGz.hxx
// Whatis:	Class for reading/writing gz files
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	07-MAR-2003		Created	this source
// --------------------------------------------------------------------
#include	"CGz.hxx"
#include	"CZipStreamFile.hxx"

// --------------------------------------------------------------------
// public:	Constructors and destructors
// --------------------------------------------------------------------
CGz::CGz	() {
	CGz::Clear();
}

// --------------------------------------------------------------------
CGz::CGz	( const CGz & aC ) {
	CGz::Clear();
    itsMembers = aC.Members();
}

// --------------------------------------------------------------------
CGz & CGz::operator = ( const CGz & aC ) {
	CGz::Free();
    itsMembers = aC.Members();
    return *this;
}

// --------------------------------------------------------------------
CGz::~CGz	() {
	CGz::Free();
}

// --------------------------------------------------------------------
// public:	Interfaces
// --------------------------------------------------------------------
void	CGz::Read	( const char * aZipFile ) {
	CZipStreamFile	myfile( aZipFile );
	myfile.OpenRO();
	CGz::Read( myfile );
}

// --------------------------------------------------------------------
void	CGz::Read	( IZipStream & aReader ) {
	CGzMember	mymember;
	CGz::Free();
	mymember.Read( aReader );
    itsMembers.push_back( mymember );
}

// --------------------------------------------------------------------
void	CGz::Write		( const char * aZipFile ) {
	CZipStreamFile	myfile( aZipFile );
	myfile.Create();
	CGz::Write( myfile );
}

// --------------------------------------------------------------------
void	CGz::Write		( IZipStream & aWriter ) {
	CGzMember_li	loop;
    for	( loop = itsMembers.begin(); loop != itsMembers.end(); loop++ ) {
    	(*loop).Write( aWriter );
    }
}

// --------------------------------------------------------------------
void	CGz::Decompress	( void ) {
	CGzMember_li	loop;
    for	( loop = itsMembers.begin(); loop != itsMembers.end(); loop++ ) {
    	(*loop).Decompress();
    }
}

// --------------------------------------------------------------------
void	CGz::Compress	( void ) {
	CGzMember_li	loop;
    for	( loop = itsMembers.begin(); loop != itsMembers.end(); loop++ ) {
    	(*loop).Compress();
    }
}

// --------------------------------------------------------------------
void	CGz::Cleanup	( void ) {
	CGz::Free();
}

// --------------------------------------------------------------------
void	CGz::Free		( void ) {
	CGz::Clear();
}

// --------------------------------------------------------------------
void	CGz::Clear		( void ) {
	CGzMember_li	loop;
    for	( loop = itsMembers.begin(); loop != itsMembers.end(); loop++ ) {
    	(*loop).Cleanup();
    }
	itsMembers.clear();
}

// --------------------------------------------------------------------
const CGzMember_l &	CGz::Members	( void ) const {
	return	itsMembers;
}

// --------------------------------------------------------------------
// EOF:	CGz.cpp
// --------------------------------------------------------------------
