// --------------------------------------------------------------------
// CGzCm.cpp
// Whatis:	gz members
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	07-MAR-2003		Created	this source
// --------------------------------------------------------------------
#include	"CGzCm.hxx"
#include	"CError.hxx"

// --------------------------------------------------------------------
// public:	Constructors and destructor
// --------------------------------------------------------------------
CGzCm::CGzCm	() {
	CGzCm::Clear();
}

// --------------------------------------------------------------------
CGzCm::~CGzCm	() {
	CGzCm::Free();
}

// --------------------------------------------------------------------
CGzCm::CGzCm				( const CGzCm & aC ) {
	CGzCm::Clear();
	itsCm = aC.Cm();
}

// --------------------------------------------------------------------
CGzCm & CGzCm::operator =	( const CGzCm & aC ) {
	CGzCm::Free();
	itsCm = aC.Cm();
    return *this;
}

// --------------------------------------------------------------------
// public:	Interface
// --------------------------------------------------------------------
void	CGzCm::Read	( IZipStream & aReader ) {
	dword_t	rzt = aReader.Read( &itsCm, 1 );
    if	( rzt < 1 ) {
    	throw CError( aReader.Name(), "Not enough data" );
    }
    if	( itsCm != 8 ) {
    	throw CError( aReader.Name(), "Invalid compression mode" );
    }
}

// --------------------------------------------------------------------
void	CGzCm::Write	( IZipStream & aWriter ) {
	aWriter.Write( &itsCm, 1 );
}

// --------------------------------------------------------------------
void	CGzCm::Cleanup	( void ) {
	CGzCm::Free();
}

// --------------------------------------------------------------------
byte_t	CGzCm::Cm	( void ) const {
	return itsCm;
}

// --------------------------------------------------------------------
void	CGzCm::Free	( void ) {
	CGzCm::Clear();
}

// --------------------------------------------------------------------
void	CGzCm::Clear( void ) {
	itsCm = 8;
}

// --------------------------------------------------------------------
// EOF:	CGzCm.cpp
// --------------------------------------------------------------------
