// --------------------------------------------------------------------
// CGzFname.cpp
// Whatis:	gz members
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	10-MAR-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CGz.hxx instead.
// --------------------------------------------------------------------
#include	"CGzFname.hxx"
#include	"CError.hxx"

// --------------------------------------------------------------------
// public:	Constructors and destructor
// --------------------------------------------------------------------
CGzFname::CGzFname	() {
	CGzFname::Clear();
}

// --------------------------------------------------------------------
CGzFname::~CGzFname	() {
	CGzFname::Free();
}

// --------------------------------------------------------------------
CGzFname::CGzFname				( const CGzFname & aC ) {
	CGzFname::Clear();
	if	( aC.Fname() ) {
		itsFname = new char [ ::strlen( aC.Fname() ) + 1 ];
		::strcpy( itsFname, aC.Fname() );
	}
}

// --------------------------------------------------------------------
CGzFname & CGzFname::operator =	( const CGzFname & aC ) {
	CGzFname::Free();
	if	( aC.Fname() ) {
		itsFname = new char [ ::strlen( aC.Fname() ) + 1 ];
		::strcpy( itsFname, aC.Fname() );
	}
	return *this;
}

// --------------------------------------------------------------------
// public:	Interfaces
// --------------------------------------------------------------------
void			CGzFname::Read		( IZipStream & aReader ) {
	CGzFname::Free();
    char	buf	[2048];
    int		idx	= 0;
    while	( idx < (int)sizeof( buf ) ) {
		if	( aReader.Read( buf + idx, 1 ) < 1 )	throw CError( aReader.Name(), "Not enough data" );
        if	( buf[idx] == 0 )	break;
        idx++;
    }
    if	( idx >= (int)sizeof( buf ) )	throw CError( aReader.Name(), "Too long file name" );
    itsFname = new char [ ::strlen( buf ) + 1 ];
    ::strcpy( itsFname, buf );
}

// --------------------------------------------------------------------
void			CGzFname::Write		( IZipStream & aWriter ) {
	if	( itsFname ) {
		aWriter.Write( itsFname, ::strlen( itsFname ) + 1 );
	}
}

// --------------------------------------------------------------------
void			CGzFname::Cleanup		( void ) {
	CGzFname::Free();
}

// --------------------------------------------------------------------
const char *	CGzFname::Fname	( void ) const {
	return itsFname;
}

// --------------------------------------------------------------------
// prvate:	private helpers
// --------------------------------------------------------------------
void		CGzFname::Free		( void ) {
	if	( itsFname )	delete [] itsFname;
	CGzFname::Clear();
}

// --------------------------------------------------------------------
void		CGzFname::Clear		( void ) {
	itsFname = NULL;
}

// --------------------------------------------------------------------
// EOF:	CGzFname.cpp
// --------------------------------------------------------------------
