// --------------------------------------------------------------------
// CGzMember.cpp
// Whatis:	gz members
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	10-MAR-2003		Created	this source
// --------------------------------------------------------------------
#include	"CGzMember.hxx"

// --------------------------------------------------------------------
// public:	Constructors and destructor
// --------------------------------------------------------------------
CGzMember::CGzMember	() {
	CGzMember::Clear();
}

// --------------------------------------------------------------------
CGzMember::~CGzMember	() {
	CGzMember::Free();
}

// --------------------------------------------------------------------
CGzMember::CGzMember				( const CGzMember & aC ) {
	CGzMember::Clear();
	itsId		= aC.Id();
	itsCm		= aC.Cm();
	itsFlag		= aC.Flag();
	itsMtime	= aC.Mtime();
	itsXfl		= aC.Xfl();
	itsOs		= aC.Os();
	itsExtra	= aC.Extra();
	itsFname	= aC.Fname();
	itsComment	= aC.Comment();
	itsFhCrc	= aC.FhCrc();
	itsData		= aC.Data();
}

// --------------------------------------------------------------------
CGzMember & CGzMember::operator =	( const CGzMember & aC ) {
	CGzMember::Free();
	itsId		= aC.Id();
	itsCm		= aC.Cm();
	itsFlag		= aC.Flag();
	itsMtime	= aC.Mtime();
	itsXfl		= aC.Xfl();
	itsOs		= aC.Os();
	itsExtra	= aC.Extra();
	itsFname	= aC.Fname();
	itsComment	= aC.Comment();
	itsFhCrc	= aC.FhCrc();
	itsData		= aC.Data();
	return *this;
}

// --------------------------------------------------------------------
// public:	Interfaces
// --------------------------------------------------------------------
void				CGzMember::Read			( IZipStream & aReader ) {
	CGzMember::Free();
	itsId.Read( aReader );
	itsCm.Read( aReader );
	itsFlag.Read( aReader );
	itsMtime.Read( aReader );
	itsXfl.Read( aReader );
	itsOs.Read( aReader );

    if	( itsFlag.FEXTRA() )	itsExtra.Read( aReader );
	if	( itsFlag.FNAME() )		itsFname.Read( aReader );
	if	( itsFlag.FCOMMENT() )	itsComment.Read( aReader );
	if	( itsFlag.FHCRC() )		itsFhCrc.Read( aReader );

    itsData.Read( aReader );
}

// --------------------------------------------------------------------
void				CGzMember::Write		( IZipStream & aWriter ) {
	itsId.Write( aWriter );
	itsCm.Write( aWriter );
	itsFlag.Write( aWriter );
	itsMtime.Write( aWriter );
	itsXfl.Write( aWriter );
	itsOs.Write( aWriter );

    if	( itsFlag.FEXTRA() )	itsExtra.Write( aWriter );
	if	( itsFlag.FNAME() )		itsFname.Write( aWriter );
	if	( itsFlag.FCOMMENT() )	itsComment.Write( aWriter );
	if	( itsFlag.FHCRC() )		itsFhCrc.Write( aWriter );

    itsData.Write( aWriter );

}

// --------------------------------------------------------------------
void				CGzMember::Decompress	( void ) {
}

// --------------------------------------------------------------------
void				CGzMember::Compress		( void ) {
}

// --------------------------------------------------------------------
void				CGzMember::Cleanup		( void ) {
	CGzMember::Free();
}

// --------------------------------------------------------------------
const CGzId &		CGzMember::Id			( void ) const {
	return	itsId;
}

// --------------------------------------------------------------------
const CGzCm &		CGzMember::Cm			( void ) const {
	return	itsCm;
}

// --------------------------------------------------------------------
const CGzFlag &		CGzMember::Flag			( void ) const {
	return	itsFlag;
}

// --------------------------------------------------------------------
const CGzMtime &	CGzMember::Mtime		( void ) const {
	return	itsMtime;
}

// --------------------------------------------------------------------
const CGzXfl &		CGzMember::Xfl			( void ) const {
	return	itsXfl;
}

// --------------------------------------------------------------------
const CGzOs &		CGzMember::Os			( void ) const {
	return	itsOs;
}

// --------------------------------------------------------------------
const CGzExtra &	CGzMember::Extra		( void ) const {
	return	itsExtra;
}

// --------------------------------------------------------------------
const CGzFname &	CGzMember::Fname		( void ) const {
	return	itsFname;
}

// --------------------------------------------------------------------
const CGzComment &	CGzMember::Comment		( void ) const {
	return	itsComment;
}

// --------------------------------------------------------------------
const CGzFhCrc &	CGzMember::FhCrc		( void ) const {
	return	itsFhCrc;
}

// --------------------------------------------------------------------
const CGzData &		CGzMember::Data			( void ) const {
	return	itsData;
}

// --------------------------------------------------------------------
// private:	Private helpers
// --------------------------------------------------------------------
void		CGzMember::Free			( void ) {
	CGzMember::Clear();
}

// --------------------------------------------------------------------
void		CGzMember::Clear		( void ) {
	itsId.Cleanup();
	itsCm.Cleanup();
	itsFlag.Cleanup();
	itsMtime.Cleanup();
	itsXfl.Cleanup();
	itsOs.Cleanup();
	itsExtra.Cleanup();
	itsFname.Cleanup();
	itsComment.Cleanup();
	itsFhCrc.Cleanup();
	itsData.Cleanup();
}

// --------------------------------------------------------------------
// EOF:	CGzMember.cpp
// --------------------------------------------------------------------
