// --------------------------------------------------------------------
// CGzMtime.cpp
// Whatis:	gz members
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	10-MAR-2003		Created	this source
// --------------------------------------------------------------------
#include	"CGzMtime.hxx"
#include	"CZipDword.hxx"

// --------------------------------------------------------------------
// public:	Constructors and destructor
// --------------------------------------------------------------------
CGzMtime::CGzMtime	() {
	CGzMtime::Clear();
}

// --------------------------------------------------------------------
CGzMtime::~CGzMtime	() {
	CGzMtime::Free();
}

// --------------------------------------------------------------------
CGzMtime::CGzMtime				( const CGzMtime & aC ) {
	CGzMtime::Clear();
	itsTime = aC.Time();
}

// --------------------------------------------------------------------
CGzMtime & CGzMtime::operator =	( const CGzMtime & aC ) {
	CGzMtime::Free();
	itsTime = aC.Time();
	return *this;
}


// --------------------------------------------------------------------
// public:	Interfaces
// --------------------------------------------------------------------
void		CGzMtime::Read		( IZipStream & aReader ) {
	CGzMtime::Free();
	CZipDword	mydw;
	mydw.Read( aReader );
	itsTime = (time_t)mydw.Value();
}

// --------------------------------------------------------------------
void		CGzMtime::Write		( IZipStream & aWriter ) {
	CZipDword	mydw( (dword_t)itsTime );
	mydw.Write( aWriter );
}

// --------------------------------------------------------------------
void		CGzMtime::Cleanup	( void ) {
	CGzMtime::Free();
}

// --------------------------------------------------------------------
time_t		CGzMtime::Time		( void ) const {
	return	itsTime;
}


// --------------------------------------------------------------------
// private:	Private helpers
// --------------------------------------------------------------------
void		CGzMtime::Free				( void ) {
	CGzMtime::Clear();
}

// --------------------------------------------------------------------
void		CGzMtime::Clear				( void ) {
	itsTime = ::time( NULL );
}

// --------------------------------------------------------------------
// EOF:	CGzMtime.hxx
// --------------------------------------------------------------------
