// --------------------------------------------------------------------
// CGzOs.cpp
// Whatis:	gz members
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	10-MAR-2003		Created	this source
// --------------------------------------------------------------------
#include	"CGzOs.hxx"
#include	"CError.hxx"

// --------------------------------------------------------------------
// public:	Constructors and destructor
// --------------------------------------------------------------------
CGzOs::CGzOs	() {
	CGzOs::Clear();
}

// --------------------------------------------------------------------
CGzOs::~CGzOs	() {
	CGzOs::Free();
}

// --------------------------------------------------------------------
CGzOs::CGzOs				( const CGzOs & aC ) {
	CGzOs::Clear();
	itsOs = aC.Os();
}

// --------------------------------------------------------------------
CGzOs & CGzOs::operator =	( const CGzOs & aC ) {
	CGzOs::Free();
	itsOs = aC.Os();
	return *this;
}

// --------------------------------------------------------------------
// public:	Interfaces
// --------------------------------------------------------------------
void		CGzOs::Read	( IZipStream & aReader ) {
	CGzOs::Free();
	if	( aReader.Read( &itsOs, 1 ) < 1 )	throw CError( aReader.Name(), "Not enough data" );

}

// --------------------------------------------------------------------
void		CGzOs::Write	( IZipStream & aWriter ) {
	CGzOs::Clear();
	aWriter.Write( &itsOs, 1 );
}

// --------------------------------------------------------------------
void		CGzOs::Cleanup	( void ) {
	CGzOs::Free();
}

// --------------------------------------------------------------------
byte_t		CGzOs::Os		( void ) const {
	return	itsOs;
}

// --------------------------------------------------------------------
// private:	Helpers
// --------------------------------------------------------------------
void		CGzOs::Free	( void ) {
	CGzOs::Clear();
}

// --------------------------------------------------------------------
void		CGzOs::Clear	( void ) {
	itsOs = 0;
}

// --------------------------------------------------------------------
// EOF:	CGzOs.cpp
// --------------------------------------------------------------------
