// --------------------------------------------------------------------
// CTar.cpp
// Whatis:	Class for writing tar files
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-FEB-2003		Created	this source
// --------------------------------------------------------------------
#include	"CTar.hxx"
#include	"CError.hxx"
#include	"zlib.h"

// --------------------------------------------------------------------
// public:	Constructor and destructor
// --------------------------------------------------------------------
CTar::CTar	( const CTarFile_l & aTl ) {
	itsTarFileList = aTl;
}

// --------------------------------------------------------------------
CTar::~CTar		() {
}

// --------------------------------------------------------------------
// public:	Write an unpacked tar file
// --------------------------------------------------------------------
void	CTar::WriteTar	( const char * aFileName, CZipNotification * aNotify ) {

	// if we have the notification, fill it in !
    CTar::FillNotification( aNotify, "Saving TAR archive" );

	char		buff[4096];
    dword_t		rdln;
    FILE *		strm = NULL;

    try {
		::unlink( aFileName );
	    strm = ::fopen( aFileName, "wb" );
        if	( ! strm ) {
        	throw	CError( aFileName, ::strerror( errno ) );
        }

		CZipStreamTar	mytar( itsTarFileList );

        while	( ! mytar.Eof() ) {
			mytar.FillNote( aNotify );
        	rdln = mytar.Read( buff, sizeof( buff ) );
            ::fwrite( buff, 1, rdln, strm );
        }
		::fclose( strm );
    }

    catch	( ... ) {
    	if	( strm ) ::fclose( strm );
		::unlink( aFileName );
        throw;
    }
}

// --------------------------------------------------------------------
// public:	Write a gzipped tar file
// --------------------------------------------------------------------
void	CTar::WriteTarGz	( const char * aFileName, CZipNotification * aNotify ) {


	// if we have the notification, fill it in !
    CTar::FillNotification( aNotify, "Saving TAR archive" );

	char		buff[4096];
    dword_t		rdln;
	gzFile		gzf	= NULL;

    try {
		::unlink( aFileName );
	    gzf = ::gzopen( aFileName, "wb" );
        if	( ! gzf ) {
        	throw	CError( aFileName, ::strerror( errno ) );
        }

		CZipStreamTar	mytar( itsTarFileList );

        while	( ! mytar.Eof() ) {
        	rdln = mytar.Read( buff, sizeof( buff ) );
			mytar.FillNote( aNotify );
            if	( aNotify ) {
            	if	( aNotify->Aborting() )	break;
                aNotify->TotalBytesDone( aNotify->TotalBytesDone() + rdln );
            }
        	::gzwrite( gzf, buff, rdln );
        }
		::gzclose( gzf );
    }

    catch	( ... ) {
    	if	( gzf ) ::gzclose( gzf );
		::unlink( aFileName );
        throw;
    }
}

// --------------------------------------------------------------------
// private:	Private helpers
// --------------------------------------------------------------------
void	CTar::FillNotification( CZipNotification * aNotify, const char * aTask ) {
	if	( aNotify ) {
    	struct stat	mystat;
    	dword_t		totlsize 	= 0;
        CTarFile_li	loop;

        for	( loop = itsTarFileList.begin(); loop != itsTarFileList.end(); loop++ ) {
        	if	( (*loop).LocalFile() ) {
				if	( ::stat( (*loop).LocalFile(), &mystat ) ) {
                	throw	CError( (*loop).LocalFile(), ::strerror( errno ) );
                }
                if	( mystat.st_size % 512 )	totlsize += 512;
                totlsize = totlsize + 512 + mystat.st_size;
            }
            else {
                if	( (*loop).DataSize() % 512 )	totlsize += 512;
                totlsize = totlsize + 512 + (*loop).DataSize();
            }
        }

		aNotify->Task			( aTask );
        aNotify->TotalFiles		( itsTarFileList.size() );
        aNotify->FilesDone		( 0 );
        aNotify->FileBytes	   	( 0 );
        aNotify->FileBytesDone	( 0 );
        aNotify->TotalBytes		( totlsize );
        aNotify->TotalBytesDone	( 0 );
        aNotify->Aborting       ( false );
        aNotify->Ready			( false );
    }
}

// --------------------------------------------------------------------
// EOF:	CTar.cpp
// --------------------------------------------------------------------
