// --------------------------------------------------------------------
// CZipCrc32.cpp
// Whatis:	File data
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	01-MAR-2003		Created	this source
// --------------------------------------------------------------------
#include	"CZipCrc32.hxx"
#include	"CZipDword.hxx"
#include	"CError.hxx"

// --------------------------------------------------------------------
// public:	Constructor and destructor
// --------------------------------------------------------------------
CZipCrc32::CZipCrc32 () {
	CZipCrc32::Clear();
}

// --------------------------------------------------------------------
CZipCrc32::CZipCrc32( dword_t aV ) {
	CZipCrc32::Clear();
    itsCrc32 = aV;
}

// --------------------------------------------------------------------
CZipCrc32::~CZipCrc32 () {
	CZipCrc32::Free();
}

// --------------------------------------------------------------------
CZipCrc32::CZipCrc32				( const CZipCrc32 & aC ) {
	CZipCrc32::Clear();
    itsCrc32 = aC.Crc32();
}

// --------------------------------------------------------------------
CZipCrc32 & CZipCrc32::operator =	( const CZipCrc32 & aC ) {
	CZipCrc32::Free();
    itsCrc32 = aC.Crc32();
    return *this;
}

// --------------------------------------------------------------------
CZipCrc32 & CZipCrc32::operator =	( dword_t aV ) {
	CZipCrc32::Free();
    itsCrc32 = aV;
    return *this;
}

// --------------------------------------------------------------------
bool	CZipCrc32::operator == ( const CZipCrc32 & aC ) const { return itsCrc32 == aC.Crc32(); }
bool	CZipCrc32::operator != ( const CZipCrc32 & aC ) const { return itsCrc32 != aC.Crc32(); }
void	CZipCrc32::Cleanup	( void ) { CZipCrc32::Free(); }
dword_t	CZipCrc32::Crc32	( void ) const { return itsCrc32.Crc32(); }
void	CZipCrc32::Crc32	( dword_t aV ) { itsCrc32 = aV; }

// --------------------------------------------------------------------
// public:	Interfaces
// --------------------------------------------------------------------
void	CZipCrc32::Calculate	( const void * aData, dword_t aLen ) {
	itsCrc32.Calculate( (const unsigned char *)aData, aLen );
}

// --------------------------------------------------------------------
void	CZipCrc32::Read		( IZipStream & aReader ) {

	CZipCrc32::Free	();

	CZipDword	data;
    data.Read( aReader );
    itsCrc32 = data.Value();
}

// --------------------------------------------------------------------
void	CZipCrc32::Write	( IZipStream & aWriter ) {
	CZipDword	data( itsCrc32.Crc32() );
    data.Write( aWriter );
}

// --------------------------------------------------------------------
void	CZipCrc32::Free	( void ) {
	CZipCrc32::Clear();
}

// --------------------------------------------------------------------
void	CZipCrc32::Clear( void ) {
	itsCrc32 = 0;
}

// --------------------------------------------------------------------
dword_t	CZipCrc32::ZippedSize	( void ) const {
	return  4;
}

// --------------------------------------------------------------------
// EOF:	CZipCrc32.cpp
// --------------------------------------------------------------------
