// --------------------------------------------------------------------
// CZipEOCD.cpp
// Whatis:	End of central directory record
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	02-MAR-2003		Created	this source
// --------------------------------------------------------------------
#include	"CZipEOCD.hxx"
#include	"CError.hxx"

// --------------------------------------------------------------------
// public:	Constructor and destructor
// --------------------------------------------------------------------
CZipEOCD::CZipEOCD () {
	CZipEOCD::Clear();
}

// --------------------------------------------------------------------
CZipEOCD::~CZipEOCD () {
	CZipEOCD::Free();
}

// --------------------------------------------------------------------
// public:	Copy constructor and assignment operator
// --------------------------------------------------------------------
CZipEOCD::CZipEOCD				( const CZipEOCD & aC ) {
	CZipEOCD::Clear();
	itsSignature					= aC.Signature();
	itsDiskNumber					= aC.DiskNumber();
	itsCentralDirDiskNumber			= aC.CentralDirDiskNumber();
	itsCentralDirDiskEntryCount		= aC.CentralDirDiskEntryCount();
	itsCentralDirTotalEntryCount	= aC.CentralDirTotalEntryCount();
	itsCentralDirSize				= aC.CentralDirSize();
	itsCentralDirOffset				= aC.CentralDirOffset();
	itsCommentSize					= aC.CommentSize();
	itsComment						= aC.Comment();
}

// --------------------------------------------------------------------
CZipEOCD & CZipEOCD::operator =	( const CZipEOCD & aC ) {
	CZipEOCD::Free();
	itsSignature					= aC.Signature();
	itsDiskNumber					= aC.DiskNumber();
	itsCentralDirDiskNumber			= aC.CentralDirDiskNumber();
	itsCentralDirDiskEntryCount		= aC.CentralDirDiskEntryCount();
	itsCentralDirTotalEntryCount	= aC.CentralDirTotalEntryCount();
	itsCentralDirSize				= aC.CentralDirSize();
	itsCentralDirOffset				= aC.CentralDirOffset();
	itsCommentSize					= aC.CommentSize();
	itsComment						= aC.Comment();
	return *this;
}

// --------------------------------------------------------------------
// public:	Interfaces
// --------------------------------------------------------------------
void	CZipEOCD::Read			( CZipHeaderSignature & aSig, IZipStream & aReader ) {
	CZipEOCD::Free();
	itsSignature = aSig;
    itsDiskNumber.Read					( aReader );
    itsCentralDirDiskNumber.Read		( aReader );
    itsCentralDirDiskEntryCount.Read	( aReader );
    itsCentralDirTotalEntryCount.Read	( aReader );
    itsCentralDirSize.Read				( aReader );
    itsCentralDirOffset.Read			( aReader );
    itsCommentSize.Read					( aReader );
    itsComment.Read						( aReader, itsCommentSize.Value() );
}

// --------------------------------------------------------------------
void	CZipEOCD::Write			( IZipStream & aWriter ) {
	itsSignature = zip_signature_eocd;	// Just in case
    itsSignature.Write					( aWriter );
    itsDiskNumber.Write					( aWriter );
    itsCentralDirDiskNumber.Write		( aWriter );
    itsCentralDirDiskEntryCount.Write	( aWriter );
    itsCentralDirTotalEntryCount.Write	( aWriter );
    itsCentralDirSize.Write				( aWriter );
    itsCentralDirOffset.Write			( aWriter );
    itsCommentSize.Write				( aWriter );
    itsComment.Write					( aWriter );
}

// --------------------------------------------------------------------
void	CZipEOCD::AddZipComment	( const char * aS ) {
	itsCommentSize.Cleanup();
    itsComment.Cleanup();
	if	( aS ) {
    	if	( *aS ) {
			itsComment.Data( aS );
		    itsCommentSize = (word_t)::strlen( aS );
        }
    }
}

// --------------------------------------------------------------------
void	CZipEOCD::Free( void ) {
	CZipEOCD::Clear();
}

// --------------------------------------------------------------------
void	CZipEOCD::Clear( void ) {
    itsSignature.Cleanup();
    itsDiskNumber.Cleanup();
    itsCentralDirDiskNumber.Cleanup();
    itsCentralDirDiskEntryCount.Cleanup();
    itsCentralDirTotalEntryCount.Cleanup();
    itsCentralDirSize.Cleanup();
    itsCentralDirOffset.Cleanup();
    itsCommentSize.Cleanup();
    itsComment.Cleanup();
}

// --------------------------------------------------------------------
void						CZipEOCD::Cleanup					( void ) { CZipEOCD::Free(); }
const CZipHeaderSignature &	CZipEOCD::Signature					( void ) const { return itsSignature; }
const CZipWord &			CZipEOCD::DiskNumber				( void ) const { return itsDiskNumber; }
const CZipWord &			CZipEOCD::CentralDirDiskNumber		( void ) const { return itsCentralDirDiskNumber; }
const CZipWord &			CZipEOCD::CentralDirDiskEntryCount	( void ) const { return itsCentralDirDiskEntryCount; }
const CZipWord &			CZipEOCD::CentralDirTotalEntryCount	( void ) const { return itsCentralDirTotalEntryCount; }
const CZipDword	&			CZipEOCD::CentralDirSize			( void ) const { return itsCentralDirSize; }
const CZipDword	&			CZipEOCD::CentralDirOffset			( void ) const { return itsCentralDirOffset; }
const CZipWord	&			CZipEOCD::CommentSize				( void ) const { return itsCommentSize; }
const CZipDataField	&		CZipEOCD::Comment					( void ) const { return itsComment; }

void						CZipEOCD::DiskNumber				( word_t aV )  { itsDiskNumber = aV; }
void						CZipEOCD::CentralDirDiskNumber		( word_t aV )  { itsCentralDirDiskNumber = aV; }
void						CZipEOCD::CentralDirDiskEntryCount	( word_t aV )  { itsCentralDirDiskEntryCount = aV; }
void						CZipEOCD::CentralDirTotalEntryCount	( word_t aV )  { itsCentralDirTotalEntryCount = aV; }
void						CZipEOCD::CentralDirSize			( dword_t aV ) { itsCentralDirSize = aV; }
void						CZipEOCD::CentralDirOffset			( dword_t aV ) { itsCentralDirOffset = aV; }

// --------------------------------------------------------------------
dword_t	CZipEOCD::ZippedSize	( void ) const {
	dword_t	zize	= 0;
	zize = zize + itsSignature.ZippedSize();
	zize = zize + itsDiskNumber.ZippedSize();
	zize = zize + itsCentralDirDiskNumber.ZippedSize();
	zize = zize + itsCentralDirDiskEntryCount.ZippedSize();
	zize = zize + itsCentralDirTotalEntryCount.ZippedSize();
	zize = zize + itsCentralDirSize.ZippedSize();
	zize = zize + itsCentralDirOffset.ZippedSize();
	zize = zize + itsCommentSize.ZippedSize();
	zize = zize + itsComment.ZippedSize();
    return zize;
}

// --------------------------------------------------------------------
// EOF:	CZipEOCD.cpp
// --------------------------------------------------------------------
