// --------------------------------------------------------------------
// CZipExternalAttr.cpp
// Whatis:	File data
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	02-MAR-2003		Created	this source
// --------------------------------------------------------------------
#include	"CZipExternalAttr.hxx"
#include	"CZipDword.hxx"

// --------------------------------------------------------------------
// public:	Constructor and destructor
// --------------------------------------------------------------------
CZipExternalAttr::CZipExternalAttr () {
	CZipExternalAttr::Clear();
}

// --------------------------------------------------------------------
CZipExternalAttr::CZipExternalAttr	( dword_t aV )	{
	CZipExternalAttr::Clear();
    itsAttributes = aV;
}

// --------------------------------------------------------------------
CZipExternalAttr::~CZipExternalAttr () {
	CZipExternalAttr::Free();
}

// --------------------------------------------------------------------
CZipExternalAttr::CZipExternalAttr				( const CZipExternalAttr & aC )	{ Clear(); itsAttributes = aC.Attributes(); }
CZipExternalAttr & CZipExternalAttr::operator =	( const CZipExternalAttr & aC )	{ Free();  itsAttributes = aC.Attributes(); return *this; }
CZipExternalAttr & CZipExternalAttr::operator =	( dword_t aV )					{ Free();  itsAttributes = aV; return *this; }

// --------------------------------------------------------------------
// public:	Interfaces
// --------------------------------------------------------------------
void	CZipExternalAttr::Read	( IZipStream & aReader ) {
	CZipExternalAttr::Free();
	CZipDword	dw;
    dw.Read( aReader );
    itsAttributes = dw.Value();
}

// --------------------------------------------------------------------
void	CZipExternalAttr::Write	( IZipStream & aWriter ) {
	CZipDword	dw( itsAttributes );
    dw.Write( aWriter );
}

// --------------------------------------------------------------------
void	CZipExternalAttr::Free	( void ) {
	CZipExternalAttr::Clear();
}

// --------------------------------------------------------------------
void	CZipExternalAttr::Clear	( void ) {
	itsAttributes = 0;
}

// --------------------------------------------------------------------
void		CZipExternalAttr::Cleanup	( void ) { CZipExternalAttr::Free(); }
dword_t		CZipExternalAttr::Attributes	( void ) const	{ return itsAttributes; }
void		CZipExternalAttr::Attributes	( dword_t aV )	{ itsAttributes = aV; }

// --------------------------------------------------------------------
dword_t	CZipExternalAttr::ZippedSize	( void ) const {
	return	4;
}

// --------------------------------------------------------------------
// EOF:	CZipExternalAttr.cpp
// --------------------------------------------------------------------
