// --------------------------------------------------------------------
// CZipFlags.cpp
// Whatis:	Some flags
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	20-JUN-2003		Created	this source
// --------------------------------------------------------------------

#include	"CZipFileHeader.hxx"
#include	"CZipFlags.hxx"

// --------------------------------------------------------------------
// public:	Constructors
// --------------------------------------------------------------------
CZipFlags::CZipFlags	() {
	CZipFlags::Clear();	
}

// --------------------------------------------------------------------
// public:	Destructor
// --------------------------------------------------------------------
CZipFlags::~CZipFlags	() {
	CZipFlags::Free();	
}

// --------------------------------------------------------------------
// public:	Copy constructor and assignment operators
// --------------------------------------------------------------------
CZipFlags::CZipFlags				( const CZipFlags & aC ) {
	CZipFlags::Clear();	
	itsForgetStoredPath = aC.ForgetStoredPath();
	itsCompressionLevel	= aC.CompressionLevel();
}

// --------------------------------------------------------------------
CZipFlags & CZipFlags::operator =	( const CZipFlags & aC ) {
	CZipFlags::Free();	
	itsForgetStoredPath = aC.ForgetStoredPath();
	itsCompressionLevel	= aC.CompressionLevel();
	return *this;
}

// --------------------------------------------------------------------
CZipFlags & CZipFlags::operator =	( const char * aS ) {
	CZipFlags::Free();	
	return *this;
}

// --------------------------------------------------------------------
// public:	Derived functionality
// --------------------------------------------------------------------
zip_deflate_type_t	CZipFlags::DeflateType ( void ) const {

	switch	( itsCompressionLevel ) {
    	case	0:	return	zip_deflate_type_superfast;
    	case	1:	return	zip_deflate_type_superfast;
    	case	2:	return	zip_deflate_type_fast;
    	case	3:	return	zip_deflate_type_fast;
    	case	4:	return	zip_deflate_type_normal;
    	case	5:	return	zip_deflate_type_normal;
    	case	6:	return	zip_deflate_type_normal;
    	case	7:	return	zip_deflate_type_normal;
    	case	8:	return	zip_deflate_type_maximum;
    	case	9:	return	zip_deflate_type_maximum;
    }
	return	zip_deflate_type_normal;
}

// --------------------------------------------------------------------
// public:	Accessing instance data
// --------------------------------------------------------------------
bool	CZipFlags::ForgetStoredPath	( void ) const 	{ return itsForgetStoredPath; }
bool	CZipFlags::Tar				( void ) const 	{ return itsTar; }
int		CZipFlags::CompressionLevel	( void ) const 	{ return itsCompressionLevel; }

void	CZipFlags::ForgetStoredPath	( bool aV )		{ itsForgetStoredPath = aV; }
void	CZipFlags::Tar				( bool aV )		{ itsTar = aV; }

// --------------------------------------------------------------------
void	CZipFlags::CompressionLevel( int  aV ) {
	if		( aV < 0 )	itsCompressionLevel = 0;
    else if	( aV > 9 )	itsCompressionLevel = 9;
    else				itsCompressionLevel = aV;
}

// --------------------------------------------------------------------
// private:	Private helpers
// --------------------------------------------------------------------
void	CZipFlags::Free	( void ) {
	CZipFlags::Clear();
}

// --------------------------------------------------------------------
void	CZipFlags::Clear	( void ) {
	itsForgetStoredPath = false;
	itsCompressionLevel	= 6;
}

// --------------------------------------------------------------------
// EOF:	CZipFlags.cpp
// --------------------------------------------------------------------
