// --------------------------------------------------------------------
// CZipInternalAttr.cpp
// Whatis:	File data
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	02-MAR-2003		Created	this source
// --------------------------------------------------------------------
#include	"CZipInternalAttr.hxx"
#include	"CZipWord.hxx"

// --------------------------------------------------------------------
// public:	Constructor and destructor
// --------------------------------------------------------------------
CZipInternalAttr::CZipInternalAttr () {
	CZipInternalAttr::Clear();
}

// --------------------------------------------------------------------
CZipInternalAttr::CZipInternalAttr	( word_t aV )	{
	CZipInternalAttr::Clear();
    itsAttributes = aV;
}

// --------------------------------------------------------------------
CZipInternalAttr::CZipInternalAttr				( const CZipInternalAttr & aC )	{
	CZipInternalAttr::Clear();
    itsAttributes = aC.Attributes();
}

// --------------------------------------------------------------------
CZipInternalAttr & CZipInternalAttr::operator =	( const CZipInternalAttr & aC )	{
	CZipInternalAttr::Free();
    itsAttributes = aC.Attributes();
    return *this;
}

// --------------------------------------------------------------------
CZipInternalAttr & CZipInternalAttr::operator =	( word_t aV ) {
	CZipInternalAttr::Free();
    itsAttributes = aV;
    return *this;
}

// --------------------------------------------------------------------
CZipInternalAttr::~CZipInternalAttr () {
	CZipInternalAttr::Free();
}

// --------------------------------------------------------------------
// public:	Interfaces
// --------------------------------------------------------------------
void	CZipInternalAttr::Read	( IZipStream & aReader ) {
	CZipInternalAttr::Free();
	CZipWord	dw;
    dw.Read( aReader );
    itsAttributes = dw.Value();
}

// --------------------------------------------------------------------
void	CZipInternalAttr::Write	( IZipStream & aWriter ) {
	CZipWord	dw( itsAttributes );
    dw.Write( aWriter );
}

// --------------------------------------------------------------------
void	CZipInternalAttr::Free	( void ) {
	CZipInternalAttr::Clear();
}

// --------------------------------------------------------------------
void	CZipInternalAttr::Clear	( void ) {
	itsAttributes = 0;
}

// --------------------------------------------------------------------
void		CZipInternalAttr::Cleanup	( void ) { CZipInternalAttr::Free(); }
bool		CZipInternalAttr::AsciiFile	( void ) const	{ return (itsAttributes & 0x0001) != 0; }
word_t		CZipInternalAttr::Attributes( void ) const	{ return itsAttributes; }
void		CZipInternalAttr::Attributes( word_t aV )	{ itsAttributes = aV; }

// --------------------------------------------------------------------
dword_t	CZipInternalAttr::ZippedSize	( void ) const {
	return	2;
}

// --------------------------------------------------------------------
// EOF:	CZipInternalAttr.cpp
// --------------------------------------------------------------------
