// --------------------------------------------------------------------
// CZipNotification.cpp
// Whatis:	Zip progress notification
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-FEB-2003		Created	this source
// --------------------------------------------------------------------
#include	"CZipNotification.hxx"

#include	"CCpuMutex.hxx"

// --------------------------------------------------------------------
// public:	Constructor
// --------------------------------------------------------------------
CZipNotification::CZipNotification	() {
	itsTask				= "";
	itsFileName			= "";
	itsTotalFiles		= 0;
	itsFilesDone		= 0;
	itsFileBytes		= 0;
	itsFileBytesDone	= 0;
	itsTotalBytes		= 0;
	itsTotalBytesDone	= 0;
	itsAborting			= false;
    itsReady			= false;
}

// --------------------------------------------------------------------
// public:	Destructor
// --------------------------------------------------------------------
CZipNotification::~CZipNotification	() {
	itsMutex.Reset();
}

// --------------------------------------------------------------------
// public:	Interface
// --------------------------------------------------------------------
const char *	CZipNotification::Task			( void ) {
	const char * result;
	itsMutex.Lock();
	result = itsTask;
	itsMutex.Unlock();
	return result;
}

// --------------------------------------------------------------------
const char *	CZipNotification::FileName		( void ) {
	const char * result;
	itsMutex.Lock();
	result = itsFileName;
	itsMutex.Unlock();
	return result;
}

// --------------------------------------------------------------------
dword_t			CZipNotification::TotalFiles	( void ) {
	dword_t	result;
	itsMutex.Lock();
	result = itsTotalFiles;
	itsMutex.Unlock();
	return result;
}

// --------------------------------------------------------------------
dword_t			CZipNotification::FilesDone		( void ) {
	dword_t	result;
	itsMutex.Lock();
	result = itsFilesDone;
	itsMutex.Unlock();
	return result;
}

// --------------------------------------------------------------------
dword_t			CZipNotification::FileBytes		( void ) {
	dword_t	result;
	itsMutex.Lock();
	result = itsFileBytes;
	itsMutex.Unlock();
	return result;
}

// --------------------------------------------------------------------
dword_t			CZipNotification::FileBytesDone	( void ) {
	dword_t	result;
	itsMutex.Lock();
	result = itsFileBytesDone;
	itsMutex.Unlock();
	return result;
}

// --------------------------------------------------------------------
dword_t			CZipNotification::TotalBytes	( void ) {
	dword_t	result;
	itsMutex.Lock();
	result = itsTotalBytes;
	itsMutex.Unlock();
	return result;
}

// --------------------------------------------------------------------
dword_t			CZipNotification::TotalBytesDone( void ) {
	dword_t	result;
	itsMutex.Lock();
	result = itsTotalBytesDone;
	itsMutex.Unlock();
	return result;
}

// --------------------------------------------------------------------
bool			CZipNotification::Aborting		( void ) {
	bool	result;
	itsMutex.Lock();
	result = itsAborting;
	itsMutex.Unlock();
	return result;
}

// --------------------------------------------------------------------
bool			CZipNotification::Ready			( void ) {
	bool	result;
	itsMutex.Lock();
	result = itsReady;
	itsMutex.Unlock();
	return result;
}

// --------------------------------------------------------------------
void			CZipNotification::Task			( const char * aV ) {
	itsMutex.Lock();
	itsTask = aV;
	itsMutex.Unlock();
}

// --------------------------------------------------------------------
void			CZipNotification::FileName		( const char * aV ) {
	itsMutex.Lock();
	itsFileName = aV;
	itsMutex.Unlock();
}

// --------------------------------------------------------------------
void			CZipNotification::TotalFiles	( dword_t aV ) {
	itsMutex.Lock();
	itsTotalFiles = aV;
	itsMutex.Unlock();
}

// --------------------------------------------------------------------
void			CZipNotification::FilesDone		( dword_t aV ) {
	itsMutex.Lock();
	itsFilesDone = aV;
	itsMutex.Unlock();
}

// --------------------------------------------------------------------
void			CZipNotification::FileBytes		( dword_t aV ) {
	itsMutex.Lock();
	itsFileBytes = aV;
	itsMutex.Unlock();
}

// --------------------------------------------------------------------
void			CZipNotification::FileBytesDone	( dword_t aV ) {
	itsMutex.Lock();
	itsFileBytesDone = aV;
	itsMutex.Unlock();
}

// --------------------------------------------------------------------
void			CZipNotification::TotalBytes	( dword_t aV ) {
	itsMutex.Lock();
	itsTotalBytes = aV;
	itsMutex.Unlock();
}

// --------------------------------------------------------------------
void			CZipNotification::TotalBytesDone( dword_t aV ) {
	itsMutex.Lock();
	itsTotalBytesDone = aV;
	itsMutex.Unlock();
}

// --------------------------------------------------------------------
void			CZipNotification::Aborting		( bool aV ) {
	itsMutex.Lock();
	itsAborting = aV;
	itsMutex.Unlock();
}

// --------------------------------------------------------------------
void			CZipNotification::Ready		( bool aV ) {
	itsMutex.Lock();
	itsReady = aV;
	itsMutex.Unlock();
}

// --------------------------------------------------------------------
// EOF:	CZipNotification.cpp
// --------------------------------------------------------------------
