// --------------------------------------------------------------------
// CZipStreamFile.cpp
// Whatis:	Some flags
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-FEB-2003		Created	this source
// --------------------------------------------------------------------
#include	"CZipStreamFile.hxx"
#include	"CError.hxx"

// --------------------------------------------------------------------
// public:	Constructor
// --------------------------------------------------------------------
CZipStreamFile::CZipStreamFile( const char * aFileName ) {
	itsFileName	= NULL;
	itsStream	= NULL;
	itsReadOnly	= false;

	if	( aFileName == NULL ) {
    	throw CError( "File name neeeded" );
    }

	if	( aFileName[0] == 0 ) {
    	throw CError( "File name needed" );
    }

	itsFileName = new char [ ::strlen( aFileName ) + 1 ];
	::strcpy( itsFileName, aFileName );
}

// --------------------------------------------------------------------
// public:	Destructor
// --------------------------------------------------------------------
CZipStreamFile::~CZipStreamFile( ) {
	if	( itsStream )	::fclose( itsStream );
	if	( itsFileName )	delete [] itsFileName;
}

// --------------------------------------------------------------------
// public:	Local Interface
// --------------------------------------------------------------------
void	CZipStreamFile::Create		( void ) {
	if	( itsStream != NULL )		throw CError( itsFileName, "Stream already open" );
    if	( CZipStreamFile::Exist() )	throw CError( itsFileName, "File exists" );

	itsStream = ::fopen( itsFileName, "wb" );
	if	( ! itsStream )				throw CError( itsFileName, ::strerror( errno ) );

	itsReadOnly = false;
}

// --------------------------------------------------------------------
void	CZipStreamFile::Truncate	( void ) {
	if	( itsStream != NULL )		throw CError( itsFileName, "Stream already open" );
    if	( CZipStreamFile::Exist() )	::unlink( itsFileName );

	itsStream = ::fopen( itsFileName, "wb" );
	if	( ! itsStream )				throw CError( itsFileName, ::strerror( errno ) );

	itsReadOnly = false;
}

// --------------------------------------------------------------------
void	CZipStreamFile::OpenRO		( void ) {
	if	( itsStream != NULL )		throw CError( itsFileName, "Stream already open" );
	itsStream = ::fopen( itsFileName, "rb" );
	if	( ! itsStream )				throw CError( itsFileName, ::strerror( errno ) );

	itsReadOnly = true;
}

// --------------------------------------------------------------------
void	CZipStreamFile::OpenRW		( void ) {
	if	( itsStream != NULL )		throw CError( itsFileName, "Stream already open" );
	itsStream = ::fopen( itsFileName, "r+b" );
	if	( ! itsStream )				throw CError( itsFileName, ::strerror( errno ) );

	itsReadOnly = false;
}

// --------------------------------------------------------------------
void	CZipStreamFile::Append		( void ) {
	if	( itsStream != NULL )		throw CError( itsFileName, "Stream already open" );
	itsStream = ::fopen( itsFileName, "a+b" );
	if	( ! itsStream )				throw CError( itsFileName, ::strerror( errno ) );

	itsReadOnly = false;
}

// --------------------------------------------------------------------
void	CZipStreamFile::Close		( void ) {
	if	( itsStream == NULL )		throw CError( itsFileName, "Stream not open" );
    if	( ::fclose( itsStream ) != 0 ) {
		itsReadOnly = false;
		itsStream	= NULL;
        throw CError( itsFileName, ::strerror( errno ) );
    }
	itsReadOnly = false;
	itsStream	= NULL;
}

// --------------------------------------------------------------------
// public:	Virtual Interface
// --------------------------------------------------------------------
bool	CZipStreamFile::CanSeek		( void ) {
	return	itsStream != NULL;
}

// --------------------------------------------------------------------
bool	CZipStreamFile::CanRead		( void ) {
	return	itsStream != NULL;
}

// --------------------------------------------------------------------
bool	CZipStreamFile::CanWrite	( void ) {
	return	itsStream != NULL ? false : ! itsReadOnly;
}

// --------------------------------------------------------------------
void	CZipStreamFile::Seek		( int4_t aOffs, zip_stream_seek_t aType ) {
	if	( itsStream == NULL ) {
		throw CError( itsFileName, "Stream not open" );
	}
    int	whence	= SEEK_SET;
    switch	( aType ) {
		case	zip_stream_seek_set:	whence = SEEK_SET; break;
		case	zip_stream_seek_offset:	whence = SEEK_CUR; break;
		case	zip_stream_seek_end:	whence = SEEK_END; break;
    }

	if	( ::fseek( itsStream, (long)aOffs, whence ) ) {
    	throw CError( itsFileName, ::strerror( errno ) );
    }
}

// --------------------------------------------------------------------
int4_t	CZipStreamFile::Tell		( void ) {
	if	( itsStream == NULL ) {
		throw CError( itsFileName, "Stream not open" );
	}

    int4_t	offset = (int4_t)::ftell( itsStream );
    if	( offset == -1L )			throw CError( itsFileName, ::strerror( errno ) );
	return	offset;
}

// --------------------------------------------------------------------
bool	CZipStreamFile::Eof			( void ) {
	if	( itsStream == NULL ) {
		throw CError( itsFileName, "Stream not open" );
	}
	return	feof( itsStream ) != 0;
}

// --------------------------------------------------------------------
dword_t	CZipStreamFile::Read		( void * aData, dword_t aLen ) {
	if	( itsStream == NULL ) {
		throw CError( itsFileName, "Stream not open" );
	}

    size_t	bytes = ::fread( aData, 1, (size_t)aLen, itsStream );
	if	( ferror( itsStream ) )		throw CError( itsFileName, ::strerror( errno ) );
	return	(dword_t)bytes;
}

// --------------------------------------------------------------------
void	CZipStreamFile::Write		( const void * aData, dword_t aLen ) {
	if	( itsStream == NULL ) {
		throw CError( itsFileName, "Stream not open" );
	}
	if	( itsReadOnly ) {
		throw CError( itsFileName, "Stream is read only" );
	}

	if	( aLen > 0 ) {
		::fwrite( aData, 1, (size_t)aLen, itsStream );
		if	( ferror( itsStream ) )		throw CError( itsFileName, ::strerror( errno ) );
    }
}

// --------------------------------------------------------------------
dword_t	CZipStreamFile::Size		( void ) {
	struct stat	mystat;
    if	( ::stat( itsFileName, &mystat ) ) {
    	throw CError( itsFileName, ::strerror( errno ) );
    }
    return mystat.st_size;
}

// --------------------------------------------------------------------
const char *	CZipStreamFile::Name( void ) {
	return	itsFileName;
}

// --------------------------------------------------------------------
bool			CZipStreamFile::Exist( void ) const {
	struct stat	mystat;
	return	::stat( itsFileName, &mystat ) == 0;
}

// --------------------------------------------------------------------
// EOF:	CZipStreamFile.cpp
// --------------------------------------------------------------------
