// --------------------------------------------------------------------
// CZipStreamSock.cpp
// Whatis:	Output everythig to stdout
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-FEB-2003		Created	this source
// --------------------------------------------------------------------
#include	"CZipStreamSock.hxx"
#include	"CError.hxx"

// --------------------------------------------------------------------
// public:	Constructor
// --------------------------------------------------------------------
CZipStreamSock::CZipStreamSock( CTcpSocket * aSock, dword_t	aKilobytesPerSecond ) {
	itsThrottle			= aKilobytesPerSecond;
	itsTransferCount	= 0;
	itsTransferBytes	= 0;
	itsTransferTime		= (dword_t)(::time( NULL ) - 1);
	itsSock				= aSock;
	itsStartPoint		= 0;
	itsEndPoint			= 0;
}

// --------------------------------------------------------------------
// public:	Destructor
// --------------------------------------------------------------------
CZipStreamSock::~CZipStreamSock( ) {
}

// --------------------------------------------------------------------
// public:	Virtual Interface
// --------------------------------------------------------------------
bool	CZipStreamSock::CanSeek		( void ) {
	return	false;
}

// --------------------------------------------------------------------
bool	CZipStreamSock::CanRead		( void ) {
	return	false;
}

// --------------------------------------------------------------------
bool	CZipStreamSock::CanWrite	( void ) {
	return	true;
}

// --------------------------------------------------------------------
void	CZipStreamSock::Seek		( int4_t aOffs, zip_stream_seek_t aType ) {
	throw CError( "stdout", "Can not seek" );
}

// --------------------------------------------------------------------
int4_t	CZipStreamSock::Tell		( void ) {
	return	(int4_t)itsTransferCount;
}

// --------------------------------------------------------------------
bool	CZipStreamSock::Eof		( void ) {
	return	false;
}

// --------------------------------------------------------------------
dword_t	CZipStreamSock::Read		( void * aData, dword_t aLen ) {
	throw CError( "stdout", "Can not read" );
}

// --------------------------------------------------------------------
dword_t	CZipStreamSock::Size		( void ) {
	throw CError( "Unable to get size" );
}

// --------------------------------------------------------------------
void	CZipStreamSock::Write		( const void * aData, dword_t aLen ) {
	const char *	data = (const char *)aData;
	dword_t			rate;

	while	( aLen > 0 ) {

		if	( ( itsEndPoint != 0 ) && ( itsEndPoint < itsTransferBytes ) ) {
			data = data + aLen;
			itsTransferBytes = itsTransferBytes + aLen;
			aLen = 0;
			continue;
		}

		if	( itsStartPoint > itsTransferBytes ) {
			while	( ( aLen > 0 ) && ( itsStartPoint > itsTransferBytes ) ) {
				data++;
				aLen--;
				itsTransferBytes++;
			}
			continue;
		}

		rate = itsTransferCount / ((dword_t)::time( NULL ) - itsTransferTime);
		if	( rate > itsThrottle ) {
			SLEEP( 1000 );
			continue;
		}

		itsSock->Write( data, 1 );
		data++;
		aLen--;
		itsTransferBytes++;

		if	( (itsTransferBytes % 1024) == 0 ) {
			itsSock->Flush();
			itsTransferCount++;
		}
	}
}

// --------------------------------------------------------------------
const char *	CZipStreamSock::Name( void ) {
	return	"socket";
}

// --------------------------------------------------------------------
void			CZipStreamSock::StartPoint( dword_t	aV ) {
	itsStartPoint = aV;
}

// --------------------------------------------------------------------
void			CZipStreamSock::EndPoint( dword_t	aV ) {
	itsEndPoint = aV;
}

// --------------------------------------------------------------------
void			CZipStreamSock::Throttle( dword_t	aV ) {
	itsThrottle = aV;
}

// --------------------------------------------------------------------
// EOF:	CZipStreamSock.cpp
// --------------------------------------------------------------------
