// --------------------------------------------------------------------
// CZipStreamStdout.cpp
// Whatis:	Output everythig to stdout
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-FEB-2003		Created	this source
// --------------------------------------------------------------------
#include	"CZipStreamStdout.hxx"
#include	"CError.hxx"

// --------------------------------------------------------------------
// public:	Constructor
// --------------------------------------------------------------------
CZipStreamStdout::CZipStreamStdout( dword_t	aKilobytesPerSecond ) {
	itsThrottle			= aKilobytesPerSecond;
	itsTransferCount	= 0;
	itsTransferTime		= (dword_t)(::time( NULL ) - 1);
}

// --------------------------------------------------------------------
// public:	Destructor
// --------------------------------------------------------------------
CZipStreamStdout::~CZipStreamStdout( ) {
}

// --------------------------------------------------------------------
// public:	Virtual Interface
// --------------------------------------------------------------------
bool	CZipStreamStdout::CanSeek		( void ) {
	return	false;
}

// --------------------------------------------------------------------
bool	CZipStreamStdout::CanRead		( void ) {
	return	false;
}

// --------------------------------------------------------------------
bool	CZipStreamStdout::CanWrite	( void ) {
	return	true;
}

// --------------------------------------------------------------------
void	CZipStreamStdout::Seek		( int4_t aOffs, zip_stream_seek_t aType ) {
	throw CError( "stdout", "Can not seek" );
}

// --------------------------------------------------------------------
int4_t	CZipStreamStdout::Tell		( void ) {
	return	(int4_t)itsTransferCount;
}

// --------------------------------------------------------------------
bool	CZipStreamStdout::Eof		( void ) {
	return	false;
}

// --------------------------------------------------------------------
dword_t	CZipStreamStdout::Read		( void * aData, dword_t aLen ) {
	throw CError( "stdout", "Can not read" );
}

// --------------------------------------------------------------------
dword_t	CZipStreamStdout::Size		( void ) {
	throw CError( "Unable to get size" );
}

// --------------------------------------------------------------------
void	CZipStreamStdout::Write		( const void * aData, dword_t aLen ) {
	const char *	data = (const char *)aData;
	dword_t			rate;
	dword_t			written;

	while	( aLen > 0 ) {
		if		( aLen < 1024 ) {
			written = (dword_t)::fwrite( data, 1, aLen, stdout );
			aLen = aLen - written;
			data = data + written;
		}
		else if	( itsThrottle > 0 ) {
			rate = itsTransferCount / ((dword_t)::time( NULL ) - itsTransferTime);
			if	( rate > itsThrottle ) {
				SLEEP( 1000 );
			}
			else {
				written = (dword_t)::fwrite( data, 1, 1024, stdout );
				aLen = aLen - written;
				data = data + written;
				itsTransferCount++;
			}
		}
		else {
			written = (dword_t)::fwrite( data, 1, 1024, stdout );
			aLen = aLen - written;
			data = data + written;
		}
		if	( ferror( stdout ) )	break;
	}
}

// --------------------------------------------------------------------
const char *	CZipStreamStdout::Name( void ) {
	return	"stdout";
}

// --------------------------------------------------------------------
// EOF:	CZipStreamStdout.cpp
// --------------------------------------------------------------------
