// --------------------------------------------------------------------
// DisplayServers.cxx
// Whatis:  CGI for viewing the game server database
//
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 23-APR-2003     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CCgiArgs.hxx"
#include    "CTableSrvr.hxx"
#include    "CTableFsrv.hxx"
#include    "CTableFile.hxx"
#include    "CTableAuth.hxx"
#include    "CTableType.hxx"
#include    "CTableRule.hxx"
#include    "CTablePack.hxx"
#include    "CTableVote.hxx"
#include    "CTablePackFile.hxx"
#include	"CPreviewTemplate.hxx"
#include	"CSpam.hxx"
#include	"CUnServerInfo.hxx"

// --------------------------------------------------------------------
// local:	The local data
// --------------------------------------------------------------------
static	CCgiArgs			cgi;
static	CMySqlConnect		db( "quest", "", "UTCMS" );
static	CPreviewTemplate	previewtemplate;

// --------------------------------------------------------------------
// local:	Some database tables needed
// --------------------------------------------------------------------
static	CTableSrvr		srvr;
static	CTableFsrv		fsrv;
static	CTableFile		file;
static	CTableAuth		auth;
static	CTableType		type;
static	CTableRule		rule;
static	CTableVote		vote;
static	CTablePack		pack;
static	CTablePackFile	packfile;

// --------------------------------------------------------------------
// local:	Data associated with those tables
// --------------------------------------------------------------------
static	data_srvr_t		srvrdata		= { { 0 } };
static	data_fsrv_t		fsrvdata		= { { 0 } };
static	data_file_t		filedata		= { { 0 } };
static	data_auth_t		authdata		= { { 0 } };
static	data_type_t		typedata		= { { 0 } };
static	data_pack_t		packdata		= { { 0 } };
static	dword_t			rownumber		= 0;
static	dword_t			rowcount		= 0;
static	dword_t			pagenow			= 0;
static	dword_t			lastpage		= 0;
static	dword_t			linesperpage	= 0;
static	bool			hasmap			= false;
static	dword_t			packcount		= 0;
static	const CUnServerGameInfo *	gameinfo	= NULL;
static	const CUnServerPlayerInfo *	playinfo	= NULL;
static	char			previewer		[1024] = { 0 };

// --------------------------------------------------------------------
// local:	Output the package name
// --------------------------------------------------------------------
static	void	__packages	( void ) {
	if		( packcount < 1 ) {
		::printf( "- none -" );
	}
	else if	( packcount == 1 ) {
		::printf( "%s", packdata.pack_name );
	}
	else {
		::printf( "many...%d", packcount );
	}
}

// --------------------------------------------------------------------
// local:	Output 3 digit bad score
// --------------------------------------------------------------------
static	void	__badscore	( void ) {
	dword_t	totalcount;
	totalcount	= filedata.file_rat0
				+ filedata.file_rat1
				+ filedata.file_rat2;

	double	sharepart = ((double)filedata.file_rat0 / (double)(totalcount + 1)) * 100.0;
	if	( sharepart <= 0.0 )	sharepart = 0.0;
	if	( sharepart >= 100.0 )	sharepart = 100.0;

	dword_t	finalscore = (dword_t)sharepart;

	::printf(	"%s%s%d",
				finalscore < 100 ? "0" : "",
				finalscore < 10  ? "0" : "",
				finalscore );
}

// --------------------------------------------------------------------
// local:	Output 3 digit avg score
// --------------------------------------------------------------------
static	void	__avgscore	( void ) {
	dword_t	totalcount;
	totalcount	= filedata.file_rat0
				+ filedata.file_rat1
				+ filedata.file_rat2;

	double	sharepart = ((double)filedata.file_rat1 / (double)(totalcount + 1)) * 100.0;
	if	( sharepart <= 0.0 )	sharepart = 0.0;
	if	( sharepart >= 100.0 )	sharepart = 100.0;

	dword_t	finalscore = (dword_t)sharepart;

	::printf(	"%s%s%d",
				finalscore < 100 ? "0" : "",
				finalscore < 10  ? "0" : "",
				finalscore );
}

// --------------------------------------------------------------------
// local:	Output 3 digit good score
// --------------------------------------------------------------------
static	void	__godscore	( void ) {
	dword_t	totalcount;
	totalcount	= filedata.file_rat0
				+ filedata.file_rat1
				+ filedata.file_rat2;

	double	sharepart = ((double)filedata.file_rat2 / (double)(totalcount + 1)) * 100.0;
	if	( sharepart <= 0.0 )	sharepart = 0.0;
	if	( sharepart >= 100.0 )	sharepart = 100.0;

	dword_t	finalscore = (dword_t)sharepart;

	::printf(	"%s%s%d",
				finalscore < 100 ? "0" : "",
				finalscore < 10  ? "0" : "",
				finalscore );
}

// --------------------------------------------------------------------
// local:	Output "1" or "0" depending if the visitor can vote this entry
// --------------------------------------------------------------------
static	void	__badstate	( void ) {
	CMySqlWhere	w;
	CMySqlQuote	q;

	w 	<< "vote_idnt='"
		<< filedata.file_idnt
		<< "-0-"
		<< q.Quote( cgi.Arg( CGI_REMOTE_ADDR ) )
		<< "'";

	if	( vote.Count( db, w ) > 0 )	::printf( "1" );
	else							::printf( "0" );
}

// --------------------------------------------------------------------
// local:	Output "1" or "0" depending if the visitor can vote this entry
// --------------------------------------------------------------------
static	void	__avgstate	( void ) {
	CMySqlWhere	w;
	CMySqlQuote	q;

	w 	<< "vote_idnt='"
		<< filedata.file_idnt
		<< "-1-"
		<< q.Quote( cgi.Arg( CGI_REMOTE_ADDR ) )
		<< "'";

	if	( vote.Count( db, w ) > 0 )	::printf( "1" );
	else							::printf( "0" );
}

// --------------------------------------------------------------------
// local:	Output "1" or "0" depending if the visitor can vote this entry
// --------------------------------------------------------------------
static	void	__godstate	( void ) {
	CMySqlWhere	w;
	CMySqlQuote	q;

	w 	<< "vote_idnt='"
		<< filedata.file_idnt
		<< "-2-"
		<< q.Quote( cgi.Arg( CGI_REMOTE_ADDR ) )
		<< "'";

	if	( vote.Count( db, w ) > 0 )	::printf( "1" );
	else							::printf( "0" );
}

// --------------------------------------------------------------------
// local:	Parser questions are sent here for answering
// --------------------------------------------------------------------
static	void	__answer	( const char * aQ ) {

	// ----------------------------------------------------------------
	// local parsing
	// ----------------------------------------------------------------
	if		( ! ::strcmp( aQ, "linepair" ) )		::printf( "%d", rownumber & 0x01 );

	else if	( ! ::strcmp( aQ, "pagenow" ) )			::printf( "%d", pagenow );
	else if	( ! ::strcmp( aQ, "pagenext" ) )		::printf( "%d", pagenow + 1 );
	else if	( ! ::strcmp( aQ, "pageprev" ) )		::printf( "%d", pagenow - 1 );
	else if	( ! ::strcmp( aQ, "lastpage" ) )		::printf( "%d", lastpage );
	else if	( ! ::strcmp( aQ, "rowcount" ) )		::printf( "%d", rowcount );

	else if	( ! ::strcmp( aQ, "previewer" ) )		::printf( "%s", previewer );
	else if	( ! ::strcmp( aQ, "packcount" ) )		::printf( "%d", packcount );
	else if	( ! ::strcmp( aQ, "packages" ) )		__packages();

	else if	( ! ::strcmp( aQ, "firstfile" ) )		::printf( "%d", (pagenow - 1) * linesperpage + 1 );
	else if	( ! ::strcmp( aQ, "lastfile" ) )		::printf( "%d", (pagenow - 1) * linesperpage + linesperpage );

	else if	( ! ::strcmp( aQ, "multipack_b" ) )		::printf( "%s", packcount != 1 ? "" : ((filedata.file_flag & FLAG_NODOWNLOAD) == 0 ? "<!-- " : "") );
	else if	( ! ::strcmp( aQ, "multipack_e" ) )		::printf( "%s", packcount != 1 ? "" : ((filedata.file_flag & FLAG_NODOWNLOAD) == 0 ? " -->" : "") );

	else if	( ! ::strcmp( aQ, "singlepack_b" ) )	::printf( "%s", packcount == 1 ? "" : ((filedata.file_flag & FLAG_NODOWNLOAD) == 0 ? "<!-- " : "") );
	else if	( ! ::strcmp( aQ, "singlepack_e" ) )	::printf( "%s", packcount == 1 ? "" : ((filedata.file_flag & FLAG_NODOWNLOAD) == 0 ? " -->" : "") );

	else if	( ! ::strcmp( aQ, "pagenext_b" ) )		::printf( "%s", pagenow < lastpage ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "pagenext_e" ) )		::printf( "%s", pagenow < lastpage ? "" : " -->" );

	else if	( ! ::strcmp( aQ, "pagenext_bx" ) )		::printf( "%s", pagenow >= lastpage ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "pagenext_ex" ) )		::printf( "%s", pagenow >= lastpage ? "" : " -->" );

	else if	( ! ::strcmp( aQ, "pageprev_b" ) )		::printf( "%s", pagenow > 1 ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "pageprev_e" ) )		::printf( "%s", pagenow > 1 ? "" : " -->" );

	else if	( ! ::strcmp( aQ, "pageprev_bx" ) )		::printf( "%s", pagenow <= 1 ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "pageprev_ex" ) )		::printf( "%s", pagenow <= 1 ? "" : " -->" );

	else if	( ! ::strcmp( aQ, "hasmap_b" ) )		::printf( "%s", hasmap ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "hasmap_e" ) )		::printf( "%s", hasmap ? "" : " -->" );

	else if	( ! ::strcmp( aQ, "hasmap_bx" ) )		::printf( "%s", ! hasmap ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "hasmap_ex" ) )		::printf( "%s", ! hasmap ? "" : " -->" );

	else if	( ! ::strcmp( aQ, "dl_b" ) )			::printf( "%s", (filedata.file_flag & FLAG_NODOWNLOAD) == 0 ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "dl_e" ) )			::printf( "%s", (filedata.file_flag & FLAG_NODOWNLOAD) == 0 ? "" : " -->" );

	else if	( ! ::strcmp( aQ, "dl_bx" ) )			::printf( "%s", (filedata.file_flag & FLAG_NODOWNLOAD) != 0 ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "dl_ex" ) )			::printf( "%s", (filedata.file_flag & FLAG_NODOWNLOAD) != 0 ? "" : " -->" );

	// ----------------------------------------------------------------
	// Game info properties
	// ----------------------------------------------------------------
	else if	( ! ::strcmp( aQ, "property_name" ) )	::HTML_quote( gameinfo ? gameinfo->Option() : "" );
	else if	( ! ::strcmp( aQ, "property_value" ) )	::HTML_quote( gameinfo ? gameinfo->Value() : "" );

	// ----------------------------------------------------------------
	// Player info properties
	// ----------------------------------------------------------------
	else if	( ! ::strcmp( aQ, "player_id" ) )		::printf( "%d", playinfo ? playinfo->PlayerId() : 0 );
	else if	( ! ::strcmp( aQ, "player_name" ) )		::HTML_quote( playinfo ? playinfo->PlayerName() : "" );
	else if	( ! ::strcmp( aQ, "player_mesh" ) )		::HTML_quote( playinfo ? playinfo->PlayerMesh() : "" );
	else if	( ! ::strcmp( aQ, "player_skin" ) )		::HTML_quote( playinfo ? playinfo->PlayerSkin() : "" );
	else if	( ! ::strcmp( aQ, "player_face" ) )		::HTML_quote( playinfo ? playinfo->PlayerFace() : "" );
	else if	( ! ::strcmp( aQ, "player_ping" ) )		::printf( "%d", playinfo ? playinfo->Ping() : 0 );
	else if	( ! ::strcmp( aQ, "player_score" ) )	::printf( "%d", playinfo ? playinfo->Score() : 0 );
	else if	( ! ::strcmp( aQ, "player_statid" ) )	::printf( "%d", playinfo ? playinfo->StatID() : 0 );

	// ----------------------------------------------------------------
	// Scoring
	// ----------------------------------------------------------------
	else if	( ! ::strcmp( aQ, "badscore" ) )		__badscore();
	else if	( ! ::strcmp( aQ, "avgscore" ) )		__avgscore();
	else if	( ! ::strcmp( aQ, "godscore" ) )		__godscore();

	else if	( ! ::strcmp( aQ, "badstate" ) )		__badstate();
	else if	( ! ::strcmp( aQ, "avgstate" ) )		__avgstate();
	else if	( ! ::strcmp( aQ, "godstate" ) )		__godstate();

	// ----------------------------------------------------------------
	// Parsing table data
	// ----------------------------------------------------------------
	else if	( ::MySqlTableParser( srvr.Layout(), "srvr", (const char *)(&srvrdata), aQ ) )	;
	else if	( ::MySqlTableParser( fsrv.Layout(), "fsrv", (const char *)(&fsrvdata), aQ ) )	;
	else if	( ::MySqlTableParser( file.Layout(), "file", (const char *)(&filedata), aQ ) )	;
	else if	( ::MySqlTableParser( auth.Layout(), "auth", (const char *)(&authdata), aQ ) )	;
	else if	( ::MySqlTableParser( type.Layout(), "type", (const char *)(&typedata), aQ ) )	;
	else if	( ::MySqlTableParser( pack.Layout(), "pack", (const char *)(&packdata), aQ ) )	;

	// ----------------------------------------------------------------
	// Parsing the CGI data
	// ----------------------------------------------------------------
	else if	( ::cgi_parser( cgi, aQ ) )	;

	// ----------------------------------------------------------------
	// Everything else goes to default parser
	// ----------------------------------------------------------------
	else	::my_default_answer( aQ );
}


// --------------------------------------------------------------------
// local:	Create server list
// --------------------------------------------------------------------
static	data_srvr_tl	__fetch	( bool aUseAddr ) {
	char			query[1024];
	CMySqlQuote		q;

	if	( aUseAddr ) {
		::strcpy( query, " WHERE srvr_port>0" );
		if	( cgi.Arg( "addr" )[0] != 0 ) {
			::strcat( query, " and srvr_addr='" );
			::strcat( query, q.Quote( cgi.Arg( "addr" ) ) );
			::strcat( query, "'" );
		}
	
		if	( ::strlen( cgi.Arg( "port" ) ) > 0 ) {
			::sprintf( 	query + ::strlen( query ), " and srvr_port=%d",
						(dword_t)::atol( cgi.Arg( "port" ) ) );
		}
	}
	else if	( cgi.Arg( "file" )[0] != 0 ) {
		::sprintf( 	query, ",fsrv WHERE srvr_addr=fsrv_addr and srvr_quep=fsrv_quep and fsrv_file=%d and srvr_port>0",
					(dword_t)::atol( cgi.Arg( "file" ) ) );
		if	(  cgi.Arg( "name" )[0] != 0 ) {
			::strcat( query, " and srvr_name like '%" );
			::strcat( query, q.Quote( cgi.Arg( "name" ) ) );
			::strcat( query, "%'" );
		}
	
		if	(  cgi.Arg( "gtyp" )[0] != 0 ) {
			::strcat( query, " and srvr_gtyp like '%" );
			::strcat( query, q.Quote( cgi.Arg( "gtyp" ) ) );
			::strcat( query, "%'" );
		}
	}
	else {
		::strcpy( query, " WHERE srvr_port>0" );

		if	(  cgi.Arg( "name" )[0] != 0 ) {
			::strcat( query, " and srvr_name like '%" );
			::strcat( query, q.Quote( cgi.Arg( "name" ) ) );
			::strcat( query, "%'" );
		}
	
		if	(  cgi.Arg( "gtyp" )[0] != 0 ) {
			::strcat( query, " and srvr_gtyp like '%" );
			::strcat( query, q.Quote( cgi.Arg( "gtyp" ) ) );
			::strcat( query, "%'" );
		}
	
		if	( cgi.Arg( "gmap" )[0] != 0 ) {
			::strcat( query, " and srvr_gmap like '%" );
			::strcat( query, q.Quote( cgi.Arg( "gmap" ) ) );
			::strcat( query, "%'" );
		}
	
		if	( cgi.Arg( "type" )[0] != 0 ) {
			::strcat( query, " and srvr_type='" );
			::strcat( query, q.Quote( cgi.Arg( "type" ) ) );
			::strcat( query, "'" );
		}
	}

	rowcount = srvr.Count( db, query );
	lastpage = rowcount / linesperpage + 1;

	if		( ! ::strcmp( cgi.Arg( "ordr" ), "name" ) )	::strcat( query, " order by srvr_name, srvr_addr, srvr_port LIMIT " );
	else if	( ! ::strcmp( cgi.Arg( "ordr" ), "gmap" ) )	::strcat( query, " order by srvr_gmap, srvr_addr, srvr_port LIMIT " );
	else if	( ! ::strcmp( cgi.Arg( "ordr" ), "time" ) )	::strcat( query, " order by srvr_time desc, srvr_addr, srvr_port LIMIT " );
	else												::strcat( query, " order by srvr_addr, srvr_port LIMIT " );

	::sprintf(	query + ::strlen( query ), "%d,%d",
				((dword_t)(pagenow-1) * linesperpage),
	  			(dword_t)linesperpage );

	return	srvr.Select( db, query );
}


// --------------------------------------------------------------------
// local:	Prevent spam
// --------------------------------------------------------------------
static	bool	__spam	( void ) {
	bool	is_spam	= false;

	try	{
		CSpam	myspam1( cgi.Arg( CGI_REMOTE_ADDR ), cgi.Arg( CGI_QUERY_STRING ), 1 );
	}

	catch	( CError e ) {
		is_spam = true;
	}

	return	is_spam;
}

// --------------------------------------------------------------------
static	void	__set_filedata( data_srvr_t & aData, bool aLooped ) {
	CMySqlWhere		w;
	CMySqlQuote		q;
	data_file_tl	list;

	if	( aLooped ) {
		w << "file_name='" << q.Quote( aData.srvr_gmap ) << "' and file_suff='";
		if	( ! ::strcmp( aData.srvr_type, "UT" ) )	w << "unr'";
		else										w << "ut2'";
		w << " and file_typ2 like '";
		if	( ! ::strcmp( aData.srvr_type, "UT" ) )	w << "UT%'";
		else										w << "UT2K3%'";
	}
	else {
		w << "file_idnt=" << (dword_t)::atol( cgi.Arg( "file" ) );
	}

	list = file.Select( db, w );
	if	( list.size() == 1 ) {
		filedata = *(list.begin());
		hasmap = true;

	}
	else {
		hasmap = false;
	}
}

// --------------------------------------------------------------------
static	void	__list_srvr() {

	data_srvr_tl	list = __fetch( false );
	data_srvr_tli	loop;

	rownumber = 0;
	previewtemplate.Execute( __answer, "tmpl-dispserv-list-head" );
	for	( loop = list.begin(); loop != list.end(); loop++ ) {
		srvrdata = *loop;
		__set_filedata( srvrdata, true );
		previewtemplate.Execute( __answer, "tmpl-dispserv-list-body" );
		rownumber++;
	}
	previewtemplate.Execute( __answer, "tmpl-dispserv-list-tail" );
}

// --------------------------------------------------------------------
static	void	__list_rota() {

	data_srvr_tl	list = __fetch( false );
	data_srvr_tli	loop;

	__set_filedata( srvrdata, false );

	rownumber = 0;
	previewtemplate.Execute( __answer, "tmpl-dispserv-list-rota" );
	for	( loop = list.begin(); loop != list.end(); loop++ ) {
		srvrdata = *loop;
		__set_filedata( srvrdata, true );
		previewtemplate.Execute( __answer, "tmpl-dispserv-list-body" );
		rownumber++;
	}
	previewtemplate.Execute( __answer, "tmpl-dispserv-list-tail" );
}

// --------------------------------------------------------------------
static	void	__fill_srvr_info(	data_srvr_t & 			aData,
									const char *			aType,
									const CUnServerInfo &	aSrvr ) {
	::my_strfit( aData.srvr_addr, sizeof( aData.srvr_addr ) - 1, aSrvr.IpAddress() );
	if	( aType )	::strcpy( aData.srvr_type, aType );
	::my_strfit( aData.srvr_name, sizeof( aData.srvr_name ) - 1, aSrvr.ServerName() );
	::my_strfit( aData.srvr_gmap, sizeof( aData.srvr_gmap ) - 1, aSrvr.GameMap() );
	::my_strfit( aData.srvr_gttl, sizeof( aData.srvr_gttl ) - 1, aSrvr.MapTitle() );
	::my_strfit( aData.srvr_gtyp, sizeof( aData.srvr_gtyp ) - 1, aSrvr.GameType() );
	aData.srvr_pcur = aSrvr.CurrentPlayers();
	aData.srvr_pmax = aSrvr.MaximumPlayers();
	aData.srvr_port = aSrvr.GamePort();
	aData.srvr_quep = aSrvr.QueryPort();
	aData.srvr_time = ::time( NULL );
}

// --------------------------------------------------------------------
static	void	__update_srvr_data	( 	data_srvr_t & aOldData,
										data_srvr_t & aNewData ) {
	srvr.Delete( db, &aOldData );
	srvr.Delete( db, &aNewData );
	srvr.Insert( db, &aNewData );
}

// --------------------------------------------------------------------
static	void	__adds_srvr() {

	cgi.Arg( "task", "list" );
	__list_srvr();
}

// --------------------------------------------------------------------
static	void	__info_srvr() {
	CMySqlWhere		w;

	data_srvr_tl	list = __fetch( true );

	if	( list.size() < 1 ) {
		previewtemplate.Execute( __answer, "tmpl-dispserv-erro-nsrv" );
		return;
	}

	srvrdata = *(list.begin());

	try {
		CUnServerInfo	myinfo(	srvrdata.srvr_addr,
								srvrdata.srvr_quep,
								(unreal_server_t)( ::strcmp( srvrdata.srvr_type, "UT" )
								? unreal_server_2003 : unreal_server_ut ) );

		if	( myinfo.GamePort() == 0 ) {
			previewtemplate.Execute( __answer, "tmpl-dispserv-erro-nsrv" );
		}
		else {
			myinfo.Refresh();	// Get full details

			data_srvr_t	old_data = srvrdata;
			__fill_srvr_info( srvrdata, NULL, myinfo );
			__update_srvr_data( old_data, srvrdata );
			__set_filedata( srvrdata, true );

			// Basic server info
			previewtemplate.Execute( __answer, "tmpl-dispserv-info-head" );	

			// Game info
			CUnServerGameInfo_tlci		gloop;
			rownumber = 0;
			previewtemplate.Execute( __answer, "tmpl-dispserv-ginf-head" );
			for	(	gloop =  myinfo.GameInfo().begin();
					gloop != myinfo.GameInfo().end();
					gloop++ ) {
				gameinfo = &(*gloop);				
				previewtemplate.Execute( __answer, "tmpl-dispserv-ginf-body" );
				rownumber++;
			}
			previewtemplate.Execute( __answer, "tmpl-dispserv-ginf-tail" );

			// Player info
			CUnServerPlayerInfo_tlci	ploop;
			rownumber = 0;
			previewtemplate.Execute( __answer, "tmpl-dispserv-pinf-head" );
			for	(	ploop =  myinfo.PlayerInfo().begin();
					ploop != myinfo.PlayerInfo().end();
					ploop++ ) {
				playinfo = &(*ploop);
				previewtemplate.Execute( __answer, "tmpl-dispserv-pinf-body" );
				rownumber++;
			}
			previewtemplate.Execute( __answer, "tmpl-dispserv-pinf-tail" );

			// Statistical map rotation
			data_fsrv_tl	fsrvlist;
			data_fsrv_tli	fsrvloop;
			rownumber = 0;
			w = "";
			w << "fsrv_addr='" << srvrdata.srvr_addr << "' and ";
			w << "fsrv_quep="  << srvrdata.srvr_quep;
			fsrvlist = fsrv.Select( db, w );
			previewtemplate.Execute( __answer, "tmpl-dispserv-rota-head" );
			for	(	fsrvloop =  fsrvlist.begin();
					fsrvloop != fsrvlist.end();
					fsrvloop++ ) {
				fsrvdata = *fsrvloop;

				w = "";
				w << "file_idnt=" << fsrvdata.fsrv_file;
				if	( file.Count( db, w ) != 1 )	continue;
				filedata = *(file.Select(db,w).begin());

				w = "";
				w << "packfile_file=" << filedata.file_idnt;
				packcount = packfile.Count( db, w );
				if	( packcount == 1 ) {
					dword_t	pack_idnt = (*(packfile.Select(db,w).begin())).packfile_pack;
					w = "";
					w << "pack_idnt=" << pack_idnt;
					if	( pack.Count( db, w ) == 1 ) {
						packdata = *(pack.Select(db,w).begin());
					}
					else {
						::memset( &packdata, 0, sizeof( packdata ) );
					}
				}
				else {
					::memset( &packdata, 0, sizeof( packdata ) );
				}

				w = "";
				w << "auth_idnt=" << filedata.file_auth;
				if	( auth.Count( db, w ) == 1 ) {
					authdata = *(auth.Select(db,w).begin());
				}
				else {
					::memset( &authdata, 0, sizeof( authdata ) );
				}
	
				w = "";
				w << "type_idnt=" << filedata.file_type;
				if	( type.Count( db, w ) == 1 ) {
					typedata = *(type.Select(db,w).begin());
				}
				else {
					::memset( &typedata, 0, sizeof( typedata ) );
				}
	
				w = "";
				w << "rule_type=" << filedata.file_type << " and ";
				w << "rule_name='preview'";
				if	( rule.Count( db, w ) == 1 ) {
					::strcpy( previewer, (*(rule.Select(db,w).begin())).rule_rule );
				}
				else {
					*previewer = 0;
				}

				previewtemplate.Execute( __answer, "tmpl-dispserv-rota-body" );
				rownumber++;
			}
			previewtemplate.Execute( __answer, "tmpl-dispserv-rota-tail" );



			previewtemplate.Execute( __answer, "tmpl-dispserv-info-tail" );	
		}
	}

	catch	( CError e ) {
		::printf( "<p>ERROR: %s</p>", e.Error() );
	}

	catch	( ... ) {
		previewtemplate.Execute( __answer, "tmpl-dispserv-erro-nsrv" );
	}
}

// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {
	::srand( (unsigned int)::time( NULL ) );
	::HTTP_text( "en" );

	try	{
		if	( __spam() ) {
			previewtemplate.Execute( __answer, "tmpl-spam-warning" );
			return	-1;
		}

		if	( ! cgi.Exist( "page" ) )	cgi.Arg( "page", "1" );
		if	( ! cgi.Exist( "pgln" ) )	cgi.Arg( "pgln", "20" );
		if	( ! cgi.Exist( "task" ) )	cgi.Arg( "task", "list" );

		linesperpage = ::atol( cgi.Arg( "pgln" ) );
		if	( linesperpage > 200 ) {
			linesperpage = 200;
			cgi.Arg( "pgln", "200" );
		}
		pagenow		 = ::atol( cgi.Arg( "page" ) );

		if		( ! ::strcmp( cgi.Arg( "task" ), "list" ) )	__list_srvr();
		else if	( ! ::strcmp( cgi.Arg( "task" ), "adds" ) )	__adds_srvr();
		else if	( ! ::strcmp( cgi.Arg( "task" ), "info" ) )	__info_srvr();
		else if	( ! ::strcmp( cgi.Arg( "task" ), "rota" ) )	__list_rota();

	}

	catch 	( CError e ) {
		::HTML_quote( e.Error() );
		::printf( "</p>" );
	}

	catch	( ... ) {
		::printf( "<p>Error: Unknown error</p>" );
	}
    return	0;
}

// --------------------------------------------------------------------
// EOF: DisplayServers.cxx
// --------------------------------------------------------------------
