// --------------------------------------------------------------------
// FileAdmin.cxx
// Whatis:  CGI for administering teh files
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 28-SEP-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CSession.hxx"
#include	"CCgiArgs.hxx"
#include	"CStorage.hxx"
#include	"CAuthor.hxx"
#include    "CPreviewTemplate.hxx"
#include	"CMySqlWhere.hxx"
#include	"CTablePref.hxx"
#include	"CTableFile.hxx"
#include	"CTableUser.hxx"
#include	"CTableAuth.hxx"
#include	"CTablePack.hxx"
#include	"CTableArep.hxx"
#include	"CTablePackFile.hxx"
#include	"CTableArep.hxx"

// --------------------------------------------------------------------
// local:	Save argument name list
// --------------------------------------------------------------------
static	const char *	saveargs[] = {
	"page", "forw", "task",
	"find_file_name", "find_file_auth", "find_auth_name", "find_file_type",

 	"pack_page", "pack_idnt", "find_pack_name", "find_pack_file",

	"sel0",		"file_idnt_0",	"file_name_0",	"file_auth_0",	"vfg0",		"lfg0",		"rfg0",		"wfg0",		"mfg0",		"nfg0",		"dfg0",		"sfg0",
	"sel1",		"file_idnt_1",	"file_name_1",	"file_auth_1",	"vfg1",		"lfg1",		"rfg1",		"wfg1",		"mfg1",		"nfg1",		"dfg1",		"sfg1",
	"sel2",		"file_idnt_2",	"file_name_2",	"file_auth_2",	"vfg2",		"lfg2",		"rfg2",		"wfg2",		"mfg2",		"nfg2",		"dfg2",		"sfg2",
	"sel3",		"file_idnt_3",	"file_name_3",	"file_auth_3",	"vfg3",		"lfg3",		"rfg3",		"wfg3",		"mfg3",		"nfg3",		"dfg3",		"sfg3",
	"sel4",		"file_idnt_4",	"file_name_4",	"file_auth_4",	"vfg4",		"lfg4",		"rfg4",		"wfg4",		"mfg4",		"nfg4",		"dfg4",		"sfg4",
	"sel5",		"file_idnt_5",	"file_name_5",	"file_auth_5",	"vfg5",		"lfg5",		"rfg5",		"wfg5",		"mfg5",		"nfg5",		"dfg5",		"sfg5",
	"sel6",		"file_idnt_6",	"file_name_6",	"file_auth_6",	"vfg6",		"lfg6",		"rfg6",		"wfg6",		"mfg6",		"nfg6",		"dfg6",		"sfg6",
	"sel7",		"file_idnt_7",	"file_name_7",	"file_auth_7",	"vfg7",		"lfg7",		"rfg7",		"wfg7",		"mfg7",		"nfg7",		"dfg7",		"sfg7",
	"sel8",		"file_idnt_8",	"file_name_8",	"file_auth_8",	"vfg8",		"lfg8",		"rfg8",		"wfg8",		"mfg8",		"nfg8",		"dfg8",		"sfg8",
	"sel9",		"file_idnt_9",	"file_name_9",	"file_auth_9",	"vfg9",		"lfg9",		"rfg9",		"wfg9",		"mfg9",		"nfg9",		"dfg9",		"sfg9",

	"sel10",	"file_idnt_10",	"file_name_10",	"file_auth_10",	"vfg10",	"lfg10",	"rfg10",	"wfg10",	"mfg10",	"nfg10",	"dfg10",	"sfg10",
	"sel11",	"file_idnt_11",	"file_name_11",	"file_auth_11",	"vfg11",	"lfg11",	"rfg11",	"wfg11",	"mfg11",	"nfg11",	"dfg11",	"sfg11",
	"sel12",	"file_idnt_12",	"file_name_12",	"file_auth_12",	"vfg12",	"lfg12",	"rfg12",	"wfg12",	"mfg12",	"nfg12",	"dfg12",	"sfg12",
	"sel13",	"file_idnt_13",	"file_name_13",	"file_auth_13",	"vfg13",	"lfg13",	"rfg13",	"wfg13",	"mfg13",	"nfg13",	"dfg13",	"sfg13",
	"sel14",	"file_idnt_14",	"file_name_14",	"file_auth_14",	"vfg14",	"lfg14",	"rfg14",	"wfg14",	"mfg14",	"nfg14",	"dfg14",	"sfg14",
	"sel15",	"file_idnt_15",	"file_name_15",	"file_auth_15",	"vfg15",	"lfg15",	"rfg15",	"wfg15",	"mfg15",	"nfg15",	"dfg15",	"sfg15",
	"sel16",	"file_idnt_16",	"file_name_16",	"file_auth_16",	"vfg16",	"lfg16",	"rfg16",	"wfg16",	"mfg16",	"nfg16",	"dfg16",	"sfg16",
	"sel17",	"file_idnt_17",	"file_name_17",	"file_auth_17",	"vfg17",	"lfg17",	"rfg17",	"wfg17",	"mfg17",	"nfg17",	"dfg17",	"sfg17",
	"sel18",	"file_idnt_18",	"file_name_18",	"file_auth_18",	"vfg18",	"lfg18",	"rfg18",	"wfg18",	"mfg18",	"nfg18",	"dfg18",	"sfg18",
	"sel19",	"file_idnt_19",	"file_name_19",	"file_auth_19",	"vfg19",	"lfg19",	"rfg19",	"wfg19",	"mfg19",	"nfg19",	"dfg19",	"sfg19",

	NULL
};


// --------------------------------------------------------------------
// local:	The CGI arguments
// --------------------------------------------------------------------
static	CCgiArgs			cgi;
static	CMySqlConnect		db			( "quest", "", "UTCMS" );
static	CPreviewTemplate	previewtemplate;
static	dword_t				userid		= 0;
static	dword_t				sessid		= 0;
static	dword_t				pagenow		= 0;
static	dword_t				lastpage	= 0;
static	dword_t				rownumber	= 0;
static	dword_t				rowcount	= 0;
static	char				packmessage	[1024];
static	const char *		message		= NULL;
static	dword_t				packidnt	= 0;

// --------------------------------------------------------------------
// local:	Some database tables needed
// --------------------------------------------------------------------
static	CTablePref		pref;
static	CTableFile		file;
static	CTableAuth		auth;
static	CTableArep		arep;
static	CTablePack		pack;
static	CTablePackFile	packfile;
static	CTableUser		user;

// --------------------------------------------------------------------
// local:	Data associated with those tables
// --------------------------------------------------------------------
static	data_user_t		logndata		= { 0 };
static	data_file_t		filedata		= { 0 };
static	data_auth_t		authdata		= { 0 };

// --------------------------------------------------------------------
// local:	Output first part for true, last part for false
//			The parts are separated by '\' character
// --------------------------------------------------------------------
static	void	__outpart	( 	const char *	aS,
								bool			aFirst ) {
	char *	cs	= ::my_private_strdup( aS );
	char *	s	= ::strchr( cs, '|' );

	if	( s ) {
		*s = 0;
		s++;
	}
	else {
		s = "";
	}

	::printf( "%s", aFirst ? cs : s );

	delete [] cs;
}

// --------------------------------------------------------------------
// local:	Output something depending on state of a flag
// --------------------------------------------------------------------
static	void	__onflag	( 	dword_t				aU,
								const char * 		aS ) {

	if		( ! ::strncmp( aS, "DENY_READ?", 	10 ) )	__outpart( aS + 10, (aU & FLAG_DENY_READ) != 0 );
	else if	( ! ::strncmp( aS, "DENY_WRITE?",	11 ) )	__outpart( aS + 11, (aU & FLAG_DENY_WRITE) != 0 );
	else if	( ! ::strncmp( aS, "DENY_VIEW?",	10 ) )	__outpart( aS + 10, (aU & FLAG_DENY_VIEW) != 0 );
	else if	( ! ::strncmp( aS, "DENY_MOD?",		9 ) )	__outpart( aS + 9,  (aU & FLAG_DENY_MOD) != 0 );
	else if	( ! ::strncmp( aS, "DENY_REN?",		9 ) )	__outpart( aS + 9,  (aU & FLAG_DENY_REN) != 0 );
	else if	( ! ::strncmp( aS, "DENY_DEL?",		9 ) )	__outpart( aS + 9,  (aU & FLAG_DENY_DEL) != 0 );
	else if	( ! ::strncmp( aS, "FIX_FLAG?",		9 ) )	__outpart( aS + 9,  (aU & FLAG_FIX_FLAG) != 0 );
	else if	( ! ::strncmp( aS, "ACCEPTED?",		9 ) )	__outpart( aS + 9,  (aU & FLAG_ACCEPTED) != 0 );
	else if	( ! ::strncmp( aS, "BANNED?",		7 ) )	__outpart( aS + 7,  (aU & FLAG_BANNED) != 0 );
	else if	( ! ::strncmp( aS, "NOSUGGEST?",	10 ) )	__outpart( aS + 10, (aU & FLAG_NOSUGGEST) != 0 );
	else if	( ! ::strncmp( aS, "NODOWNLOAD?",	11 ) )	__outpart( aS + 11, (aU & FLAG_NODOWNLOAD) != 0 );
	else if	( ! ::strncmp( aS, "SUPERUSER?",	10 ) )	__outpart( aS + 10, (aU & FLAG_SUPERUSER) != 0 );
	else if	( ! ::strncmp( aS, "NEWSADMIN?",	10 ) )	__outpart( aS + 10, (aU & FLAG_NEWSADMIN) != 0 );
	else if	( ! ::strncmp( aS, "REVIADMIN?",	10 ) )	__outpart( aS + 10, (aU & FLAG_REVIADMIN) != 0 );
	else if	( ! ::strncmp( aS, "COMMADMIN?",	10 ) )	__outpart( aS + 10, (aU & FLAG_COMMADMIN) != 0 );
}

// --------------------------------------------------------------------
// local:	Parser questions are sent here for answering
// --------------------------------------------------------------------
static	void	__answer	( const char * aQ ) {

	// ----------------------------------------------------------------
	// Local parsing
	// ----------------------------------------------------------------
	if		( ! ::strcmp( aQ, "sessid" ) )			::printf( "%d", sessid );
	else if	( ! ::strcmp( aQ, "userid" ) )			::printf( "%d", userid );
	else if	( ! ::strcmp( aQ, "pagenow" ) )			::printf( "%d", pagenow );
	else if	( ! ::strcmp( aQ, "nextpage" ) )		::printf( "%d", pagenow + 1 );
	else if	( ! ::strcmp( aQ, "prevpage" ) )		::printf( "%d", pagenow - 1 );
	else if	( ! ::strcmp( aQ, "lastpage" ) )		::printf( "%d", lastpage );
	else if	( ! ::strcmp( aQ, "rownumber" ) )		::printf( "%d", rownumber );
	else if	( ! ::strcmp( aQ, "rowcount" ) )		::printf( "%d", rowcount );
	else if	( ! ::strcmp( aQ, "linepair" ) )		::printf( "%d", rownumber & 0x01 );

	else if	( ! ::strcmp( aQ, "message_b" ) )		::printf( "%s", message ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "message_e" ) )		::printf( "%s", message ? "" : " -->" );
	else if	( ! ::strcmp( aQ, "message" ) )			::printf( "%s", message ? message : "" );

	else if	( ! ::strcmp( aQ, "haspack_b" ) )		::printf( "%s", packidnt ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "haspack_e" ) )		::printf( "%s", packidnt ? "" : " -->" );

	// ----------------------------------------------------------------
	// The onflag directive
	// ----------------------------------------------------------------
	else if	( ! ::strncmp( aQ, "onlogflag-", 10 ) )	__onflag( logndata.user_flag, aQ + 10 );
	else if	( ! ::strncmp( aQ, "onfilflag-", 10 ) )	__onflag( filedata.file_flag, aQ + 10 );

	// ----------------------------------------------------------------
	// Paging
	// ----------------------------------------------------------------
	else if	( ! ::strcmp( aQ, "pagenext_b" ) )		::printf( "%s", pagenow < lastpage ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "pagenext_e" ) )		::printf( "%s", pagenow < lastpage ? "" : " -->" );

	else if	( ! ::strcmp( aQ, "pagenext_bx" ) )		::printf( "%s", pagenow >= lastpage ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "pagenext_ex" ) )		::printf( "%s", pagenow >= lastpage ? "" : " -->" );

	else if	( ! ::strcmp( aQ, "pageprev_b" ) )		::printf( "%s", pagenow > 1 ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "pageprev_e" ) )		::printf( "%s", pagenow > 1 ? "" : " -->" );

	else if	( ! ::strcmp( aQ, "pageprev_bx" ) )		::printf( "%s", pagenow <= 1 ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "pageprev_ex" ) )		::printf( "%s", pagenow <= 1 ? "" : " -->" );

	// ----------------------------------------------------------------
	// Parsing table data
	// ----------------------------------------------------------------
	else if	( ::MySqlTableParser( file.Layout(), "file", (const char *)(&filedata), aQ ) )	;
	else if	( ::MySqlTableParser( auth.Layout(), "auth", (const char *)(&authdata), aQ ) )	;

	// ----------------------------------------------------------------
	// Parsing the CGI data
	// ----------------------------------------------------------------
	else if	( ::cgi_parser( cgi, aQ ) )	;

	// ----------------------------------------------------------------
	// Everything else goes to default parser
	// ----------------------------------------------------------------
	else	::my_default_answer( aQ );
}

// --------------------------------------------------------------------
// local:	List files - maybe with some filtering
// --------------------------------------------------------------------
static	void	__list_files	( void ) {
	data_file_tl	list;
	data_file_tli	loop;
	char			query[1024];
	CMySqlQuote		q;
	bool			useand = false;

	// The page
	pagenow	= ::atol( cgi.Arg( "page" ) );
	if	( pagenow < 1 ) {
		cgi.Arg( "page", "1" );
		pagenow = 1;
	}

	// The pack identifier
	packidnt = ::atol( cgi.Arg( "pack_idnt" ) );
	if	( packidnt ) {
		::sprintf( query, " where pack_idnt=%d", packidnt );
		if	( pack.Count( db, query ) == 1 ) {
			if	( message ) {
				::sprintf( 	packmessage, "%s<br>&nbsp;Pack: <b><quote>%s</quote></b>",
							message,
							(*(pack.Select( db, query ).begin())).pack_name );
			}
			else {
				::sprintf( 	packmessage, "Pack: <b><quote>%s</quote></b>",
							(*(pack.Select( db, query ).begin())).pack_name );
			}
			message = packmessage;
		}
	}

	*query = 0;

	// Filtering
	if	( packidnt )							::strcat( query, ",packfile" );
	if	( cgi.Arg( "find_auth_name" )[0] != 0 )	::strcat( query, ",auth" );
	::strcat( query, " where" );

	if	( packidnt ) {
		::strcat( query, " file_idnt=packfile_file and packfile_pack=" );
		::sprintf( query + ::strlen( query ), "%d", packidnt );
		useand = true;
	}

	if	( cgi.Arg( "find_auth_name" )[0] != 0 ) {
		if	( useand )	::strcat( query, " and" );
		::strcat( query, " auth_idnt=file_auth" );
		useand = true;
	}

	if	( cgi.Arg( "find_file_name" )[0] != 0 ) {
		if	( useand )	::strcat( query, " and" );
		::strcat( query, " file_name like '%" );
		::strcat( query, q.Quote( cgi.Arg( "find_file_name" ) ) );
		::strcat( query, "%'" );
		useand = true;
	}
	if	( cgi.Arg( "find_file_type" )[0] != 0 ) {
		if	( useand )	::strcat( query, " and " );
		::strcat( query, " file_typ2 like '" );
		::strcat( query, q.Quote( cgi.Arg( "find_file_type" ) ) );
		::strcat( query, "%'" );
		useand = true;
	}
	if	( cgi.Arg( "find_file_auth" )[0] != 0 ) {
		if	( useand )	::strcat( query, " and" );
		::strcat( query, " file_auth=" );
		::strcat( query, q.Quote( cgi.Arg( "find_file_auth" ) ) );
		useand = true;
	}
	if	( cgi.Arg( "find_auth_name" )[0] != 0 ) {
		if	( useand )	::strcat( query, " and" );
		::strcat( query, " auth_name like '%" );
		::strcat( query, q.Quote( cgi.Arg( "find_auth_name" ) ) );
		::strcat( query, "%'" );
		useand = true;
	}
	if	( ! useand ) {
		::strcat( query, " file_idnt>0" );
	}

	lastpage = file.Count( db, query ) / 20 + 1;
	if	( pagenow > lastpage ) pagenow = lastpage;

	::strcat( query, " order by file_name,file_type,file_atim desc LIMIT " );
	::sprintf( query + ::strlen( query ), "%d", (dword_t)((pagenow-1) * 20) );
	::strcat( query, ",20" );

	list = file.Select( db, query );
	rowcount  = list.size();
	rownumber = 0;
	previewtemplate.Execute( __answer, "tmpl-fileadmin-list-head" );
	for	( loop = list.begin(); loop != list.end(); loop++ ) {
		filedata = *loop;

		if	( filedata.file_auth != authdata.auth_idnt ) {
			if	( filedata.file_auth == 0 ) {
				::memset( &authdata, 0, sizeof( authdata ) );
			}
			else {
				::sprintf( query, " where auth_idnt=%d", filedata.file_auth );
				if	( auth.Count( db, query ) == 1 ) {
					authdata = *(auth.Select( db, query ).begin());
				}
				else {
					::memset( &authdata, 0, sizeof( authdata ) );
				}
			}
		}

		previewtemplate.Execute( __answer, "tmpl-fileadmin-list-body" );
		rownumber++;
	}
	previewtemplate.Execute( __answer, "tmpl-fileadmin-list-tail" );
}

// --------------------------------------------------------------------
// local:	Check whether a line is selected
// --------------------------------------------------------------------
static	bool			__is_selected		( dword_t aRow ) {
	char			argnm[32];
	::sprintf( argnm, "sel%d", aRow );
	return	cgi.Exist( argnm );
}

// --------------------------------------------------------------------
// local:	Get a string value
// --------------------------------------------------------------------
static	char *			__get_string		( 	char *			aB,
												size_t			aL,
												const char *	aBase,
												dword_t			aRow ) {
	char	argnm[32];
	::sprintf( argnm, "%s%d", aBase, aRow );
	::memset( aB, 0, aL );
	::my_strfit( aB, aL, cgi.Arg( argnm ) );

	return	aB;
}

// --------------------------------------------------------------------
// local:	Get old record
// --------------------------------------------------------------------
static	data_file_t		__get_old_record	( dword_t aRow ) {
	data_file_t		data;
	char			buf	[32];
	CMySqlWhere		w;

	w << "file_idnt=" << (dword_t)::atol( __get_string( buf, sizeof( buf ), "file_idnt_", aRow ) );
	if	( file.Count( db, w ) == 1 ) {
		data = *( file.Select( db, w ).begin() );
	}
	else {
		::memset( &data, 0, sizeof( data ) );
	}

	return	data;
}

// --------------------------------------------------------------------
// local:	Get flag value
// --------------------------------------------------------------------
static	dword_t			__flag_value		(	const char *	aBase,
												dword_t			aRow,
												dword_t			aFlag ) {
	char	argnm[32];
	::sprintf( argnm, "%s%d", aBase, aRow );
	return	(dword_t)( cgi.Exist( argnm ) ? aFlag : 0 );
}

// --------------------------------------------------------------------
// local:	Get new record
// --------------------------------------------------------------------
static	data_file_t		__get_new_record	( dword_t aRow ) {
	data_file_t		data	= __get_old_record( aRow );
	char			buff	[64];

	__get_string( data.file_name, sizeof( data.file_name ), "file_name_", aRow );
	data.file_auth = ::atol( __get_string( buff, sizeof( buff ), "file_auth_", aRow ) );
	data.file_flag = data.file_flag & ( (	FLAG_DENY_VIEW |
											FLAG_NODOWNLOAD|
											FLAG_DENY_READ |
											FLAG_DENY_WRITE |
											FLAG_DENY_MOD |
											FLAG_DENY_REN |
											FLAG_DENY_DEL |
											FLAG_NOSUGGEST ) ^ 0xffffffff );

	data.file_flag |= __flag_value( "vfg", aRow, FLAG_DENY_VIEW );
	data.file_flag |= __flag_value( "lfg", aRow, FLAG_NODOWNLOAD );
	data.file_flag |= __flag_value( "rfg", aRow, FLAG_DENY_READ );
	data.file_flag |= __flag_value( "wfg", aRow, FLAG_DENY_WRITE );
	data.file_flag |= __flag_value( "mfg", aRow, FLAG_DENY_MOD );
	data.file_flag |= __flag_value( "nfg", aRow, FLAG_DENY_REN );
	data.file_flag |= __flag_value( "dfg", aRow, FLAG_DENY_DEL );
	data.file_flag |= __flag_value( "sfg", aRow, FLAG_NOSUGGEST );

	return	data;
}


// --------------------------------------------------------------------
// local:	Update changed data
// --------------------------------------------------------------------
static	void	__update_files	( void ) {
	dword_t		rowid;
	data_file_t	oldrec;
	data_file_t	newrec;
	data_auth_t	authdata;
	data_arep_t	arepdata;
	bool		updated	= false;
	CMySqlWhere		w;

	for	( rowid = 0; rowid < 20; rowid++ ) {
		if	( __is_selected( rowid ) ) {
			oldrec = __get_old_record( rowid );
			newrec = __get_new_record( rowid );

			w = "";
			w << "auth_idnt=" << newrec.file_auth;
			if	( auth.Count( db, w ) != 1 )	newrec.file_auth = oldrec.file_auth;
			else {
				CAuthor	myauthor;

				authdata = *( auth.Select( db, w ).begin() );
				myauthor.SetNames( authdata.auth_name );

				::memset( &arepdata, 0, sizeof( arepdata ) );
				::strcpy( arepdata.arep_find, newrec.file_csum );
				::strcpy( arepdata.arep_fnam, myauthor.FirstName() ? myauthor.FirstName() : "" );
				::strcpy( arepdata.arep_nnam, myauthor.NickName()  ? myauthor.NickName()  : "" );
				::strcpy( arepdata.arep_lnam, myauthor.LastName()  ? myauthor.LastName()  : "" );

				arep.Delete( db, &arepdata );
				arep.Insert( db, &arepdata );
			}

			if	( ::memcmp( &oldrec, &newrec, sizeof( oldrec ) ) ) {
				newrec.file_mtim = ::time( NULL );
				file.Update( db, &newrec );
				updated = true;
			}
		}
	}

	if	( updated )	message = "Entries updated";
	else			message = "<b>Nothing updated</b>";
	__list_files();
}

// --------------------------------------------------------------------
// local:	Delete selected files
// --------------------------------------------------------------------
static	void	__delete_files	( void ) {
	dword_t		rowid;
	bool		updated	= false;
	CStorage	storage;
	data_file_t	oldrec;

	for	( rowid = 0; rowid < 20; rowid++ ) {
		if	( __is_selected( rowid ) ) {
			oldrec = __get_old_record( rowid );
			storage.Delete( oldrec.file_idnt );
		}
	}

	if	( updated )	message = "Entries deleted";
	else			message = "<b>Nothing deleted</b>";
	__list_files();
}

// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {
	::srand( (unsigned int)::time( NULL ) );
	try	{
		CSession	session(	cgi, 
								"tmpl-fileadmin-logn",
								cgi.Arg("forw"),
								"./regsaves",
								saveargs );

		if	( session.Check() ) {

			// --------------------------------------------------------
			// First we make a copy of the logged in user record
			// --------------------------------------------------------
			logndata = session.UserData();

			// --------------------------------------------------------
			// Only superuser can log in here
			// --------------------------------------------------------
			if	( (logndata.user_flag & FLAG_SUPERUSER) == 0 ) {
				throw	CError( "You are not a superuser" );
			}

			// --------------------------------------------------------
			// Also, collect other useful information of the session
			// --------------------------------------------------------
			userid	= session.User();
			sessid	= session.SessId();

			switch	( ::atol( cgi.Arg( "task" ) ) ) {

				case	0:	// List
				::HTTP_text( "en" );
				__list_files();
				break;

				case	1:	// Update
				::HTTP_text( "en" );
				__update_files();
				break;

				case	2:	// Delete
				::HTTP_text( "en" );
				__delete_files();
				break;
			}
		}
    }

	catch	( CError e ) {
		::HTTP_text( "en" );
		::printf( "ERROR: %s", e.Error() );
	}

    catch   ( ... ) {
		::HTTP_text( "en" );
		::printf( "Failed to execute administering program" );
    }

    return	0;
}

// --------------------------------------------------------------------
// EOF: FileAdmin.cxx
// --------------------------------------------------------------------
