// --------------------------------------------------------------------
// Identify.cxx
// Whatis:  Identifies files
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 02-JUN-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include	"CIdentifyFile.hxx"

// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {
	int	result	= 0;

	try	{
		int		arg = 1;
		while	( arg < aAc ) {
			{
				CIdentifyFile	ident( aAv[arg] );

				::printf( "-----------------------------------------\n" );
				::printf( "File name : %s\n", ident.FileName() );
				::printf( "File type : [%d] %s\n", ident.Type().type_idnt, ident.Type().type_name );
				::printf( "Type1     : %s\n", ident.Typ1() );
				::printf( "Type2     : %s\n", ident.Typ2() );
				::printf( "Path      : %s\n", ident.Path() );
				::printf( "Name      : %s\n", ident.Name() );
				::printf( "Suffix    : %s\n", ident.Suff() );
				::printf( "Author    : %s\n", ident.Author() );
				::printf( "Version   : %d\n", ident.PackageVersion() );
				::printf( "Licencee  : %d\n", ident.LicenseeMode() );
			}
			arg++;
		}
		::printf( "-----------------------------------------\n" );
    }

    catch   ( CError e ) {
		::printf( "UnrImport: ERROR: %s\n", e.Error() );
        result = -1;
    }

    catch   ( ... ) {
		::printf( "UnrImport: ERROR: Abort\n" );
        result = -1;
    }

    return  result;
}

// --------------------------------------------------------------------
// EOF: UnrImport.cxx
// --------------------------------------------------------------------
