// --------------------------------------------------------------------
// Login.cxx
// Whatis:  CGI for logging in a user
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 14-JUN-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CSession.hxx"
#include	"CCgiArgs.hxx"

// --------------------------------------------------------------------
// local:	The CGI arguments
// --------------------------------------------------------------------
static	CCgiArgs		cgi;

// --------------------------------------------------------------------
// local:	Do a redirection after non-succesful login
// --------------------------------------------------------------------
static	void	__forward	( 	const char * 	aTargPage,
								dword_t			aUserId,
								dword_t			aSessId ) {
	::HTTP_html( "en" );
	::printf( "<html>\n" );
	::printf( "\t<head>\n" );
	::printf( "\t\t<title>Login</title>\n" );
	::printf( "\t</head>\n" );
	::printf( "\t<body bgcolor=\"#1b003e\" onload=\"document.location.replace('%s?user=%d&sess=%d');\">\n", aTargPage, aUserId, aSessId );
	::printf( "\t\t<center><b><font color=\"Yellow\">Processing</font></b></center>\n" );
	::printf( "\t</body>\n" );
	::printf( "</html>\n" );
}

// --------------------------------------------------------------------
// local:	Log in
// --------------------------------------------------------------------
static	void	__login	( void ) {
	CSession	session(	cgi,
							"tmpl-login",
							cgi.Arg("forw"),
							NULL,
							NULL );

	if	( session.Check() ) {
		__forward( 	cgi.Arg("forw"),
					session.User(),
					session.SessId() );
	}
}

// --------------------------------------------------------------------
// local:	Log in
// --------------------------------------------------------------------
static	void	__login_cookie	( void ) {
	CSession	session(	cgi,
							"tmpl-login",
							cgi.Arg( "forw" ),
							NULL,
							NULL );

	if	( session.Check() ) {
		CMySqlConnect	db( "quest", "", "UTCMS" );
		CTableUser		user;
		data_user_t		data = session.UserData();

		if	( ( data.user_flag & FLAG_USECOOKIES ) == 0 ) {
			data.user_flag = data.user_flag | FLAG_USECOOKIES;
			user.Update( db, &data );
			session.CreateCookie( db, cgi );
		}

		__forward( 	cgi.Arg("forw"),
					session.User(),
					session.SessId() );
	}
}

// --------------------------------------------------------------------
// local:	Log in
// --------------------------------------------------------------------
static	void	__logout	( void ) {
	CSession	session( cgi );
	if	( session.Check() ) {
		session.Logout( cgi );
	}
	__forward( cgi.Arg("forw"), 0, 0 );
}

// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {
	::srand( (unsigned int)::time( NULL ) );
	try	{
		switch	( ::atol( cgi.Arg( "task" ) ) ) {
			case	1:	// Login
			__login();
			break;

			case	1337:	// Login and set cookie
			__login_cookie();
			break;

			default:
			__logout();
			break;

		}
    }


    catch   ( CError e ) {
		::HTTP_html( "en" );
		::printf( "Error : %s\n", e.Error() );
    }

    catch   ( ... ) {
		::HTTP_html( "en" );
		::printf( "Error : Unknown\n" );
    }

    return	0;
}

// --------------------------------------------------------------------
// EOF: Storage.cxx
// --------------------------------------------------------------------
