// --------------------------------------------------------------------
// MServerPoll.cxx
// Whatis:  Poll Master servers
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 27-APR-2003     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include	"CUnMasterServer.hxx"
#include	"CTableSrvr.hxx"
#include	"CMySqlWhere.hxx"


//---------------------------------------------------------------------------
static	bool	__poll_game_server(		data_srvr_t &					aData,
										const CUnMasterServerItem_t &	aItem ) {
	bool	result = true;

	::memset( &aData, 0, sizeof( aData ) );

	try	{
		CUnServerInfo	myinfo( aItem.IpAddress(), aItem.QueryPort(), aItem.ServerType() );

		if	( myinfo.GamePort() != 0 ) {
			::my_strfit( aData.srvr_addr, sizeof( aData.srvr_addr ) - 1, myinfo.IpAddress() );
			::my_strfit( aData.srvr_name, sizeof( aData.srvr_name ) - 1, myinfo.ServerName() );
			::my_strfit( aData.srvr_gmap, sizeof( aData.srvr_gmap ) - 1, myinfo.GameMap() );
			::my_strfit( aData.srvr_gttl, sizeof( aData.srvr_gttl ) - 1, myinfo.MapTitle() );
			::my_strfit( aData.srvr_gtyp, sizeof( aData.srvr_gtyp ) - 1, myinfo.GameType() );
			aData.srvr_pcur = myinfo.CurrentPlayers();
			aData.srvr_pmax = myinfo.MaximumPlayers();
			aData.srvr_time = ::time( NULL );
			aData.srvr_port = myinfo.GamePort();
			aData.srvr_quep = myinfo.QueryPort();
			switch	( aItem.ServerType() ) {
				case	unreal_server_ut:	::strcpy( aData.srvr_type, "UT" );		break;
				case	unreal_server_2003:	::strcpy( aData.srvr_type, "UT2003" );	break;
			}
		}

		else {
			result = false;			
		}
	}

	catch	( ... ) {
		result = false;
	}

	return	result;
}

//---------------------------------------------------------------------------
static	void	__poll_master_server(	const char *	aIp,
										word_t			aPort,
										unreal_server_t	aType ) {
	CMySqlConnect				db( "quest", "", "UTCMS" );
	CTableSrvr					srvr;
	data_srvr_t					data;
	CMySqlWhere					w;
	CUnMasterServerItem_tlci	loop;

	try	{
		CUnMasterServer				master( aIp, aPort, aType );

	    for	( 	loop  = master.ServerList().begin();
	            loop != master.ServerList().end();
	            loop++ ) {

			// Check if this server already exists in the database
			w = "";
			w << "srvr_addr='" << (*loop).IpAddress() << "' and srvr_quep=" << (dword_t)( (*loop).QueryPort() );
			if	( srvr.Count( db, w ) > 0 )	continue;

			if	( __poll_game_server( data, *loop ) ) {

				// Check again as the ports may have changed
				w = "";
				w << "srvr_addr='" << data.srvr_addr << "' and srvr_quep=" << data.srvr_quep;
				if	( srvr.Count( db, w ) > 0 )	continue;
				srvr.Insert( db, &data );
			}
		}
	}

	catch	( ... ) {
	}
}

//---------------------------------------------------------------------------
static	void	__process( void ) {
	time_t	timenow;
	while	( true ) {
		__poll_master_server( "unreal.epicgames.com", 	28900, unreal_server_ut );
		__poll_master_server( "master.gamespy.com", 	28900, unreal_server_ut );
		__poll_master_server( "master.mplayer.com", 	28900, unreal_server_ut );


		// Rest one day
		timenow = ::time( NULL ) + 60 * 60 * 24;
		while	( timenow > ::time( NULL ) ) {
			SLEEP( 1000 );
		}
	}
}

//---------------------------------------------------------------------------
int main(int argc, char* argv[]) {
	::daemon( 1, 0 );
	__process();
    return  0;
}

// --------------------------------------------------------------------
// EOF: MServerPoll.cxx
// --------------------------------------------------------------------
