// --------------------------------------------------------------------
// MapInfoShot.cxx
// Whatis:  CGI for extracting a map information shot from an UNR file
// CGI arguments:
//
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 14-JUN-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CPreviewFile.hxx"
#include    "CPreviewShots.hxx"
#include    "CPreviewLevelInfo.hxx"
#include	"CCgiArgs.hxx"
#include	"CMySqlWhere.hxx"
#include	"CUnUtils.hxx"
#include	"CPicture.hxx"
#include	"CPictureFilterScale.hxx"
#include	"CPictureDrawerText.hxx"
#include	"CPictureSourceJPG.hxx"
#include	"CPictureSourceUTX.hxx"
#include	"CPictureFilterAlphaBlend.hxx"
#include	"CFurpileLogo.hxx"

// --------------------------------------------------------------------
// local:	The local data
// --------------------------------------------------------------------
static	CCgiArgs			cgi;
static	CMySqlConnect		db		( "quest", "", "UTCMS" );
static	CPreviewFile		previewfile;
static	CPreviewLevelInfo	previewlevelinfo;
static	char				imagefile	[1024] = { 0 };

// --------------------------------------------------------------------
// local:	Create the image with the screenshot and the file info
// --------------------------------------------------------------------
static	void	__create_image	( void ) {

	// Set up image file name. This is temporary file.
	struct	stat	mystat;
	do	{
		sprintf( imagefile, "%d.jpg", (dword_t)::rand() );
	}	while	( ! ::stat( imagefile, &mystat ) );

	// Let's begin with the image - it is 512 x 256 + the frames 3 pixels wide
	CPicture	mypicture( (dword_t)(512 + 9), (dword_t)(256 + 9) );

	// Plant the screenshot(s) into the picture
	dword_t			shotnum;
	dword_t			ypos;
	dword_t			sx, sy;
	CUnLevelInfo *	linfo	= previewlevelinfo.LevelInfo();
	for	(	shotnum = 0, ypos = 3;
			( shotnum < 2 ) && ( shotnum < linfo->ShotCount() );
			shotnum++ ) {
		CPicture			shotpic;
		CPictureSourceUTX	shotutx( linfo->Screenshot( shotnum ) );
		shotpic.Load	( shotutx );

		// Scale the picture down in case it is too wide
		if	( shotpic.W() != 256 ) {
			dword_t				new_w	= 256;
			dword_t				new_h	= (dword_t)( (double)shotpic.H() * ( 256.0 / (double)shotpic.W() ) );
			CPictureFilterScale	scaler( new_w, new_h );
			shotpic.Filter( scaler );
		}

		// Plant the image in the picture if it fits in there
		if	( shotpic.H() + ypos > 512 )	break;


		for	( sy = 0; sy < shotpic.H(); sy++ ) {
			for	( sx = 0; sx < shotpic.W(); sx++ ) {
				mypicture.Pixel(	3 + sx, ypos + sy,
									shotpic.PixmapRef().Pixel( sx, sy ) );
			}
		}

		ypos = ypos + 3 + shotpic.H();
	}

	// Draw the textual information on the image
	CPictureDrawerText	mytext;

	// It'll be yellow text with black background
	CPicturePixel		mycolor;

	mycolor = "FFFF00FF";	mytext.FG( mycolor );
	mycolor = "000000FF";	mytext.BG( mycolor );

	// First the map file name
	mytext.Text( previewfile.File().file_name );
	mypicture.Draw( 256 + 10, 3, mytext );




	// Plant the furpile logo
	CFurpileLogo		mylogo( "Furpile.utx" );
	mylogo.Plant( mypicture.PixmapRef() );

	// Save the picture as JPG
	CPictureSourceJPG	myjpg( imagefile, 70 );
	mypicture.Save	( myjpg );
}

// --------------------------------------------------------------------
// local:	Send the image
// --------------------------------------------------------------------
static	void	__send_image	( void ) {
	struct	stat	mystat;

	if	( ::stat( imagefile, &mystat ) ) {
		throw CError( imagefile, ::strerror( errno ) );
	}

	FILE *	strm = ::fopen( imagefile, "rb" );
	if	( ! strm ) {
		throw CError( imagefile, ::strerror( errno ) );
	}

	::HTTP_image( "jpeg", mystat.st_size );
	int		chr;
	while	( ! feof( strm ) ) {
		chr = ::fgetc( strm );
		if	( chr >= 0 ) {
			::putchar( chr );
		}
	}
	::fclose( strm );
}

// --------------------------------------------------------------------
// public:  Program entrypoint
// Arguments: file_idnt=idnt the file identifier
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {
	::srand( (unsigned int)::time( NULL ) );

	try	{
		// Load the file we are going to preview
		previewfile.Load( ::atol( cgi.Arg( "file_idnt" ) ) );

		// Load the level info
		previewlevelinfo.Load(	previewfile.FilePath() );

		// Create and send the image
		__create_image();
		__send_image();

		if	( *imagefile )	::unlink( imagefile );
	}

	catch 	( CError e ) {
		::HTTP_text( "en" );
		::printf( "<p>Error: " );
		::HTML_quote( e.Error() );
		::printf( "</p>" );
		if	( *imagefile )	::unlink( imagefile );
		::fflush( stdout );
		::fclose( stdout );
		return	-1;
	}

	catch	( ... ) {
		::HTTP_text( "en" );
		::printf( "<p>Error: Unknown error</p>" );
		if	( *imagefile )	::unlink( imagefile );
		::fflush( stdout );
		::fclose( stdout );
		return	-1;
	}
	::fflush( stdout );
	::fclose( stdout );
    return	0;
}

// --------------------------------------------------------------------
// EOF: MapInfoShot.cxx
// --------------------------------------------------------------------
