// --------------------------------------------------------------------
// UserAdmin.cxx
// Whatis:  CGI for administering teh news
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 15-SEP-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CSession.hxx"
#include    "CStorage.hxx"
#include    "CIdentifyFile.hxx"
#include	"CCgiArgs.hxx"
#include	"CCache.hxx"
#include	"CMySqlWhere.hxx"
#include    "CPreviewTemplate.hxx"
#include    "CPreviewText.hxx"
#include	"CTableUser.hxx"
#include	"CTableNews.hxx"

// --------------------------------------------------------------------
// local:	The CGI arguments
// --------------------------------------------------------------------
static	CCgiArgs			cgi;
static	CMySqlConnect		db			( "quest", "", "UTCMS" );
static	CCache				pvcache		( "preview" );
static	CPreviewTemplate	previewtemplate;
static	CPreviewText		previewtext;

static	dword_t				rownumber	= 0;
static	dword_t				text_idnt	= 0;

static	CTableUser			user;
static	data_user_t			userdata;

static	CTableNews			news;
static	data_news_t			newsdata;


// --------------------------------------------------------------------
// local:	Parser questions are sent here for answering
// --------------------------------------------------------------------
static	void	__answer	( const char * aQ ) {

	// ----------------------------------------------------------------
	// Local parsing
	// ----------------------------------------------------------------
	if		( ! ::strcmp( aQ, "linepair" ) )	::printf( "%d", rownumber & 0x01 );
	else if	( ! ::strcmp( aQ, "poetry" ) ) {
		if	( text_idnt ) previewtext.OutputUBB( text_idnt );
	}

	// ----------------------------------------------------------------
	// Parsing the table data
	// ----------------------------------------------------------------
	else if	( ::MySqlTableParser( user.Layout(), "user", (const char *)(&userdata), aQ ) )	;
	else if	( ::MySqlTableParser( news.Layout(), "news", (const char *)(&newsdata), aQ ) )	;

	// ----------------------------------------------------------------
	// Parsing the CGI data
	// ----------------------------------------------------------------
	else if	( ::cgi_parser( cgi, aQ ) )	;

	// ----------------------------------------------------------------
	// Everything else goes to default parser
	// ----------------------------------------------------------------
	else	::my_default_answer( aQ );
}

// --------------------------------------------------------------------
// local:	List news entries
// --------------------------------------------------------------------
static	void	__list_news	( void ) {
	data_user_tl	ulist;
	data_news_tl	nlist;
	data_news_tli	nloop;
	CMySqlWhere		w;

	nlist = news.Select( db, " where to_days(now()) - to_days(news_time) < 7 order by news_time desc" );

	previewtemplate.Execute( __answer, "tmpl-news-head" );

	rownumber = 0;
	for	( nloop = nlist.begin(); nloop != nlist.end(); nloop++ ) {
		newsdata = *nloop;

		text_idnt= newsdata.news_file;

		w = "";
		w << "user_idnt=" << (*nloop).news_user;
		ulist = user.Select( db, w );
		if	( ulist.size() == 0 )	continue;

		userdata = *(ulist.begin());

		previewtemplate.Execute( __answer, "tmpl-news-body" );
		rownumber++;
	}

	previewtemplate.Execute( __answer, "tmpl-news-tail" );
}

// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {
	::srand( (unsigned int)::time( NULL ) );
	::HTTP_text( "en" );
	try	{
		switch	( ::atol( cgi.Arg( "task" ) ) ) {
			case	0:	// List the news
			__list_news();
			break;
		}
    }

	catch	( CError e ) {
		::HTTP_text( "en" );
		::printf( "ERROR: %s", e.Error() );
	}

    catch   ( ... ) {
		::HTTP_text( "en" );
		::printf( "Failed !" );
    }

	::fflush( stdout );
	::fclose( stdout );
    return	0;
}

// --------------------------------------------------------------------
// EOF: Storage.cxx
// --------------------------------------------------------------------
