// --------------------------------------------------------------------
// UserAdmin.cxx
// Whatis:  CGI for administering teh news
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 15-SEP-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CSession.hxx"
#include    "CStorage.hxx"
#include    "CIdentifyFile.hxx"
#include	"CCgiArgs.hxx"
#include	"CCache.hxx"
#include	"CMySqlWhere.hxx"
#include    "CPreviewTemplate.hxx"
#include    "CPreviewText.hxx"
#include	"CTableUser.hxx"
#include	"CTableFile.hxx"
#include	"CTableNews.hxx"

// --------------------------------------------------------------------
// local:	The CGI arguments
// --------------------------------------------------------------------
static	CCgiArgs			cgi;
static	CMySqlConnect		db			( "quest", "", "UTCMS" );
static	CCache				pvcache		( "preview" );
static	CPreviewTemplate	previewtemplate;
static	CPreviewText		previewtext;

static	dword_t				sessid		= 0;
static	dword_t				userid		= 0;
static	dword_t				taskid		= 0;
static	dword_t				rownumber	= 0;
static	dword_t				text_idnt	= 0;

static	CTableUser			user;
static	data_user_t			userdata;

static	CTableNews			news;
static	data_news_t			newsdata;


// --------------------------------------------------------------------
// local:	Save argument name list
// --------------------------------------------------------------------
static	const char *	saveargs[] = {
	"forw", "mess", "news", "p_title", "p_poetry",
	NULL
};

// --------------------------------------------------------------------
// local:	Parser questions are sent here for answering
// --------------------------------------------------------------------
static	void	__answer	( const char * aQ ) {

	// ----------------------------------------------------------------
	// Local parsing
	// ----------------------------------------------------------------
	if		( ! ::strcmp( aQ, "sessid" ) )		::printf( "%d", sessid );
	else if	( ! ::strcmp( aQ, "userid" ) )		::printf( "%d", userid );
	else if	( ! ::strcmp( aQ, "taskid" ) )		::printf( "%d", taskid );
	else if	( ! ::strcmp( aQ, "linepair" ) )	::printf( "%d", rownumber & 0x01 );
	else if	( ! ::strcmp( aQ, "poetry" ) ) {
		if	( text_idnt ) previewtext.OutputHttpBr( text_idnt );
	}
	else if	( ! ::strcmp( aQ, "message_b" ) )	::printf( "%s", cgi.Exist( "mess" ) ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "message_e" ) )	::printf( "%s", cgi.Exist( "mess" ) ? "" : " -->" );

	// ----------------------------------------------------------------
	// Parsing the table data
	// ----------------------------------------------------------------
	else if	( ::MySqlTableParser( user.Layout(), "user", (const char *)(&userdata), aQ ) )	;
	else if	( ::MySqlTableParser( news.Layout(), "news", (const char *)(&newsdata), aQ ) )	;

	// ----------------------------------------------------------------
	// Parsing the CGI data
	// ----------------------------------------------------------------
	else if	( ::cgi_parser( cgi, aQ ) )	;

	// ----------------------------------------------------------------
	// Everything else goes to default parser
	// ----------------------------------------------------------------
	else	::my_default_answer( aQ );
}

// --------------------------------------------------------------------
// local:	Make a forwarding call after manipulating the user data
// --------------------------------------------------------------------
static	void	__forward	( const char * aWhere ) {
	::HTTP_html( "en" );
	::printf( "<html>\n" );
	::printf( "\t<head>\n" );
	::printf( "\t\t<title>Redirecting</title>\n" );
	::printf( "\t</head>\n" );
	if	( sessid != 0 ) {
		dword_t	saveid = cgi.Save( "./regsaves", saveargs );
		::printf( "\t<body bgcolor=\"#1b003e\" onload=\"document.location.replace('%s?sess=%d&user=%d&save=%d&task=%d');\">\n", aWhere, sessid, userid, saveid, taskid );
	}
	else {
		::printf( "\t<body bgcolor=\"#1b003e\" onload=\"document.location.replace('%s');\">\n", aWhere );
	}
	::printf( "\t\t<center><font color=\"Yellow\"><b>Processing</b></font></center>\n" );
	::printf( "\t</body>\n" );
	::printf( "</html>\n" );
}

// --------------------------------------------------------------------
// local:	List news entries for superuser
// --------------------------------------------------------------------
static	void	__list_news	( void ) {
	CMySqlWhere		w;
	data_user_tl	ulist;
	data_news_tl	nlist;
	data_news_tli	nloop;

	nlist = news.Select( db, " order by news_time desc" );
	previewtemplate.Execute( __answer, "tmpl-newsadmin-list-head" );

	rownumber = 0;
	for	( nloop = nlist.begin(); nloop != nlist.end(); nloop++ ) {
		newsdata = *nloop;

		w = "";
		w << "user_idnt=" << (*nloop).news_user;
		ulist = user.Select( db, w );
		if	( ulist.size() == 0 )	continue;

		userdata = *(ulist.begin());

		previewtemplate.Execute( __answer, "tmpl-newsadmin-list-body" );
		rownumber++;
	}

	previewtemplate.Execute( __answer, "tmpl-newsadmin-list-tail" );
}

// --------------------------------------------------------------------
// local:	Edit the news entry
// --------------------------------------------------------------------
static	void	__edit_news	( void ) {
	CMySqlWhere		w;
	data_news_tl	nlist;
	dword_t			news_idnt	= ::atol( cgi.Arg( "news" ) );

	// Get current posting if it exists
	if	( news_idnt ) {
		w << "news_idnt=" << news_idnt;
		nlist = news.Select( db, w );
		if	( nlist.size() > 0 ) {
			newsdata = *(nlist.begin());
			text_idnt = newsdata.news_file;
		}
	}
	else {
		w << "news_user=" << userdata.user_idnt;
		nlist = news.Select( db, w );
		if	( nlist.size() > 0 ) {
			newsdata = *(nlist.begin());
			text_idnt = newsdata.news_file;
		}
	}
	previewtemplate.Execute( __answer, "tmpl-newsadmin-data" );
}

// --------------------------------------------------------------------
// local:	Create an entirely new news entry - only for superuser
// --------------------------------------------------------------------
static	bool	__create_news	( void ) {
	if	( ( userdata.user_flag & FLAG_SUPERUSER ) == 0 )	return false;

	::memset( &newsdata, 0, sizeof( newsdata ) );
	newsdata.news_file = 0;
	newsdata.news_time = ::time( NULL );
	newsdata.news_user = userdata.user_idnt;
	newsdata.news_idnt = news.NextIdnt( db );
	news.Insert( db, &newsdata );
	cgi.Arg( "news", newsdata.news_idnt );

	return true;
}

// --------------------------------------------------------------------
// local:	Save a news entry
// --------------------------------------------------------------------
static	bool	__save_news	( void ) {
	CStorage		storage;
	CTableFile		file;
	CMySqlWhere		w;
	CMySqlQuote		q;
	data_news_tl	nlist;
	dword_t			news_idnt	= ::atol( cgi.Arg( "news" ) );
	dword_t			newsuser	= userdata.user_idnt;

	// Get current posting if it exists
	if	( news_idnt ) {
		w << "news_idnt=" << news_idnt;
		nlist = news.Select( db, w );
		if	( nlist.size() > 0 ) {
			newsdata = *(nlist.begin());
			newsuser = newsdata.news_user;
		}
		else {
			news_idnt = 0;
			newsuser = userdata.user_idnt;
		}
	}

	if	( ! news_idnt ) {
		w = "";
		w << "news_user=" << userdata.user_idnt;
		nlist = news.Select( db, w );
		if	( nlist.size() > 0 ) {
			newsdata = *(nlist.begin());
			newsuser = newsdata.news_user;
			news_idnt = newsdata.news_idnt;
		}
		else {
			news_idnt = 0;
			newsuser = userdata.user_idnt;
		}
	}

	if	( newsuser == 0 )	newsuser = userdata.user_idnt;

	// If no posting text - something is wrong
	if	( (cgi.Arg( "p_poetry" ))[0] == 0 ) {
		cgi.Arg( "mess", "News posting without text?" );
		return false;
	}

	// If no posting title - something is wrong
	if	( (cgi.Arg( "p_title" ))[0] == 0 ) {
		cgi.Arg( "mess", "News posting without title?" );
		return false;
	}

	// If we are editing an existing posting we must remove the original first
	if	( news_idnt != 0 ) {
		news.Delete( db, &newsdata );
		if	( newsdata.news_file ) {
			storage.Delete( newsdata.news_file );
		}
	}

	// Save the text into a file
	char			tempfile	[1024];
	char			poetryname	[1024];
	data_file_t		poetry;

	::memset( &poetry, 0, sizeof( poetry ) );
	::sprintf( tempfile, "./upload/%d-news.txt", newsuser );
	::sprintf( poetryname, "%d-news.txt", newsuser );

	::unlink( tempfile );
	FILE *	stg = ::fopen( tempfile, "wb" );

	::fprintf( stg, "%s", cgi.Arg( "p_poetry" ) );
	::fclose( stg );

	CIdentifyFile	ident( tempfile );

	poetry = storage.Save( poetryname, FLAG_NODOWNLOAD, tempfile );
	::strcpy( poetry.file_typ1, ident.Typ1() );
	::strcpy( poetry.file_typ2, ident.Typ2() );
	::strcpy( poetry.file_ctgr, ident.Ctgr() );
	poetry.file_type = ident.Type().type_idnt;
	file.Update( db, &poetry );

	::unlink( tempfile );
	::memset( &newsdata, 0, sizeof( newsdata ) );

	newsdata.news_file = poetry.file_idnt;
	newsdata.news_time = ::time( NULL );
	newsdata.news_user = newsuser;
	::my_strfit( newsdata.news_titl, sizeof( newsdata.news_titl ), cgi.Arg( "p_title" ) );
	newsdata.news_idnt = news.NextIdnt( db );
	news.Insert( db, &newsdata );
	
	return true;
}

// --------------------------------------------------------------------
// local:	Delete the news entry
// --------------------------------------------------------------------
static	void	__delete_news	( void ) {
	CStorage		storage;
	CMySqlWhere		w;
	data_news_tl	nlist;
	dword_t			news_idnt	= ::atol( cgi.Arg( "news" ) );

	// Get current posting if it exists
	if	( ! news_idnt )	return;

	w << "news_idnt=" << news_idnt;
	nlist = news.Select( db, w );
	if	( nlist.size() < 1 )	return;

	newsdata = *(nlist.begin());

	// First we ensure that the user has the right to do this
	// He has right if:
	// he is a superuser
	// is deleting his own post
	// is adding a post and has no post during the last week
	if	( ( userdata.user_flag & FLAG_SUPERUSER ) == 0 ) {
		if	( userdata.user_idnt != newsdata.news_user ) {
			cgi.Arg( "mess", "You can only delete Your own news" );
			return;
		}
	}

	news.Delete( db, &newsdata );
	if	( newsdata.news_file ) {
		storage.Delete( newsdata.news_file );
	}
}

// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {
	::srand( (unsigned int)::time( NULL ) );
	try	{
		CSession	session( cgi );
		if		( session.Check() == false ) {
			if	( ! ::strcmp( cgi.Arg( CGI_REQUEST_METHOD ), "POST" ) ) {
				__forward( cgi.Arg( "forw" ) );
			}
			else {
				::HTTP_text( "en" );
				previewtemplate.Execute( __answer, "tmpl-newsadmin-logn" );
			}
		}

		else if	( ! ::strcmp( cgi.Arg( CGI_REQUEST_METHOD ), "POST" ) ) {
			userdata	= session.UserData();
			userid		= session.User();
			sessid		= session.SessId();
			taskid		= ::atol( cgi.Arg( "task" ) );

			if	( taskid < 1 )	taskid = 1;	// Cookie ?

			if		( ( userdata.user_flag & FLAG_NEWSADMIN ) == 0 )	sessid = 0;
			else if	( ( userdata.user_flag & FLAG_DENY_VIEW ) != 0 )	sessid = 0;
			__forward( cgi.Arg( "forw" ) );
		}

		else {
			userdata	= session.UserData();
			userid		= session.User();
			sessid		= session.SessId();
			taskid		= ::atol( cgi.Arg( "task" ) );
			if	( cgi.Exist( "save" ) ) {
				cgi.Load( "./regsaves", saveargs, ::atol( cgi.Arg( "save" ) ) );
			}

			if	( taskid < 1 )	taskid = 1;	// Cookie ?

			if		( ( userdata.user_flag & FLAG_NEWSADMIN ) == 0 )	sessid = 0;
			else if	( ( userdata.user_flag & FLAG_DENY_VIEW ) != 0 )	sessid = 0;

			if	( ! sessid ) {
				__forward( cgi.Arg( "forw" ) );
			}

			// --------------------------------------------------------
			// What should we do ?
			// --------------------------------------------------------
			else {
				::HTTP_text( "en" );
				switch	( taskid ) {
					case	0:	// User did just log in
					taskid = 1;
	
					case	1:	// The superuser gets list, other's get their last post
					previewtemplate.Execute( __answer, "tmpl-newsadmin-head" );
					if	( userdata.user_flag & FLAG_SUPERUSER )	__list_news();
					else										__edit_news();
					previewtemplate.Execute( __answer, "tmpl-newsadmin-tail" );
					break;
	
					case	2:	// Edit a news entry - output the form
					previewtemplate.Execute( __answer, "tmpl-newsadmin-head" );
					__edit_news();
					previewtemplate.Execute( __answer, "tmpl-newsadmin-tail" );
					break;
	
					case	3:	// Create a news entry - output the form
					previewtemplate.Execute( __answer, "tmpl-newsadmin-head" );
					if	( __create_news() )	__edit_news();
					else					__list_news();
					previewtemplate.Execute( __answer, "tmpl-newsadmin-tail" );
					break;
	
					case	4:	// Remove a news entry
					previewtemplate.Execute( __answer, "tmpl-newsadmin-head" );
					__delete_news();
					if	( userdata.user_flag & FLAG_SUPERUSER )	__list_news();
					else 										__edit_news();
					previewtemplate.Execute( __answer, "tmpl-newsadmin-tail" );
					break;
	
					case	5:	// Save or update a news entry
					previewtemplate.Execute( __answer, "tmpl-newsadmin-head" );
					if	( __save_news() ) {
						if	( userdata.user_flag & FLAG_SUPERUSER )	__list_news();
						else 										__edit_news();
					}
					else	__edit_news();
					previewtemplate.Execute( __answer, "tmpl-newsadmin-tail" );
					break;
				}
			}
		}
    }

	catch	( CError e ) {
		::HTTP_text( "en" );
		::printf( "ERROR: %s", e.Error() );
	}

    catch   ( ... ) {
		::HTTP_text( "en" );
		::printf( "Failed to execute administering program" );
    }

	::fflush( stdout );
	::fclose( stdout );
    return	0;
}

// --------------------------------------------------------------------
// EOF: Storage.cxx
// --------------------------------------------------------------------
