// --------------------------------------------------------------------
// PreviewExportList.cxx
// Whatis:  CGI for previewing upackage info of a given file
// CGI arguments:
//	file_idnt	File identifier in database
//
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 14-JUN-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CPreviewFile.hxx"
#include    "CPreviewTemplate.hxx"
#include    "CPreviewLeafMenu.hxx"
#include	"CCgiArgs.hxx"
#include    "CTablePref.hxx"
#include    "CTableXref.hxx"
#include	"CSpam.hxx"

// --------------------------------------------------------------------
// local:	The local data
// --------------------------------------------------------------------
static	CCgiArgs			cgi;
static	CPreviewFile		previewfile;
static	CPreviewTemplate	previewtemplate;
static	CPreviewLeafMenu	previewleafmenu;
static	CMySqlConnect		db			( "quest", "", "UTCMS" );

static	CTableXref			xref;
static	data_xref_t			xrefdata	= { 0 };
static	dword_t				xrownumber	= 0;
static	char				xpreviewer	[1024] = { 0 };
static	bool				xpreview	= false;

// --------------------------------------------------------------------
// local:	Parser questions are sent here for answering
// --------------------------------------------------------------------
static	void	__answer	( const char * aQ ) {

	// ----------------------------------------------------------------
	// Parsing preview file
	// ----------------------------------------------------------------
	if		( previewfile.Answer( aQ ) )		;
	else if	( previewleafmenu.Answer( aQ ) )	;

	else if	( ::MySqlTableParser( xref.Layout(), "xref", (const char *)(&xrefdata), aQ ) )	;
	else if	( ! ::strcmp( aQ, "xrownumber" ) )		::printf( "%d", xrownumber );
	else if	( ! ::strcmp( aQ, "linepair" ) )		::printf( "%d", xrownumber & 0x01 );
	else if	( ! ::strcmp( aQ, "xp_s" ) )			::printf( "%s", xpreview ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "xp_e" ) )			::printf( "%s", xpreview ? "" : " -->" );
	else if	( ! ::strcmp( aQ, "xp_xs" ) )			::printf( "%s", ! xpreview ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "xp_xe" ) )			::printf( "%s", ! xpreview ? "" : " -->" );
	else if	( ! ::strcmp( aQ, "xp" ) )				::printf( "%s", xpreviewer );

	// ----------------------------------------------------------------
	// Parsing the CGI data
	// ----------------------------------------------------------------
	else if	( ::cgi_parser( cgi, aQ ) )	;

	// ----------------------------------------------------------------
	// Everything else goes to default parser
	// ----------------------------------------------------------------
	else	::my_default_answer( aQ );
}

// --------------------------------------------------------------------
// local:	Prevent spam
// --------------------------------------------------------------------
static	bool	__spam	( void ) {
	bool	is_spam	= false;

	try	{
		CSpam	myspam1( cgi.Arg( CGI_REMOTE_ADDR ), cgi.Arg( CGI_QUERY_STRING ), 1 );
	}

	catch	( CError e ) {
		is_spam = true;
	}

	return	is_spam;
}

// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {
	::srand( (unsigned int)::time( NULL ) );
	::HTTP_text( "en" );

	try	{
		if	( __spam() ) {
			previewtemplate.Execute( __answer, "tmpl-spam-warning" );
			::fflush( stdout );
			::fclose( stdout );
			return	-1;
		}

		previewfile.Load( ::atol( cgi.Arg( "file_idnt" ) ) );
		previewleafmenu.Load( ::atol( cgi.Arg( "file_idnt" ) ), LEAFMENU_EXPORTLIST );

		previewtemplate.Execute( __answer, "tmpl-prv-head" );

		previewtemplate.Execute( __answer, "tmpl-prv-elist-head" );

		CTablePref		pref;
		data_xref_tl	xlist;
		data_xref_tli	xloop;
		data_pref_tl	plist;
		CMySqlWhere		w;
		CMySqlQuote		q;

		w = "";
		w << "xref_file=" << (dword_t)::atol( cgi.Arg( "file_idnt" ) ) << " and xref_expo=1 order by xref_name";
		xlist = xref.Select( db, w );		
		xrownumber = 0;
		for	( xloop = xlist.begin(); xloop != xlist.end(); xloop++ ) {
			xrefdata = *xloop;

			w = "";
			w << "pref_name='xp-" << q.Quote( xrefdata.xref_name ) << "'";
			plist = pref.Select( db, w );
			if	( plist.size() > 0 ) {
				xpreview	= true;
				::strcpy( xpreviewer, (*(plist.begin())).pref_valu );
			}
			else {
				xpreview	= false;
				*xpreviewer	= 0;
			}

			previewtemplate.Execute( __answer, "tmpl-prv-elist-body" );
			xrownumber++;
		}


		previewtemplate.Execute( __answer, "tmpl-prv-elist-tail" );
		previewtemplate.Execute( __answer, "tmpl-prv-tail" );
	}

	catch 	( CError e ) {
		::printf( "PreviewExportList : Error : " );
		::HTML_quote( e.Error() );
		::fflush( stdout );
		::fclose( stdout );
		return	-1;
	}

	catch	( ... ) {
		::printf( "PreviewExportList : Error: Unknown error" );
		::fflush( stdout );
		::fclose( stdout );
		return	-1;
	}
	::fflush( stdout );
	::fclose( stdout );
    return	0;
}

// --------------------------------------------------------------------
// EOF: PreviewExportList.cxx
// --------------------------------------------------------------------
