// --------------------------------------------------------------------
// PreviewScript.cxx
// Whatis:  CGI for previewing textures in files
// CGI arguments:
//
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 14-JUN-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CCache.hxx"
#include    "CStorage.hxx"
#include    "CTablePref.hxx"
#include	"CPreviewFile.hxx"
#include	"CPreviewText.hxx"
#include    "CPreviewTemplate.hxx"
#include    "CPreviewLeafMenu.hxx"
#include	"CCgiArgs.hxx"
#include	"CMySqlWhere.hxx"
#include	"CUnFile.hxx"
#include	"CUnNameTable.hxx"
#include	"CUnImportTable.hxx"
#include	"CUnExportTable.hxx"
#include	"CSpam.hxx"

// --------------------------------------------------------------------
// local:	The local data
// --------------------------------------------------------------------
static	CCgiArgs			cgi;
static	CPreviewFile		previewfile;
static	CPreviewText		previewtext;
static	CPreviewTemplate	previewtemplate;
static	CPreviewLeafMenu	previewleafmenu;

// --------------------------------------------------------------------
static	char				classpath	[1024]	= { 0 };
static	char				objectname	[1024]	= { 0 };
static	dword_t				objectsize			= 0;
static	dword_t				objectoffs			= 0;
static	dword_t				objectnum			= 0;
static	CUnObjectFlags_t	objectflag;
static	dword_t				rownumber			= 0;

// --------------------------------------------------------------------
// local:	Parser questions are sent here for answering
// --------------------------------------------------------------------
static	void	__answer	( const char * aQ ) {

	// ----------------------------------------------------------------
	// Local parsing
	// ----------------------------------------------------------------
	if		( ! ::strcmp( aQ, "classpath" ) )	::printf( "%s", classpath );
	else if	( ! ::strcmp( aQ, "objectname" ) )	::printf( "%s", objectname );
	else if	( ! ::strcmp( aQ, "objectsize" ) )	::printf( "%d", objectsize );
	else if	( ! ::strcmp( aQ, "objectoffs" ) )	::printf( "%d", objectoffs );
	else if	( ! ::strcmp( aQ, "objectnum" ) )	::printf( "%d", objectnum );
	else if	( ! ::strcmp( aQ, "linepair" ) )	::printf( "%d", rownumber & 0x01 );


	else if	( previewfile.Answer( aQ ) )		;
	else if	( previewleafmenu.Answer( aQ ) )	;
	else if	( ::cgi_parser( cgi, aQ ) )	;
	else	::my_default_answer( aQ );
}

// --------------------------------------------------------------------
// local:	Solve class path for an export object
// --------------------------------------------------------------------
static	void	__solve_class_path	(	const CUnExport &		aX,
										const CUnNameTable &	aN,
										const CUnImportTable &	aI,
										const CUnExportTable &	aE ) {
	dword_t		namearray[16];
	int			nameindex;
	CUnExport	myexport	= aX;
	CUnImport	myimport;

	// Loop here until the reference is to import table in which case
	// it is a package name
	nameindex = 0;
	while	( nameindex < 15 ) {
		if		( ISUNEXPORT( myexport.Super() ) ) {
			namearray[nameindex++] = myexport.ObjectName();
			myexport = aE.Export( NAMEEXPORT( myexport.Super() ) );
		}
		else if	( ISUNIMPORT( myexport.Super() ) ) {
			myimport = aI.Import( NAMEIMPORT( myexport.Super() ) );
			break;
		}
		else if	( ISUNEXPORT( myexport.Package() ) ) {
			namearray[nameindex++] = myexport.ObjectName();
			myexport = aE.Export( NAMEEXPORT( myexport.Package() ) );
			if	( ISUNIMPORT( myexport.Super() ) ) {
				namearray[nameindex++] = myexport.ObjectName();
			}
		}
		else if	( ISUNIMPORT( myexport.Package() ) ) {
			myimport = aI.Import( NAMEIMPORT( myexport.Package() ) );
			break;
		}
		else {
			break;
		}
	}

	// In case we really found the package (import table entry), output it first
	::sprintf(	classpath, "%s.%s.%s",
				aN.Name( myimport.ClassPackage() ),
				aN.Name( myimport.ClassName() ),
				aN.Name( myimport.ObjectName() ) );

	// Output the name array preceding the names with period
	while	( nameindex > 0 ) {
		nameindex--;
		::strcat( classpath, "." );
		::strcat( classpath, aN.Name( namearray[nameindex] ) );
	}
}

// --------------------------------------------------------------------
// local:	Produce list of classes of type "Function"
// --------------------------------------------------------------------
static	void	__produce_function_list	( void ) {
	previewtemplate.Execute( __answer, "tmpl-previewfunction-head" );

	try {
		CUnFile			f( previewfile.FilePath() );
		CUnNameTable	n( f );
		CUnImportTable	i( f );
		CUnExportTable	e( f );
	
		// Name index for the class we are searching for
		const char *	classname	= cgi.Arg( "class" );
		dword_t			classnmix	= n.Find( classname );
	
		// If the name does not exist - well....
		if	( ! n.Exist( classname ) ) {
			previewtemplate.Execute( __answer, "tmpl-previewfunction-none" );
			return;
		}
	
		// Loop through all the entries in the export table
		dword_t		eidx;
	
		for	( eidx = rownumber = 0; eidx < e.Count(); eidx++ ) {
			CUnExport	exp = e.Export( eidx );
	
			// Skip over those who are not of the searched name
			if	( classnmix != i.Import( NAMEIMPORT( exp.Class() ) ).ObjectName() )	continue;
	
			// Solve class path
			__solve_class_path( exp, n, i, e );
	
			// Some data before parsing starts
			::strcpy( objectname, n.Name( exp.ObjectName() ) );
			objectsize = exp.SerialSize();
			objectoffs = exp.SerialOffset();
			objectflag = exp.Flags();
	
	
			previewtemplate.Execute( __answer, "tmpl-previewfunction-body" );
			rownumber++;
		}
	
		// Did we find any of those ?
		if	( rownumber == 0 ) {
			previewtemplate.Execute( __answer, "tmpl-previewfunction-none" );
		}
	}
	catch ( ... ) {
		previewtemplate.Execute( __answer, "tmpl-previewfunction-none" );
	}
	previewtemplate.Execute( __answer, "tmpl-previewfunction-tail" );
}

// --------------------------------------------------------------------
// local:	Produce list of objects of type "TextBuffer"
// --------------------------------------------------------------------
static	void	__produce_textbuffer_list	( void ) {
	previewtemplate.Execute( __answer, "tmpl-previewtextbuffer-head" );

	try {
		CUnFile			f( previewfile.FilePath() );
		CUnNameTable	n( f );
		CUnImportTable	i( f );
		CUnExportTable	e( f );
		CUnExport		exp;
		const char *	supername = "";
	
		// Name index for the class we are searching for
		const char *	classname	= cgi.Arg( "class" );
		dword_t			classnmix	= n.Find( classname );
		dword_t			eidx;
	
		// If the name does not exist - well....
		if	( ! n.Exist( classname ) ) {
			previewtemplate.Execute( __answer, "tmpl-previewtextbuffer-none" );
			previewtemplate.Execute( __answer, "tmpl-previewtextbuffer-tail" );
			return;
		}
	
		// Loop through all the entries in the export table
		for	( eidx = rownumber = 0; eidx < e.Count(); eidx++ ) {
			exp = e.Export( eidx );
	
			// Skip over those who are not of the searched name
			if	( classnmix != i.Import( NAMEIMPORT( exp.Class() ) ).ObjectName() )	continue;
	
			// Some data before parsing starts
			supername = "";
			if		( ISUNEXPORT( exp.Package() ) ) {
				supername = n.Name( e.Export( NAMEEXPORT( exp.Package() ) ).ObjectName() );
			}
			else if	( ISUNIMPORT( exp.Package() ) ) {
				supername = n.Name( i.Import( NAMEIMPORT( exp.Package() ) ).ObjectName() );
			}

			::sprintf(	objectname, "%s.%s",
						supername,
						n.Name( exp.ObjectName() ) );
			objectsize = exp.SerialSize();
			objectoffs = exp.SerialOffset();
			objectflag = exp.Flags();
			objectnum  = eidx;

			previewtemplate.Execute( __answer, "tmpl-previewtextbuffer-body" );
			rownumber++;
		}
	
		// Did we find any of those ?
		if		( rownumber == 0 ) {
			previewtemplate.Execute( __answer, "tmpl-previewtextbuffer-none" );
			previewtemplate.Execute( __answer, "tmpl-previewtextbuffer-tail" );
			return;
		}

		previewtemplate.Execute( __answer, "tmpl-previewtextbuffer-tail" );

		if	( ! cgi.Exist( "object" ) )	return;

		eidx = ::atol( cgi.Arg( "object" ) );
		if	( eidx >= e.Count() )		return;

		exp = e.Export( eidx );
		if	( classnmix != i.Import( NAMEIMPORT( exp.Class() ) ).ObjectName() )	return;

		f.Seek( exp.SerialOffset() + 9 );


		supername = "";
		if		( ISUNEXPORT( exp.Package() ) ) {
			supername = n.Name( e.Export( NAMEEXPORT( exp.Package() ) ).ObjectName() );
		}
		else if	( ISUNIMPORT( exp.Package() ) ) {
			supername = n.Name( i.Import( NAMEIMPORT( exp.Package() ) ).ObjectName() );
		}

		::sprintf(	objectname, "%s.%s",
					supername,
					n.Name( exp.ObjectName() ) );

		previewtemplate.Execute( __answer, "tmpl-previewtextbuffer-thead" );
		previewtext.OutputHttp( f.Stream(), f.ReadIndex() );
		previewtemplate.Execute( __answer, "tmpl-previewtextbuffer-ttail" );

	}
	catch ( ... ) {
		previewtemplate.Execute( __answer, "tmpl-previewtextbuffer-none" );
		previewtemplate.Execute( __answer, "tmpl-previewtextbuffer-tail" );
	}
}

// --------------------------------------------------------------------
// local:	Prevent spam
// --------------------------------------------------------------------
static	bool	__spam	( void ) {
	bool	is_spam	= false;

	try	{
		CSpam	myspam1( cgi.Arg( CGI_REMOTE_ADDR ), cgi.Arg( CGI_QUERY_STRING ), 1 );
	}

	catch	( CError e ) {
		is_spam = true;
	}

	return	is_spam;
}

// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {
	::srand( (unsigned int)::time( NULL ) );
	::HTTP_text( "en" );

	try	{
		if	( __spam() ) {
			previewtemplate.Execute( __answer, "tmpl-spam-warning" );
			::fflush( stdout );
			::fclose( stdout );
			return	-1;
		}

		// Load the file we are going to preview
		previewfile.Load( ::atol( cgi.Arg( "file_idnt" ) ) );

		// Set up the leaf menu
		previewleafmenu.Load( ::atol( cgi.Arg( "file_idnt" ) ), LEAFMENU_EXPORTLIST );

		previewtemplate.Execute( __answer, "tmpl-prv-head" );

		if		( ! ::my_stricmp( cgi.Arg( "class" ), "function" ) )	__produce_function_list();
		else if	( ! ::my_stricmp( cgi.Arg( "class" ), "textbuffer" ) )	__produce_textbuffer_list();


		previewtemplate.Execute( __answer, "tmpl-prv-tail" );
	}

	catch 	( CError e ) {
		::printf( "Error: " );
		::HTML_quote( e.Error() );
		::fflush( stdout );
		::fclose( stdout );
		return	-1;
	}

	catch	( ... ) {
		::printf( "Error: Unknown error" );
		::fflush( stdout );
		::fclose( stdout );
		return	-1;
	}
	::fflush( stdout );
	::fclose( stdout );
    return	0;
}

// --------------------------------------------------------------------
// EOF: PreviewScript.cxx
// --------------------------------------------------------------------
