// --------------------------------------------------------------------
// PreviewText.cxx
// Whatis:  CGI for previewing an UT Assault level
// CGI arguments:
//
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 14-JUN-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CStorage.hxx"
#include    "CCache.hxx"
#include    "CTablePref.hxx"
#include    "CTableFile.hxx"
#include    "CTablePack.hxx"
#include    "CTablePackFile.hxx"
#include    "CTableAuth.hxx"
#include    "CTableUser.hxx"
#include    "CTableType.hxx"
#include    "CTableRule.hxx"
#include    "CTableXref.hxx"
#include	"CCgiArgs.hxx"
#include	"CMySqlWhere.hxx"

// --------------------------------------------------------------------
// local:	The local data
// --------------------------------------------------------------------
static	CCgiArgs					cgi;
static	CMySqlConnect				db			( "quest", "", "UTCMS" );
static	CCache						pvcache		( "preview" );

// --------------------------------------------------------------------
// local:	Some database tables needed
// --------------------------------------------------------------------
static	CTablePref		pref;
static	CTableFile		file;
static	CTablePack		pack;
static	CTablePackFile	packfile;
static	CTableAuth		auth;
static	CTableUser		user;
static	CTableType		type;
static	CTableRule		rule;
static	CTableXref		xref;

// --------------------------------------------------------------------
// local:	Data associated with those tables
// --------------------------------------------------------------------
static	data_file_t		filedata		= { 0 };
static	data_pack_t		packdata		= { 0 };
static	data_auth_t		authdata		= { 0 };
static	data_user_t		userdata		= { 0 };
static	data_type_t		typedata		= { 0 };

// --------------------------------------------------------------------
// local:	Normal file stuff
// --------------------------------------------------------------------
static	char			prevfile	[256]					= { 0 };

// --------------------------------------------------------------------
// local:	Category - Outputs category for this file
// --------------------------------------------------------------------
static	void	__category	( void ) {
	CMySqlWhere		w;
	data_type_t		data;
	data_type_tl	list;
	data_type_tli	loop;
	const char *	prevcat = "";
	dword_t			ctgr	= 0;

	w << "type_idnt > 0 order by type_ctgr, type_name";
	list = type.Select( db, w );

	for	( loop = list.begin(); loop != list.end(); loop++ ) {
		data = *loop;

		// Start of a new category
		if	( ::strcmp( prevcat, data.type_ctgr ) ) {
			prevcat = (*loop).type_ctgr;
			ctgr++;
		}

		// Is the type number same ?
		if	( filedata.file_type == data.type_idnt ) {
			::printf( "%d", ctgr );
			break;
		}
	}
}

// --------------------------------------------------------------------
// local:	Read a template using preferences
// --------------------------------------------------------------------
static	char *	__tmpldata	( const char * aTemplate ) {
	char *	filedata = NULL;

	try	{
		data_pref_tl	list;
		CMySqlWhere		w;

		w << "pref_name='" << aTemplate << "'";
		list = pref.Select( db, w );

		if	( list.size() < 1 ) {
			throw CError( aTemplate, "Preference not found" );
		}

		filedata = ::my_load_file( (*(list.begin())).pref_valu );
	}

	catch	( ... ) {
		if	( filedata ) delete [] filedata;
		throw;
	}
	return	filedata;
}

// --------------------------------------------------------------------
// local:	Cache the previewed file
// --------------------------------------------------------------------
static	void	__cache_file	( void ) {
	char	filepath[1024];

	::sprintf( 	prevfile, "%d-file.%s",
				filedata.file_idnt,
				filedata.file_suff );

	pvcache.MakeDirname( filepath, prevfile );

	if	( ! pvcache.Exist( filepath ) ) {
		CStorage	storage;
		storage.Load( filepath, filedata.file_idnt );
		pvcache.Cache( filepath );
	}
}

// --------------------------------------------------------------------
// local:	Output contents of the text file
// --------------------------------------------------------------------
static	void	__textcontent	( void ) {
	char	filepath[1024];

	pvcache.MakeDirname( filepath, prevfile );

	FILE *	strm = ::fopen( filepath, "rb" );
	char	chrbf[2];
	int		chr;

	chrbf[1] = 0;

	while	( ! feof( strm ) ) {
		chr = ::fgetc( strm );
		if	( chr >= 0 ) {
			chrbf[0] = (char)chr;
			::HTML_quote( chrbf );
		}
	}
	::fclose( strm );
}


// --------------------------------------------------------------------
// local:	Parser questions are sent here for answering
// --------------------------------------------------------------------
static	void	__answer	( const char * aQ ) {

	// ----------------------------------------------------------------
	// File details parsing
	// ----------------------------------------------------------------
	if		( ::MySqlTableParser( file.Layout(), "file", (const char *)(&filedata), aQ ) )	;
	else if	( ::MySqlTableParser( auth.Layout(), "auth", (const char *)(&authdata), aQ ) )	;
	else if	( ::MySqlTableParser( user.Layout(), "user", (const char *)(&userdata), aQ ) )	;
	else if	( ::MySqlTableParser( type.Layout(), "type", (const char *)(&typedata), aQ ) )	;
	else if	( ::MySqlTableParser( pack.Layout(), "pack", (const char *)(&packdata), aQ ) )	;
	else if	( ! ::strcmp( aQ, "category" ) )		__category();

	// ----------------------------------------------------------------
	// For linking reviews, owners and downloads
	// ----------------------------------------------------------------
	else if	( ! ::strcmp( aQ, "downloadable_b" ) )	::printf( "%s", (filedata.file_flag & FLAG_NODOWNLOAD) == 0 ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "downloadable_e" ) )	::printf( "%s", (filedata.file_flag & FLAG_NODOWNLOAD) == 0 ? "" : " -->" );
	else if	( ! ::strcmp( aQ, "userlink_b" ) )		::printf( "%s", (userdata.user_flag & FLAG_DENY_VIEW) == 0 ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "userlink_e" ) )		::printf( "%s", (userdata.user_flag & FLAG_DENY_VIEW) == 0 ? "" : " -->" );
	else if	( ! ::strcmp( aQ, "downloadable" ) )	::printf( "%s", (filedata.file_flag & FLAG_NODOWNLOAD) == 0 ? "(DL)" : "" );

	// ----------------------------------------------------------------
	// File caching
	// ----------------------------------------------------------------
	else if	( ! ::strcmp( aQ, "textcontent" ) )		__textcontent();

	// ----------------------------------------------------------------
	// Parsing the CGI data
	// ----------------------------------------------------------------
	else if	( ::cgi_parser( cgi, aQ ) )	;

	// ----------------------------------------------------------------
	// Everything else goes to default parser
	// ----------------------------------------------------------------
	else	::my_default_answer( aQ );
}

// --------------------------------------------------------------------
// local:	Execute a template
// --------------------------------------------------------------------
static	void	__tempexec	( const char * aTemplate ) {
	char *	tmpldata = __tmpldata( aTemplate );
	try	{

		::my_parse( __answer, tmpldata );
		delete [] tmpldata;
	}
	catch	( ... ) {
		if	( tmpldata ) delete [] tmpldata;
		throw;
	}
}

// --------------------------------------------------------------------
// local:	Collect file information and output it
// --------------------------------------------------------------------
static	void	__output_fileinfo	( void ) {
	CMySqlWhere			w;
	data_file_tl		flist;
	data_auth_tl		alist;
	data_user_tl		ulist;
	data_pack_tl		plist;
	data_type_tl		tlist;
	data_rule_tl		rlist;
	data_packfile_tl	pflist;
	data_packfile_tli	pfloop;

	// The file itself
	w << "file_idnt=" << (dword_t)::atol( cgi.Arg( "file_idnt" ) );
	flist = file.Select( db, w );
	if	( flist.size() == 0 ) {
		throw CError( w.Where(), "No such file" );
	}
	filedata = *(flist.begin());
	__cache_file();

	// Author of this file
	w = "";
	w << "auth_idnt=" << filedata.file_auth;
	alist = auth.Select( db, w );
	if	( alist.size() > 0 ) {
		authdata = *(alist.begin());
	}

	// Owner of this file
	w = "";
	w << "user_idnt=" << filedata.file_user;
	ulist = user.Select( db, w );
	if	( ulist.size() > 0 ) {
		userdata = *(ulist.begin());
	}

	// Type of this file
	w = "";
	w << "type_idnt=" << filedata.file_type;
	tlist = type.Select( db, w );
	if	( tlist.size() > 0 ) {
		typedata = *(tlist.begin());
	}

	// Output the stuff
	char *	tmpldata = __tmpldata( "tmpl-prv-fileinfo-body" );
	try	{
		__tempexec( "tmpl-prv-fileinfo-head" );

		w = "";
		w << "packfile_file=" << filedata.file_idnt;
		pflist = packfile.Select( db, w );
		for	( pfloop = pflist.begin(); pfloop != pflist.end(); pfloop++ ) {
			w = "";
			w << "pack_idnt=" << (*pfloop).packfile_pack;
			plist = pack.Select( db, w );
			if	( plist.size() > 0 ) {
				packdata = *(plist.begin());
				::my_parse( __answer, tmpldata );
			}
		}

		__tempexec( "tmpl-prv-fileinfo-tail" );
		delete [] tmpldata;
	}
	catch	( ... ) {

		if	( tmpldata ) delete [] tmpldata;
		throw;
	}
}

// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {
	::srand( (unsigned int)::time( NULL ) );
	::HTTP_text( "en" );

	try	{
		__output_fileinfo();
	}

	catch 	( CError e ) {
		::printf( "<p>Error: " );
		::HTML_quote( e.Error() );
		::printf( "</p>" );
		::fflush( stdout );
		::fclose( stdout );
		return	-1;
	}

	catch	( ... ) {
		::printf( "<p>Error: Unknown error</p>" );
		::fflush( stdout );
		::fclose( stdout );
		return	-1;
	}
	::fflush( stdout );
	::fclose( stdout );
    return	0;
}

// --------------------------------------------------------------------
// EOF: PreviewText.cxx
// --------------------------------------------------------------------
