// --------------------------------------------------------------------
// PreviewTexture.cxx
// Whatis:  CGI for previewing textures in files
// CGI arguments:
//
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 14-JUN-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CCache.hxx"
#include    "CStorage.hxx"
#include    "CTablePref.hxx"
#include    "CTableFile.hxx"
#include	"CCgiArgs.hxx"
#include	"CMySqlWhere.hxx"
#include	"CUnUtils.hxx"
#include    "CPreviewFile.hxx"
#include    "CPreviewTemplate.hxx"
#include    "CPreviewLeafMenu.hxx"
#include	"CPictureSourceUTX.hxx"
#include	"CPictureSourceJPG.hxx"
#include	"CPictureFilterScale.hxx"
#include	"CPictureFilterAlphaBlend.hxx"
#include	"CPicture.hxx"
#include	"CFurpileLogo.hxx"
#include	"CSpam.hxx"

// --------------------------------------------------------------------
// local:	The local data
// --------------------------------------------------------------------
static	CCgiArgs			cgi;
static	CMySqlConnect		db			( "quest", "", "UTCMS" );
static	CCache				pvcache( "preview" );
static	CPreviewFile		previewfile;
static	CPreviewTemplate	previewtemplate;
static	CPreviewLeafMenu	previewleafmenu;

// --------------------------------------------------------------------
// local:	Some database tables needed
// --------------------------------------------------------------------
static	CTablePref		pref;
static	CTableFile		file;

// --------------------------------------------------------------------
// local:	Data associated with previewing images
// --------------------------------------------------------------------
static	char			imagename	[1024]	= { 0 };
static	char			detailimage	[1024]	= { 0 };
static	char			detailname	[1024]	= { 0 };
static	char			texturename	[1024]	= { 0 };
static	char			notn		[1024]	= { 0 };
static	char			notx		[1024]	= { 0 };
static	dword_t			texcount			= 0;
static	dword_t			texturenum			= 0;
static	dword_t			detail_w			= 256;
static	dword_t			detail_h			= 256;
static	CPictureFilterAlphaBlend	alphablend( 0x1b, 0x00, 0x3e, 0xff );

// --------------------------------------------------------------------
// local:	Unreal package cache management
// --------------------------------------------------------------------
static	CUnUtils *			unrutils			= NULL;

// --------------------------------------------------------------------
// local:	Cache an unreal package
// --------------------------------------------------------------------
static	void	__cache_upack		( void ) {
	char	filepath[1024];

	::sprintf( 	filepath, "%s/%d-file.%s",
				pvcache.DirBase(),
				previewfile.File().file_idnt,
				previewfile.File().file_suff );

	if	( ! pvcache.Exist( filepath ) ) {
		CStorage	storage;
		storage.Load( filepath, previewfile.File().file_idnt );
		pvcache.Cache( filepath );
	}
	unrutils = new CUnUtils( filepath );
}

// --------------------------------------------------------------------
// local:	Get information about teh file
// --------------------------------------------------------------------
static	void	__get_filedata	( void ) {
	CMySqlWhere		w;
	data_pref_tl	preflist;

	previewfile.Load( ::atol( cgi.Arg( "file_idnt" ) ) );

	// ----------------------------------------------------------------
	// Preview image directory, URL, max number of files and defaultshot
	// ----------------------------------------------------------------
	w = "";
	w << "pref_name='tmpl-previewtex-notn'";
	preflist = pref.Select( db, w );
	if	( preflist.size() < 1 ) {
		throw CError( "No such preference", w.Where() );
	}
	::strcpy( notn, (*(preflist.begin())).pref_valu );

	w = "";
	w << "pref_name='tmpl-previewtex-notx'";
	preflist = pref.Select( db, w );
	if	( preflist.size() < 1 ) {
		throw CError( "No such preference", w.Where() );
	}
	::strcpy( notx, (*(preflist.begin())).pref_valu );

	__cache_upack();
}

// --------------------------------------------------------------------
// local:	Parser questions are sent here for answering
// --------------------------------------------------------------------
static	void	__answer	( const char * aQ ) {

	// ----------------------------------------------------------------
	// Local parsing
	// ----------------------------------------------------------------
	if		( previewfile.Answer( aQ ) )		;
	else if	( previewleafmenu.Answer( aQ ) )	;
	else if	( ! ::strcmp( aQ, "imagename" ) )		::printf( "%s", imagename );
	else if	( ! ::strcmp( aQ, "detailimage" ) )		::printf( "%s", detailimage );
	else if	( ! ::strcmp( aQ, "detailname" ) )		::printf( "%s", detailname );
	else if	( ! ::strcmp( aQ, "imageurl" ) )		::printf( "%s", pvcache.UrlBase() );
	else if	( ! ::strcmp( aQ, "texturename" ) )		::printf( "%s", texturename );
	else if	( ! ::strcmp( aQ, "texcount" ) )		::printf( "%d", texcount );
	else if	( ! ::strcmp( aQ, "texturenum" ) )		::printf( "%d", texturenum );

	else if	( ! ::strcmp( aQ, "detail_w" ) )		::printf( "%d", detail_w );
	else if	( ! ::strcmp( aQ, "detail_h" ) )		::printf( "%d", detail_h );

	// ----------------------------------------------------------------
	// Local parsing
	// ----------------------------------------------------------------
	else if	( ::cgi_parser( cgi, aQ ) )	;

	// ----------------------------------------------------------------
	// Everything else goes to default parser
	// ----------------------------------------------------------------
	else	::my_default_answer( aQ );
}

// --------------------------------------------------------------------
// local:	Create the summary page
// --------------------------------------------------------------------
static	void	__makesummary	( void ) {

	previewtemplate.Execute( __answer, "tmpl-previewtexture-head" );

	// ------------------------------------------------------------
	// Get a list of all textures in this package
	// ------------------------------------------------------------
	unr_actor_tl		alist = unrutils->ActorList( "Texture" );
	unr_actor_tli		aloop;
	CPictureFilterScale	scale( 64, 64 );
	char				filepath[1024];
	dword_t				detail = (dword_t)::atol( cgi.Arg( "detail" ) );

	if	( detail == 0 ) detail = 1;

	// ------------------------------------------------------------
	// Loop through them and output the thumbnails
	// ------------------------------------------------------------
	texcount = alist.size();
	texturenum = 1;
	::strcpy( detailimage, notx );
	detail_w = 256;
	detail_h = 256;
	for	( aloop = alist.begin(); aloop != alist.end(); aloop++ ) {
		::strcpy( texturename, (*aloop).name );

		try {

			if	( texturenum == detail ) {
				unrutils->Seek( *aloop );
				CUnTexture			mytex( 	unrutils->UnFile(),
											unrutils->UnNameTable(),
											unrutils->UnExportTable(),
											unrutils->UnImportTable() );
				CPictureSourceUTX			myutx( &mytex );
				CPicture					mypicture;
				CFurpileLogo				logo( "Furpile.utx" );

				mypicture.Load( myutx );
				mypicture.Filter( alphablend );

				::strcpy( detailname, (*aloop).name );
				::sprintf( detailimage, "%d-texture-%s.jpg", previewfile.File().file_idnt, (*aloop).name );
				detail_w = mypicture.W();
				detail_h = mypicture.H();

				pvcache.MakeDirname( filepath, detailimage );

				mypicture.Filter( alphablend );

				logo.Plant( mypicture.PixmapRef() );

				if		( ! pvcache.Exist( filepath ) ) {
					CPictureSourceJPG	myjpg( filepath, 70 );
					mypicture.Save( myjpg );
					pvcache.Cache( filepath );
				}
			}


			::sprintf( imagename, "%d-texture-%s-tn.jpg", previewfile.File().file_idnt, (*aloop).name );

			pvcache.MakeDirname( filepath, imagename );

			if		( ! pvcache.Exist( filepath ) ) {
				unrutils->Seek( *aloop );
				CUnTexture			mytex( 	unrutils->UnFile(),
											unrutils->UnNameTable(),
											unrutils->UnExportTable(),
											unrutils->UnImportTable() );
				CPictureSourceUTX	myutx( &mytex );
				CPicture			mypicture;

				mypicture.Load( myutx );
				CPictureSourceJPG	myjpg( filepath, 70 );
				mypicture.Filter( scale );
				mypicture.Filter( alphablend );
				mypicture.Save( myjpg );
				pvcache.Cache( filepath );
			}
		}

		catch	( ... ) {
			::strcpy( imagename, notn );
		}


		previewtemplate.Execute( __answer, "tmpl-previewtexture-body" );
		texturenum++;
	}

	previewtemplate.Execute( __answer, "tmpl-previewtexture-tail" );
}

// --------------------------------------------------------------------
// local:	Prevent spam
// --------------------------------------------------------------------
static	bool	__spam	( void ) {
	bool	is_spam	= false;

	try	{
		CSpam	myspam1( cgi.Arg( CGI_REMOTE_ADDR ), cgi.Arg( CGI_QUERY_STRING ), 1 );
	}

	catch	( CError e ) {
		is_spam = true;
	}

	return	is_spam;
}

// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {
	::srand( (unsigned int)::time( NULL ) );
	::HTTP_text( "en" );

	try	{
		if	( __spam() ) {
			previewtemplate.Execute( __answer, "tmpl-spam-warning" );
			::fflush( stdout );
			::fclose( stdout );
			return	-1;
		}

		// Load the file we are going to preview
		__get_filedata();

		// Set up the leaf menu
		previewleafmenu.Load( ::atol( cgi.Arg( "file_idnt" ) ), LEAFMENU_TEXTURES );

		previewtemplate.Execute( __answer, "tmpl-prv-head" );
		__makesummary();
		previewtemplate.Execute( __answer, "tmpl-prv-tail" );

		if	( unrutils )	delete unrutils;
	}

	catch 	( CError e ) {
		::printf( "Error : " );
		::HTML_quote( e.Error() );
		if	( unrutils )	delete unrutils;
		::fflush( stdout );
		::fclose( stdout );
		return	-1;
	}

	catch	( ... ) {
		::printf( "Error : Unknown error" );
		if	( unrutils )	delete unrutils;
		::fflush( stdout );
		::fclose( stdout );
		return	-1;
	}
	::fflush( stdout );
	::fclose( stdout );
    return	0;
}

// --------------------------------------------------------------------
// EOF: PreviewTexture.cxx
// --------------------------------------------------------------------
