// --------------------------------------------------------------------
// Screenshot.cxx
// Whatis:  CGI for scoring files @ UTCMS
// CGI arguments:
//
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 14-JUN-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CTableFile.hxx"
#include    "CTablePref.hxx"
#include    "CTableVote.hxx"
#include	"CCgiArgs.hxx"
#include	"CMySqlWhere.hxx"
#include	"CFileScore.hxx"
#include	"CScore.hxx"

// --------------------------------------------------------------------
// local:	The local data
// --------------------------------------------------------------------
static	CCgiArgs					cgi;
static	CMySqlConnect				db			( "quest", "", "UTCMS" );
static	CTableFile					file;
static	CTableVote					vote;
static	CTablePref					pref;

// --------------------------------------------------------------------
// local:	Send the image data
// --------------------------------------------------------------------
static	void	__send_scoreshot	( 	const char *	aBaseDir,
										dword_t			aScore ) {
	char	filepath	[1024];

	::sprintf(	filepath, "%s/score-%s%s%d.gif",
				aBaseDir,
				aScore < 100 ? "0" : "",
				aScore < 10  ? "0" : "",
				aScore );

	struct	stat	mystat;

	::stat( filepath, &mystat );
	::HTTP_image( "gif", mystat.st_size );

	FILE *	strm = ::fopen( filepath, "rb" );
	int		chr;

	if	( strm ) {
		while	( ! feof( strm ) ) {
			chr = ::fgetc( strm );
			if	( chr >= 0 ) {
				::putchar( chr );
			}
		}
		::fclose( strm );
	}
}

// --------------------------------------------------------------------
// local:	Calculate score for a given set
// --------------------------------------------------------------------
static	void	__calc_and_send	( word_t aSet ) {
	data_pref_tl	plist;
	CMySqlWhere		w;

	w << "file_idnt=" << (dword_t)::atol( cgi.Arg( "file_idnt" ) );
	if	( file.Count( db, w ) < 1 ) {
		throw CError( "No such file" );
	}

	CScore	myscore( *(file.Select(db,w).begin()) );
	dword_t	sharepart = 0;

	switch	( aSet ) {
		case	0:
		plist = pref.Select( db, " where pref_name='rate-bad-images'" );
		sharepart	= myscore.Bad();
		break;

		case	1:
		plist = pref.Select( db, " where pref_name='rate-avg-images'" );
		sharepart	= myscore.Avg();
		break;

		case	2:
		plist = pref.Select( db, " where pref_name='rate-god-images'" );
		sharepart	= myscore.God();
		break;
	}

	// Did we get teh preference
	if	( plist.size() < 1 ) {
		throw	CError( "preference not found" );
	}

	// Now, output the thing
	__send_scoreshot( (*(plist.begin())).pref_valu, sharepart );
}

// --------------------------------------------------------------------
// local:	Rate and send the shot
// --------------------------------------------------------------------
static	void	__rate_and_send	( word_t aSet ) {
	CFileScore		myscore( (dword_t)::atol( cgi.Arg( "file_idnt" ) ) );
	data_vote_t		vdata;
	CMySqlWhere		w;
	CMySqlQuote		q;

	// Clean up the voting system first
	vote.Delete( db, " where now()-vote_time > 36000" );

	// Set up the vote record
	::memset( &vdata, 0, sizeof( vdata ) );
	::sprintf( vdata.vote_idnt, "%d-%d-%s", (dword_t)::atol( cgi.Arg( "file_idnt" ) ), (dword_t)aSet, cgi.Arg( CGI_REMOTE_ADDR ) );

	// If this record exists then we have to skip the voting
	w = "";
	w << "vote_idnt='" << q.Quote( vdata.vote_idnt ) << "'";
	if	( vote.Count( db, w ) == 0 ) {

		// Add the vote record
		vdata.vote_time = ::time( NULL );
		vote.Delete( db, &vdata );
		vote.Insert( db, &vdata );

		// Which one should be incremented ?
		switch	( aSet ) {
			case	0:	myscore.Rate0( 10 );	break;
			case	1:	myscore.Rate1( 10 );	break;
			case	2:	myscore.Rate2( 10 );	break;
		}
	
		myscore.Update();
	}

	__calc_and_send( aSet );
}

// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {
	::srand( (unsigned int)::time( NULL ) );

	try	{
		if		( ! cgi.Exist( "file_idnt" ) ) {
			throw	CError( "No file_idnt" );
		}
		else if	( cgi.Exist( "r" ) ) {
			switch	( cgi.Arg( "r" )[0] ) {
				case	'b':	__calc_and_send( 0 );	break;
				case	'a':	__calc_and_send( 1 );	break;
				case	'g':	__calc_and_send( 2 );	break;
				default:		throw	CError( "Bad value for 'r'" );
			}
		}
		else if	( cgi.Exist( "k" ) ) {
			switch	( cgi.Arg( "k" )[0] ) {
				case	'b':	__rate_and_send( 0 );	break;
				case	'a':	__rate_and_send( 1 );	break;
				case	'g':	__rate_and_send( 2 );	break;
				default:		throw	CError( "Bad value for 'k'" );
			}
		}
		else {
			::HTTP_text( "en" );
		}
	}

	catch 	( CError e ) {
		::HTTP_text( "en" );
		::printf( "<p>Error: " );
		::HTML_quote( e.Error() );
		::printf( "</p>" );
		::fflush( stdout );
		::fclose( stdout );
		return	-1;
	}

	catch	( ... ) {
		::HTTP_text( "en" );
		::printf( "<p>Error: Unknown error</p>" );
		::fflush( stdout );
		::fclose( stdout );
		return	-1;
	}
	::fflush( stdout );
	::fclose( stdout );
    return	0;
}

// --------------------------------------------------------------------
// EOF: Screenshot.cxx
// --------------------------------------------------------------------
