// --------------------------------------------------------------------
// Screenshot.cxx
// Whatis:  CGI for extracting a screenshot from an UNR file
// CGI arguments:
//
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 14-JUN-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CStorage.hxx"
#include    "CCache.hxx"
#include    "CTableFile.hxx"
#include	"CCgiArgs.hxx"
#include	"CMySqlWhere.hxx"
#include	"CUnUtils.hxx"
#include	"CUnLevelInfo.hxx"
#include	"CPicture.hxx"
#include	"CPictureSourceUTX.hxx"
#include	"CPictureSourceJPG.hxx"
#include	"CFurpileLogo.hxx"
#include	"CZipStreamStdout.hxx"

// --------------------------------------------------------------------
// local:	The local data
// --------------------------------------------------------------------
static	CCgiArgs					cgi;
static	CMySqlConnect				db			( "quest", "", "UTCMS" );
static	CCache						pvcache		( "preview" );


// --------------------------------------------------------------------
// local:	Send the image data
// --------------------------------------------------------------------
static	void	__send_screenshot	( void ) {
	CMySqlWhere		w;
	CTableFile		file;
	data_file_tl	flist;
	data_file_t		filedata;

	// The file itself
	w << "file_idnt=" << (dword_t)::atol( cgi.Arg( "file_idnt" ) );
	flist = file.Select( db, w );
	if	( flist.size() == 0 ) {
		throw CError( w.Where(), "No such file" );
	}
	filedata = *(flist.begin());

	char	prevfile[1024];
	char	filepath[1024];

	::sprintf( 	prevfile, "%d-file.%s",
				filedata.file_idnt,
				filedata.file_suff );

	pvcache.MakeDirname( filepath, prevfile );

	if	( ! pvcache.Exist( filepath ) ) {
		CStorage	storage;
		storage.Load( filepath, filedata.file_idnt );
		pvcache.Cache( filepath );
	}

	CUnUtils		unrutils( filepath );
	CUnLevelInfo	levelinfo(	unrutils.UnFile(),
								unrutils.UnNameTable(),
								unrutils.UnExportTable(),
								unrutils.UnImportTable() );

	dword_t	shotnum	= ::atol( cgi.Arg( "shot" ) );

	if	( shotnum >= levelinfo.ShotCount() )	throw CError( "Invalid shot" );


	::sprintf(	prevfile, "%d-ss-%d.jpg",
				filedata.file_idnt,
				shotnum );
	pvcache.MakeDirname( filepath, prevfile );

	if	( ! pvcache.Exist( filepath ) ) {
		CPicture			mypicture;
		CPictureSourceUTX	myutx( levelinfo.Screenshot( shotnum ) );
		CPictureSourceJPG	myjpg( filepath, 70 );
		CFurpileLogo		logo( "Furpile.utx" );

		mypicture.Load	( myutx );
		logo.Plant( mypicture.PixmapRef() );
		mypicture.Save	( myjpg );
		pvcache.Cache	( filepath );
	}

	struct	stat	mystat;

	::stat( filepath, &mystat );
	::HTTP_image( "jpeg", mystat.st_size );

	FILE *				strm = ::fopen( filepath, "rb" );
	char				jpgbuff[8192];
	CZipStreamStdout	output( 20 );	// 20 KB/sec throttle
	size_t				rcnt;

	if	( strm ) {
		while	( ! feof( strm ) ) {
			rcnt = ::fread( jpgbuff, 1, sizeof( jpgbuff ), strm );
			if	( ferror( strm ) )	break;
			if	( rcnt > 0 ) {
				output.Write( jpgbuff, (dword_t)rcnt );
			}
		}
		::fclose( strm );
	}
}

// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {
	::srand( (unsigned int)::time( NULL ) );

	try	{
		__send_screenshot();

	}

	catch 	( CError e ) {
		::HTTP_text( "en" );
		::printf( "<p>Error: " );
		::HTML_quote( e.Error() );
		::printf( "</p>" );
		::fflush( stdout );
		::fclose( stdout );
		return	-1;
	}

	catch	( ... ) {
		::HTTP_text( "en" );
		::printf( "<p>Error: Unknown error</p>" );
		::fflush( stdout );
		::fclose( stdout );
		return	-1;
	}
	::fflush( stdout );
	::fclose( stdout );
    return	0;
}

// --------------------------------------------------------------------
// EOF: Screenshot.cxx
// --------------------------------------------------------------------
