// --------------------------------------------------------------------
// Search.cxx
// Whatis:  CGI for searching the file database
// CGI arguments:
//
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 14-JUN-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CSession.hxx"
#include    "CTablePref.hxx"
#include    "CTableFile.hxx"
#include    "CTableFsrv.hxx"
#include    "CTablePack.hxx"
#include    "CTablePackFile.hxx"
#include    "CPreviewTemplate.hxx"
#include    "CTableAuth.hxx"
#include    "CTableType.hxx"
#include    "CTableRule.hxx"
#include    "CTableVote.hxx"
#include	"CCgiArgs.hxx"
#include	"CSpam.hxx"
#include	"CMySqlWhere.hxx"
#include    "CPreviewScore.hxx"

// --------------------------------------------------------------------
// local:	The local data
// --------------------------------------------------------------------
static	CCgiArgs		cgi;
static	CMySqlConnect	db	( "quest", "", "UTCMS" );
static	CPreviewTemplate	previewtemplate;
static	CPreviewScore		previewscore;
static	dword_t			ctgrselected	= 0;
static	dword_t			typeselected	= 0;
static	dword_t			ordrselected	= 0;
static	dword_t			linesperpage	= 0;
static	dword_t			rowcount		= 0;
static	dword_t			pagenow			= 0;
static	dword_t			lastpage		= 0;
static	char			query			[4096] = { 0 };
static	char			previewer		[1024] = { 0 };
static	dword_t			rownumber		= 0;

// --------------------------------------------------------------------
// local:	Some database tables needed
// --------------------------------------------------------------------
static	CTablePref		pref;
static	CTableFile		file;
static	CTableFsrv		fsrv;
static	CTablePack		pack;
static	CTablePackFile	packfile;
static	CTableAuth		auth;
static	CTableType		type;
static	CTableRule		rule;
static	CTableVote		vote;

// --------------------------------------------------------------------
// local:	Data associated with those tables
// --------------------------------------------------------------------
static	data_file_t		filedata		= { 0 };
static	data_fsrv_t		fsrvdata		= { 0 };
static	data_pack_t		packdata		= { 0 };
static	data_auth_t		authdata		= { 0 };
static	data_type_t		typedata		= { 0 };
static	dword_t			packcount		= 0;
static	dword_t			catnumber		= 0;
static	dword_t			catitem			= 0;
static	bool			serverflag		= false;

// --------------------------------------------------------------------
// local:	Output the package name
// --------------------------------------------------------------------
static	void	__packages	( void ) {
	if		( packcount < 1 ) {
		::printf( "- none -" );
	}
	else if	( packcount == 1 ) {
		::printf( "%s", packdata.pack_name );
	}
	else {
		::printf( "many...%d", packcount );
	}
}

// --------------------------------------------------------------------
// local:	Parser questions are sent here for answering
// --------------------------------------------------------------------
static	void	__answer	( const char * aQ ) {

	// ----------------------------------------------------------------
	// Local parsing
	// ----------------------------------------------------------------
	if		( ! ::strcmp( aQ, "query" ) )			::HTML_quote( query );

	else if	( ! ::strcmp( aQ, "pagenow" ) )			::printf( "%d", pagenow );
	else if	( ! ::strcmp( aQ, "pagenext" ) )		::printf( "%d", pagenow + 1 );
	else if	( ! ::strcmp( aQ, "pageprev" ) )		::printf( "%d", pagenow - 1 );
	else if	( ! ::strcmp( aQ, "lastpage" ) )		::printf( "%d", lastpage );
	else if	( ! ::strcmp( aQ, "rowcount" ) )		::printf( "%d", rowcount );
	else if	( ! ::strcmp( aQ, "linepair" ) )		::printf( "%d", rownumber & 0x01 );
	else if	( ! ::strcmp( aQ, "firstfile" ) )		::printf( "%d", (pagenow - 1) * linesperpage + 1 );
	else if	( ! ::strcmp( aQ, "lastfile" ) )		::printf( "%d", (pagenow - 1) * linesperpage + linesperpage );

	else if	( ! ::strcmp( aQ, "packages" ) )		__packages();

	else if	( ! ::strcmp( aQ, "catnumber" ) )		::printf( "%d", catnumber );
	else if	( ! ::strcmp( aQ, "catitem" ) )			::printf( "%d", catitem );

	else if	( ! ::strcmp( aQ, "packcount" ) )		::printf( "%d", packcount );

	else if	( ! ::strcmp( aQ, "previewer" ) )		::printf( "%s", previewer );

	else if	( ! ::strcmp( aQ, "multipack_b" ) )		::printf( "%s", packcount != 1 ? "" : ((filedata.file_flag & FLAG_NODOWNLOAD) == 0 ? "<!-- " : "") );
	else if	( ! ::strcmp( aQ, "multipack_e" ) )		::printf( "%s", packcount != 1 ? "" : ((filedata.file_flag & FLAG_NODOWNLOAD) == 0 ? " -->" : "") );

	else if	( ! ::strcmp( aQ, "singlepack_b" ) )	::printf( "%s", packcount == 1 ? "" : ((filedata.file_flag & FLAG_NODOWNLOAD) == 0 ? "<!-- " : "") );
	else if	( ! ::strcmp( aQ, "singlepack_e" ) )	::printf( "%s", packcount == 1 ? "" : ((filedata.file_flag & FLAG_NODOWNLOAD) == 0 ? " -->" : "") );

	else if	( ! ::strcmp( aQ, "pagenext_b" ) )		::printf( "%s", pagenow < lastpage ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "pagenext_e" ) )		::printf( "%s", pagenow < lastpage ? "" : " -->" );

	else if	( ! ::strcmp( aQ, "advanced_b" ) )		::printf( "%s", cgi.Exist( "advs" ) ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "advanced_e" ) )		::printf( "%s", cgi.Exist( "advs" ) ? "" : " -->" );

	else if	( ! ::strcmp( aQ, "simple_b" ) )		::printf( "%s", ! cgi.Exist( "advs" ) ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "simple_e" ) )		::printf( "%s", ! cgi.Exist( "advs" ) ? "" : " -->" );

	else if	( ! ::strcmp( aQ, "pagenext_bx" ) )		::printf( "%s", pagenow >= lastpage ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "pagenext_ex" ) )		::printf( "%s", pagenow >= lastpage ? "" : " -->" );

	else if	( ! ::strcmp( aQ, "pageprev_b" ) )		::printf( "%s", pagenow > 1 ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "pageprev_e" ) )		::printf( "%s", pagenow > 1 ? "" : " -->" );

	else if	( ! ::strcmp( aQ, "pageprev_bx" ) )		::printf( "%s", pagenow <= 1 ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "pageprev_ex" ) )		::printf( "%s", pagenow <= 1 ? "" : " -->" );

	else if	( ! ::strcmp( aQ, "servers_b" ) )		::printf( "%s", serverflag ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "servers_e" ) )		::printf( "%s", serverflag ? "" : " -->" );

	else if	( ! ::strcmp( aQ, "servers_bx" ) )		::printf( "%s", ! serverflag ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "servers_ex" ) )		::printf( "%s", ! serverflag ? "" : " -->" );

	else if	( ! ::strcmp( aQ, "dl_b" ) )			::printf( "%s", (filedata.file_flag & FLAG_NODOWNLOAD) == 0 ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "dl_e" ) )			::printf( "%s", (filedata.file_flag & FLAG_NODOWNLOAD) == 0 ? "" : " -->" );

	else if	( ! ::strcmp( aQ, "dl_bx" ) )			::printf( "%s", (filedata.file_flag & FLAG_NODOWNLOAD) != 0 ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "dl_ex" ) )			::printf( "%s", (filedata.file_flag & FLAG_NODOWNLOAD) != 0 ? "" : " -->" );

	else if	( ! ::strcmp( aQ, "pgln10" ) )			::printf( "%s", linesperpage == 10 ? " selected" : "" );
	else if	( ! ::strcmp( aQ, "pgln20" ) )			::printf( "%s", linesperpage == 20 ? " selected" : "" );
	else if	( ! ::strcmp( aQ, "pgln50" ) )			::printf( "%s", linesperpage == 50 ? " selected" : "" );
	else if	( ! ::strcmp( aQ, "pgln100" ) )			::printf( "%s", linesperpage == 100 ? " selected" : "" );
	else if	( ! ::strcmp( aQ, "pgln200" ) )			::printf( "%s", linesperpage == 200 ? " selected" : "" );

	else if	( ! ::strcmp( aQ, "ordr0" ) )			::printf( "%s", ordrselected == 0 ? " selected" : "" );
	else if	( ! ::strcmp( aQ, "ordr1" ) )			::printf( "%s", ordrselected == 1 ? " selected" : "" );
	else if	( ! ::strcmp( aQ, "ordr2" ) )			::printf( "%s", ordrselected == 2 ? " selected" : "" );
	else if	( ! ::strcmp( aQ, "ordr3" ) )			::printf( "%s", ordrselected == 3 ? " selected" : "" );
	else if	( ! ::strcmp( aQ, "ordr4" ) )			::printf( "%s", ordrselected == 4 ? " selected" : "" );
	else if	( ! ::strcmp( aQ, "ordr5" ) )			::printf( "%s", ordrselected == 5 ? " selected" : "" );
	else if	( ! ::strcmp( aQ, "ordr6" ) )			::printf( "%s", ordrselected == 6 ? " selected" : "" );
	else if	( ! ::strcmp( aQ, "ordr7" ) )			::printf( "%s", ordrselected == 7 ? " selected" : "" );

	else if	( ! ::strcmp( aQ, "pnax" ) )			::printf( "%s", cgi.Exist( "pnax" ) ? " checked" : "" );
	else if	( ! ::strcmp( aQ, "fnax" ) )			::printf( "%s", cgi.Exist( "fnax" ) ? " checked" : "" );
	else if	( ! ::strcmp( aQ, "anax" ) )			::printf( "%s", cgi.Exist( "anax" ) ? " checked" : "" );
	else if	( ! ::strcmp( aQ, "inax" ) )			::printf( "%s", cgi.Exist( "inax" ) ? " checked" : "" );
	else if	( ! ::strcmp( aQ, "enax" ) )			::printf( "%s", cgi.Exist( "enax" ) ? " checked" : "" );

	// ----------------------------------------------------------------
	// Scoring
	// ----------------------------------------------------------------
	else if	( previewscore.Answer( filedata, cgi, aQ, db ) );

	// ----------------------------------------------------------------
	// Parsing table data
	// ----------------------------------------------------------------
	else if	( ::MySqlTableParser( file.Layout(), "file", (const char *)(&filedata), aQ ) )	;
	else if	( ::MySqlTableParser( pack.Layout(), "pack", (const char *)(&packdata), aQ ) )	;
	else if	( ::MySqlTableParser( auth.Layout(), "auth", (const char *)(&authdata), aQ ) )	;
	else if	( ::MySqlTableParser( type.Layout(), "type", (const char *)(&typedata), aQ ) )	;
	else if	( ::MySqlTableParser( fsrv.Layout(), "fsrv", (const char *)(&fsrvdata), aQ ) )	;

	// ----------------------------------------------------------------
	// Parsing the CGI data
	// ----------------------------------------------------------------
	else if	( ::cgi_parser( cgi, aQ ) )	;

	// ----------------------------------------------------------------
	// Everything else goes to default parser
	// ----------------------------------------------------------------
	else	::my_default_answer( aQ );
}

// --------------------------------------------------------------------
// local:	Check if an argument was used
// --------------------------------------------------------------------
static	bool	__isused( const char * aName ) {
	if	( ! cgi.Exist( aName ) )	return false;
	const char * v = cgi.Arg( aName );
	if	( *v == 0 )	return false;
	return	::strcmp( v, "*" ) != 0;
}

// --------------------------------------------------------------------
// local:	Find category - there was a type but no category
// --------------------------------------------------------------------
static	void	__find_category	( void ) {
	data_type_t		data;
	data_type_tl	list;
	data_type_tli	loop;
	const char *	prevcat = "";
	dword_t			ctgr	= 0;

	list = type.Select( db, " where type_idnt > 0 order by type_ctgr, type_name" );

	for	( loop = list.begin(); loop != list.end(); loop++ ) {
		data = *loop;

		// Start of a new category
		if	( ::strcmp( prevcat, data.type_ctgr ) ) {
			prevcat = (*loop).type_ctgr;
			ctgr++;
		}

		// Is the type number same ?
		if	( typeselected == data.type_idnt ) {
			ctgrselected = ctgr;
			break;
		}
	}
}

// --------------------------------------------------------------------
// local:	Get category by number
// --------------------------------------------------------------------
static	const char *	__fetch_category	( void ) {
	data_type_tl	list;
	data_type_tli	loop;
	const char *	prevcat = "";

	list = type.Select( db, " where type_idnt > 0 order by type_ctgr, type_name" );

	catnumber	= 1;

	for	( loop = list.begin(); loop != list.end(); loop++ ) {
		typedata = *loop;

		// Start of a new category
		if	( ::strcmp( prevcat, typedata.type_ctgr ) ) {
			prevcat = (*loop).type_ctgr;
			if	( catnumber == ctgrselected ) break;
			catnumber++;
		}

	}
	return	typedata.type_ctgr;
}

// --------------------------------------------------------------------
// local:	Fetch record data (does the actual search)
// --------------------------------------------------------------------
static	data_file_tl	__fetch	( void ) {
	data_file_tl	list;
	CMySqlQuote		q;
	bool			u_auth	= __isused( "anam" );
	bool			u_pack	= __isused( "pnam" ) || __isused( "pnum" );
	bool			u_impt	= __isused( "inam" );
	bool			u_expt	= __isused( "enam" );
	bool			useand	= false;
	bool			usedist	= false;

	// ----------------------------------------------------------------
	// Setting up too complex query will abort the thing at once
	// ----------------------------------------------------------------
	if	( ( u_auth ) && ( u_pack ) && ( ( u_expt ) || ( u_impt ) ) ) {
		return	list;
	}

	// ----------------------------------------------------------------
	// Setting up the query string
	// ----------------------------------------------------------------
	::memset( query, 0, sizeof( query ) );

	// ----------------------------------------------------------------
	// Get along all the packages we really need
	// ----------------------------------------------------------------
	if	( u_pack )						::strcat( query, ",pack,packfile" );
	if	( u_auth )						::strcat( query, ",auth" );
	if	( ( u_impt ) || ( u_expt ) )	::strcat( query, ",xref" );
	::strcat( query, " WHERE" );

	// ----------------------------------------------------------------
	// Level 1 of 3 queries - the package
	// ----------------------------------------------------------------
	if	( u_pack ) {
		if		( __isused( "pnum" ) ) {
			::sprintf( query + ::strlen( query ), " pack.pack_idnt=%d", (dword_t)::atol( cgi.Arg( "pnum" ) ) );
		}
		else if	( cgi.Exist( "pnax" ) ) {
			::sprintf( query + ::strlen( query ), " pack.pack_name='%s'", q.Quote( cgi.Arg( "pnam" ) ) );
		}
		else {
			::sprintf( query + ::strlen( query ), " pack.pack_name LIKE '%s%s%s'", "%", q.Quote( cgi.Arg( "pnam" ) ), "%" );
		}

		::strcat( query, " AND packfile.packfile_pack=pack.pack_idnt" );
		useand	= true;
		usedist	= true;
	}

	// ----------------------------------------------------------------
	// Level 2 of 3 queries - the author
	// ----------------------------------------------------------------
	if	( u_auth ) {
		if	( useand )	::strcat( query, " AND" );
		if	( cgi.Exist( "anax" ) ) {
			::sprintf( 	query + ::strlen( query ), " auth.auth_name='%s'", q.Quote( cgi.Arg( "anam" ) ) );
		}
		else {
			::sprintf( 	query + ::strlen( query ), " auth.auth_name LIKE '%s%s%s'", "%", q.Quote( cgi.Arg( "anam" ) ), "%" );
		}

		useand	= true;
		usedist	= true;
	}

	// ----------------------------------------------------------------
	// Level 2 of 3 queries - the xref
	// ----------------------------------------------------------------
	if	( ( u_impt ) || ( u_expt ) ) {
		if	( useand )	::strcat( query, " AND" );
		if		( ( u_impt ) && ( u_expt ) ) {
			::strcat( query, "(" );
			if	( cgi.Exist( "inax" ) )	::sprintf( 	query + ::strlen( query ), "xref.xref_name='%s'", q.Quote( cgi.Arg( "inam" ) ) );
			else						::sprintf( 	query + ::strlen( query ), "xref.xref_name LIKE '%s%s%s'", "%", q.Quote( cgi.Arg( "inam" ) ), "%" );
			::strcat( query, ") OR (" );
			if	( cgi.Exist( "enax" ) )	::sprintf( 	query + ::strlen( query ), "xref.xref_name='%s'", q.Quote( cgi.Arg( "enam" ) ) );
			else						::sprintf( 	query + ::strlen( query ), "xref.xref_name LIKE '%s%s%s'", "%", q.Quote( cgi.Arg( "enam" ) ), "%" );
			::strcat( query, ")" );
		}
		else if	( u_impt ) {
			if	( cgi.Exist( "inax" ) )	::sprintf( 	query + ::strlen( query ), " xref.xref_name='%s' AND xref.xref_expo=0", q.Quote( cgi.Arg( "inam" ) ) );
			else						::sprintf( 	query + ::strlen( query ), " xref.xref_name LIKE '%s%s%s' AND xref.xref_expo=0", "%", q.Quote( cgi.Arg( "inam" ) ), "%" );
		}
		else if	( u_expt ) {
			if	( cgi.Exist( "enax" ) )	::sprintf( 	query + ::strlen( query ), " xref.xref_name='%s' AND xref.xref_expo=1", q.Quote( cgi.Arg( "enam" ) ) );
			else						::sprintf( 	query + ::strlen( query ), " xref.xref_name LIKE '%s%s%s' AND xref.xref_expo=1", "%", q.Quote( cgi.Arg( "enam" ) ), "%" );
		}

		useand	= true;
		usedist	= true;
	}

	// ----------------------------------------------------------------
	// Level 3 of 3 queries - the joins
	// ----------------------------------------------------------------
	if	( u_pack )						::strcat( query, " AND packfile.packfile_file=file.file_idnt" );
	if	( u_auth )						::strcat( query, " AND auth.auth_idnt=file.file_auth" );
	if	( ( u_impt ) || ( u_expt ) )	::strcat( query, " AND xref.xref_file=file.file_idnt" );

	// ----------------------------------------------------------------
	// Was there some special attention to category
	// ----------------------------------------------------------------
	if	( ctgrselected != 0 ) {
		if	( useand )	::strcat( query, " AND" );
		::sprintf( 	query + ::strlen( query ), " file.file_ctgr='%s'", __fetch_category() );
		useand = true;
	}

	// ----------------------------------------------------------------
	// Was there some special attention to type
	// ----------------------------------------------------------------
	if	( typeselected != 0 ) {
		if	( useand )	::strcat( query, " AND" );
		::sprintf( 	query + ::strlen( query ), " file.file_type=%d", typeselected );
		useand = true;
	}

	// ----------------------------------------------------------------
	// Was file name requested ?
	// ----------------------------------------------------------------
	if	( __isused( "fnam" ) ) {
		if	( useand )	::strcat( query, " AND" );
		if	( cgi.Exist( "fnax" ) )	::sprintf( query + ::strlen( query ), " file.file_name='%s'", q.Quote( cgi.Arg( "fnam" ) ) );
		else						::sprintf( query + ::strlen( query ), " file.file_name LIKE '%s%s%s'", "%", q.Quote( cgi.Arg( "fnam" ) ), "%" );
		useand = true;
	}

	// ----------------------------------------------------------------
	// File identifier alone ?
	// ----------------------------------------------------------------
	if	( cgi.Exist( "idnt" ) ) {
		if	( useand )	::strcat( query, " AND" );
		::sprintf( query + ::strlen( query ), " file.file_idnt=%d", (dword_t)::atol( cgi.Arg( "idnt" ) ) );
		useand = true;
	}

	// ----------------------------------------------------------------
	// Default query
	// ----------------------------------------------------------------
	if	( ! useand ) {
		::strcat( query, " file.file_idnt>0" );
	}

	// ----------------------------------------------------------------
	// Get number of rows for this query
	// ----------------------------------------------------------------
	rowcount = file.Count( db, query, usedist );
	lastpage = rowcount / linesperpage + 1;

	if	( (pagenow-1) * linesperpage >= rowcount )	return list;

	// ----------------------------------------------------------------
	// set up the order
	// ----------------------------------------------------------------
	::strcat( query, " ORDER BY file.file_" );
	switch	( ordrselected ) {
		case	0:	::strcat( query, "name" );	break;
		case	1:	::strcat( query, "type" );	break;
		case	2:	::strcat( query, "ctim desc" );	break;
		case	3:	::strcat( query, "atim desc" );	break;
		case	4:	::strcat( query, "ltim desc" );	break;
		case	5:	::strcat( query, "size desc" );	break;
		case	6:	::strcat( query, "dlct desc" );	break;
		case	7:	::strcat( query, "rate desc" );	break;
		default:	::strcat( query, "name" );	break;
	}

	// ----------------------------------------------------------------
	// Set up paging
	// ----------------------------------------------------------------
	::sprintf( query + ::strlen( query ), " LIMIT %d,%d", (pagenow-1) * linesperpage, linesperpage );

	// ----------------------------------------------------------------
	// Actually make the query
	// ----------------------------------------------------------------
	list = file.Select( db, query, usedist );

	return	list;
}

// --------------------------------------------------------------------
// local:	Build category lists
// --------------------------------------------------------------------
static	void	__category_lists	( void ) {
	data_type_tl	list;
	data_type_tli	loop;
	const char *	prevcat = "";
	bool			isfirst	= true;

	list = type.Select( db, " where type_idnt > 0 order by type_ctgr, type_name" );
	catnumber	= 0;
	for	( loop = list.begin(); loop != list.end(); loop++ ) {
		typedata = *loop;

		// Start of a new category
		if	( ::strcmp( prevcat, typedata.type_ctgr ) ) {
			if	( ! isfirst ) {
				previewtemplate.Execute( __answer, "tmpl-search-clst-tail" );
			}
			previewtemplate.Execute( __answer, "tmpl-search-clst-head" );
			prevcat = (*loop).type_ctgr;
			isfirst = false;
			catnumber++;
			catitem = 0;
		}

		previewtemplate.Execute( __answer, "tmpl-search-clst-body" );
		catitem++;
	}

	previewtemplate.Execute( __answer, "tmpl-search-clst-tail" );
}

// --------------------------------------------------------------------
// local:	Build category popup
// --------------------------------------------------------------------
static	void	__category_popup	( void ) {
	CMySqlWhere		w;
	data_type_tl	list;
	data_type_tli	loop;
	const char *	prevcat = "";

	w << "type_idnt > 0 order by type_ctgr, type_name";
	list = type.Select( db, w );

	catnumber = 0;

	previewtemplate.Execute( __answer, "tmpl-search-cpop-head" );

	catnumber = 1;
	for	( loop = list.begin(); loop != list.end(); loop++ ) {
		typedata = *loop;

		// Start of a new category
		if	( ::strcmp( prevcat, typedata.type_ctgr ) ) {
			previewtemplate.Execute( __answer, "tmpl-search-cpop-body" );
			catnumber++;
			prevcat = (*loop).type_ctgr;
		}
	}

	previewtemplate.Execute( __answer, "tmpl-search-cpop-tail" );
}

// --------------------------------------------------------------------
// local:	Head part of the form
// --------------------------------------------------------------------
static	void	__head	( void ) {
	if	( cgi.Exist( "advs" ) ) {
		__category_lists();
		previewtemplate.Execute( __answer, "tmpl-search-headtop" );
		__category_popup();
		previewtemplate.Execute( __answer, "tmpl-search-headend" );
	}
	else {
		previewtemplate.Execute( __answer, "tmpl-search-simple" );
	}
}

// --------------------------------------------------------------------
// local:	Body part of the form
// --------------------------------------------------------------------
static	void	__body	( void ) {
	CMySqlWhere			w;
	data_file_tl		list;
	data_type_tl		tlist;
	data_file_tli		loop;
	data_auth_tl		alist;
	data_rule_tl		rlist;
	data_packfile_tl	pflist;
	data_pack_tl		plist;
	
	list = __fetch();

	__head();
	if	( list.size() > 0 ) {
		previewtemplate.Execute( __answer, "tmpl-search-file-head" );
		rownumber = 0;
		for	( loop = list.begin(); loop != list.end(); loop++ ) {
			filedata = *loop;

			w = "";
			w << "packfile_file=" << filedata.file_idnt;
			pflist = packfile.Select( db, w );
			packcount = pflist.size();
			if	( pflist.size() == 1 ) {
				w = "";
				w << "pack_idnt=" << (*(pflist.begin())).packfile_pack;
				plist = pack.Select( db, w );
				if	( plist.size() == 1 ) {
					packdata = *(plist.begin());
				}
				else {
					::memset( &packdata, 0, sizeof( packdata ) );
				}
			}
			else {
				::memset( &packdata, 0, sizeof( packdata ) );
			}

			w = "";
			w << "auth_idnt=" << filedata.file_auth;
			alist = auth.Select( db, w );
			if	( alist.size() > 0 ) {
				authdata = *(alist.begin());
			}

			else {
				::memset( &authdata, 0, sizeof( authdata ) );
			}

			w = "";
			w << "type_idnt=" << filedata.file_type;
			tlist = type.Select( db, w );
			if	( tlist.size() > 0 ) {
				typedata = *(tlist.begin());
			}
			else {
				::memset( &typedata, 0, sizeof( typedata ) );
			}

			w = "";
			w << "rule_type=" << filedata.file_type << " and ";
			w << "rule_name='preview'";
			rlist = rule.Select( db, w );
			if	( rlist.size() > 0 ) {
				::strcpy( previewer, (*(rlist.begin())).rule_rule );
			}
			else {
				*previewer = 0;
			}

			w = "";
			w << "fsrv_file=" << filedata.file_idnt;
			serverflag = ( fsrv.Count( db, w ) > 0 );


			previewtemplate.Execute( __answer, "tmpl-search-file-body" );
			rownumber++;
		}
		previewtemplate.Execute( __answer, "tmpl-search-file-tail" );
	}
	else {
		previewtemplate.Execute( __answer, "tmpl-search-file-none" );
	}
}

// --------------------------------------------------------------------
// local:	Body part of the packlist form
// --------------------------------------------------------------------
static	void	__pack	( void ) {
	CMySqlWhere			w;
	data_file_tl		list;
	data_packfile_tl	pflist;
	data_packfile_tli	pfloop;
	data_pack_tl		plist;

	list = __fetch();
	if	( list.size() > 0 ) {
		filedata = *(list.begin());
	}

	w << "packfile_file=" << filedata.file_idnt;
	pflist = packfile.Select( db, w );
	rowcount = pflist.size();

	if		( pflist.size() > 1 ) {
		__head();

		previewtemplate.Execute( __answer, "tmpl-search-pack-head" );
		rownumber = 0;
		for	( pfloop = pflist.begin(); pfloop != pflist.end(); pfloop++ ) {
	
			w = "";
			w << "pack_idnt=" << (*pfloop).packfile_pack;
			plist = pack.Select( db, w );
	
			if	( plist.size() > 0 ) {
				packdata = *(plist.begin());
				previewtemplate.Execute( __answer, "tmpl-search-pack-body" );
				rownumber++;
			}
		}
		previewtemplate.Execute( __answer, "tmpl-search-pack-tail" );
	}
	else if	( pflist.size() == 1 ) {
		w = "";
		w << "pack_idnt=" << (*(pflist.begin())).packfile_pack;
		plist = pack.Select( db, w );
		packdata = *(plist.begin());

		cgi.Arg( "pnam", packdata.pack_name );
		cgi.Arg( "pnum", packdata.pack_idnt );
		cgi.Arg( "pnax", (dword_t)1 );
		cgi.Arg( "idnt", "" );
		cgi.Arg( "fnam", "" );
		cgi.Arg( "fnax", "" );
		cgi.Arg( "anam", "" );
		cgi.Arg( "anax", "" );
		cgi.Arg( "task", "list" );
		__body();
	}
	else {
		__head();
		previewtemplate.Execute( __answer, "tmpl-search-pack-none" );
	}
}

// --------------------------------------------------------------------
// local:	Prevent spam
// --------------------------------------------------------------------
static	bool	__spam	( dword_t aPgln ) {
	bool	is_spam	= false;

	try	{
		CSpam	myspam1( cgi.Arg( CGI_REMOTE_ADDR ), cgi.Arg( CGI_QUERY_STRING ), 1 + aPgln / 20 );
		CSpam	myspam2( cgi.Arg( CGI_REMOTE_ADDR ), "SearchSpamDetection", 1 + aPgln / 50 );
	}

	catch	( CError e ) {
		is_spam = true;
	}

	return	is_spam;
}

// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {
	::srand( (unsigned int)::time( NULL ) );
	::HTTP_text( "en" );

	if	( ! ::strcmp( cgi.Arg( "task" ), "list" ) ) {
		if	( __spam( ::atol( cgi.Arg( "pgln" ) ) ) ) {
			previewtemplate.Execute( __answer, "tmpl-spam-warning" );
			::fflush( stdout );
			::fclose( stdout );
			return	-1;
		}
	}

	if	( ! cgi.Exist( "type" ) )	cgi.Arg( "type", (dword_t)0 );
	if	( ! cgi.Exist( "pgln" ) )	cgi.Arg( "pgln", (dword_t)20 );
	if	( ! cgi.Exist( "page" ) )	cgi.Arg( "page", (dword_t)1 );
	if	( ! cgi.Exist( "task" ) )	cgi.Arg( "task", "init" );
	if	( ! cgi.Exist( "ordr" ) )	cgi.Arg( "ordr", (dword_t)0 );

	typeselected = ::atol( cgi.Arg( "type" ) );
	ctgrselected = ::atol( cgi.Arg( "ctgr" ) );
	ordrselected = ::atol( cgi.Arg( "ordr" ) );
	linesperpage = ::atol( cgi.Arg( "pgln" ) );
	if		( linesperpage < 10 ) {
		linesperpage = 20;
		cgi.Arg( "pgln", (dword_t)20 );
	}
	else if	( linesperpage > 200 ) {
		linesperpage = 200;
		cgi.Arg( "pgln", (dword_t)200 );
	}

	if	( ( typeselected != 0 ) && ( ctgrselected == 0 ) ) {
		__find_category();
		cgi.Arg( "ctgr", ctgrselected );
	}
	pagenow		 = ::atol( cgi.Arg( "page" ) );

	try	{
		vote.Delete( db, " where now()-vote_time > 1800" );
		previewtemplate.Execute( __answer, "tmpl-search-formdata" );
		if		( ! ::strcmp( cgi.Arg( "task" ), "list" ) )	__body();
		else if	( ! ::strcmp( cgi.Arg( "task" ), "pack" ) )	__pack();
		else												__head();
		previewtemplate.Execute( __answer, "tmpl-search-tail" );
	}

	catch 	( CError e ) {
		::printf( "<p>Error: " );
		::HTML_quote( e.Error() );
		::printf( "</p>" );
	}

	catch	( ... ) {
		::printf( "<p>Error: Unknown error</p>" );
	}
	::fflush( stdout );
	::fclose( stdout );
    return	0;
}

// --------------------------------------------------------------------
// EOF: Storage.cxx
// --------------------------------------------------------------------
