// --------------------------------------------------------------------
// SendShot.cxx
// Whatis:  CGI for sending a screenshot
// CGI arguments:	This one takes the arguments as path instead of
//					the normal CGI arguments
//
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 14-JUN-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CStorage.hxx"
#include    "CCache.hxx"
#include    "CTableFile.hxx"
#include	"CMySqlWhere.hxx"
#include	"CUnUtils.hxx"
#include	"CUnLevelInfo.hxx"
#include	"CPicture.hxx"
#include	"CPictureSourceUTX.hxx"
#include	"CPictureSourceJPG.hxx"
#include	"CFurpileLogo.hxx"
#include	"CZipStreamStdout.hxx"

// --------------------------------------------------------------------
// local:	The local data
// --------------------------------------------------------------------
static	CMySqlConnect				db			( "quest", "", "UTCMS" );
static	CCache						pvcache		( "preview" );

// --------------------------------------------------------------------
// local:	Send the image data
// --------------------------------------------------------------------
static	void	__send_screenshot	( dword_t aFid, dword_t aShn ) {
	CMySqlWhere		w;
	CTableFile		file;
	data_file_tl	flist;
	data_file_t		filedata;

	// The file itself
	w << "file_idnt=" << aFid;
	flist = file.Select( db, w );
	if	( flist.size() == 0 ) {
		throw CError( w.Where(), "No such file" );
	}
	filedata = *(flist.begin());

	char	prevfile[1024];
	char	filepath[1024];

	::sprintf( 	prevfile, "%d-file.%s",
				filedata.file_idnt,
				filedata.file_suff );

	pvcache.MakeDirname( filepath, prevfile );

	if	( ! pvcache.Exist( filepath ) ) {
		CStorage	storage;
		storage.Load( filepath, filedata.file_idnt );
		pvcache.Cache( filepath );
	}

	CUnUtils		unrutils( filepath );
	CUnLevelInfo	levelinfo(	unrutils.UnFile(),
								unrutils.UnNameTable(),
								unrutils.UnExportTable(),
								unrutils.UnImportTable() );

	if	( aShn >= levelinfo.ShotCount() )	throw CError( "Invalid shot" );


	::sprintf(	prevfile, "%d-ss-%d.jpg",
				filedata.file_idnt,
				aShn );
	pvcache.MakeDirname( filepath, prevfile );

	if	( ! pvcache.Exist( filepath ) ) {
		CPicture			mypicture;
		CPictureSourceUTX	myutx( levelinfo.Screenshot( aShn ) );
		CPictureSourceJPG	myjpg( filepath, 70 );
		CFurpileLogo		logo( "Furpile.utx" );

		mypicture.Load	( myutx );
		logo.Plant( mypicture.PixmapRef() );
		mypicture.Save	( myjpg );
		pvcache.Cache	( filepath );
	}

	struct	stat	mystat;

	::stat( filepath, &mystat );
	::HTTP_image( "jpeg", mystat.st_size );

	FILE *				strm = ::fopen( filepath, "rb" );
	char				jpgbuff[8192];
	CZipStreamStdout	output( 20 );	// 20 KB/sec throttle
	size_t				rcnt;

	if	( strm ) {
		while	( ! feof( strm ) ) {
			rcnt = ::fread( jpgbuff, 1, sizeof( jpgbuff ), strm );
			if	( ferror( strm ) )	break;
			if	( rcnt > 0 ) {
				output.Write( jpgbuff, (dword_t)rcnt );
			}
		}
		::fclose( strm );
	}
}

// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {
	::srand( (unsigned int)::time( NULL ) );

	try	{

		// Now, is there a path component ?
		const char *	pinfo = ::getenv( "PATH_INFO" );
		if	( ! pinfo )	throw CError( "No such file" );

		dword_t		fid	= 0;
		dword_t		shn = 0;

		// Skip over the first slash
		if	( *pinfo != '/' )	throw CError( "No such file" );
		pinfo++;

		// Collect fid until we meet the next slash or end of string
		while	( ( *pinfo ) && ( *pinfo != '/' ) ) {
			fid = 10 * fid + (dword_t)( (*pinfo - '0') & 0x0f );
			pinfo++;
		}

		// Skip over the next slash
		if	( *pinfo != '/' )	throw CError( "No such file" );
		pinfo++;

		// Collect shn until we meet the terminating dot
		while	( ( *pinfo ) && ( *pinfo != '.' ) ) {
			shn = 10 * shn + (dword_t)( (*pinfo - '0') & 0x0f );
			pinfo++;
		}

		// We MUST have .jpg left here
		if	( ::strcmp( pinfo, ".jpg" ) )	throw CError( "No such file" );


		// Least but not last send the screenie
		__send_screenshot( fid, shn );
	}

	catch 	( CError e ) {
		::HTTP_text( "en" );
		::printf( "<p>Error: " );
		::HTML_quote( e.Error() );
		::printf( "</p>" );
		return	-1;
	}

	catch	( ... ) {
		::HTTP_text( "en" );
		::printf( "<p>Error: Unknown error</p>" );
		return	-1;
	}
    return	0;
}

// --------------------------------------------------------------------
// EOF: Screenshot.cxx
// --------------------------------------------------------------------
