// --------------------------------------------------------------------
// ServerList.cxx
// Whatis:  CGI for sending a screenshot
// CGI arguments:	This one takes the arguments as path instead of
//					the normal CGI arguments
//
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 14-JUN-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CTableSrvr.hxx"
#include	"CMySqlWhere.hxx"

// --------------------------------------------------------------------
// local:	The local data
// --------------------------------------------------------------------
static	CMySqlConnect	db	( "quest", "", "UTCMS" );

// --------------------------------------------------------------------
static	void	__send	( const char * aType ) {
	CMySqlWhere		w;
	CTableSrvr		srvr;
	data_srvr_tl	list;
	data_srvr_tli	loop;
	bool			ut2003 = (::strcmp( aType, "UT" ) != 0);

	w << "srvr_type='" << aType << "' AND srvr_port!=0";

	list = srvr.Select( db, w );

	::HTTP_text( "en" );
	for	( loop = list.begin(); loop != list.end(); loop++ ) {
		::printf( "%s ", (*loop).srvr_addr );
		::printf( "%d ", (*loop).srvr_port );
		::printf( "%d",  ut2003 ? (*loop).srvr_port + 10 : (*loop).srvr_quep );
		::printf( "\n" );
	}

}

// --------------------------------------------------------------------
static	void	__details	( const char * aType ) {
	CMySqlWhere		w;
	CTableSrvr		srvr;
	data_srvr_tl	list;
	data_srvr_tli	loop;

	w << "srvr_type='" << aType << "' AND srvr_port!=0";

	list = srvr.Select( db, w );

	::HTTP_text( "en" );
	for	( loop = list.begin(); loop != list.end(); loop++ ) {
		::printf( "%s ", (*loop).srvr_addr );
		::printf( "%d ", (*loop).srvr_port );
		::printf( "%d ", (*loop).srvr_quep );
		::printf( "%s ", (*loop).srvr_gtyp );
		::printf( "%s ", (*loop).srvr_gmap );
		::printf( "%d ", (*loop).srvr_pcur );
		::printf( "%d ", (*loop).srvr_pmax );
		::printf( "%s ", ::my_time_string( (*loop).srvr_time ) );
		::printf( "%s",  (*loop).srvr_name );
		::printf( "\n" );
	}

}

	char	srvr_addr	[65];
	dword_t	srvr_port	;
	dword_t	srvr_quep	;
	char	srvr_type	[9];
	char	srvr_name	[201];
	char	srvr_gmap	[65];
	char	srvr_gttl	[201];
	char	srvr_gtyp	[33];
	dword_t	srvr_pcur	;
	dword_t	srvr_pmax	;
	time_t	srvr_time	;


// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {
	::srand( (unsigned int)::time( NULL ) );

	try	{

		// Now, is there a path component ?
		const char *	pinfo = ::getenv( "PATH_INFO" );
		if	( ! pinfo )	throw CError( "No such file" );

		// Skip over the first slash
		if	( *pinfo != '/' )	throw CError( "No such file" );
		pinfo++;

		// Now, do we have UT2003.txt or UT.txt
		if		( ! ::strcmp( "UT2003.txt", pinfo ) ) {
			__send( "UT2003" );
		}
		else if	( ! ::strcmp( "UT.txt", pinfo ) ) {
			__send( "UT" );
		}
		else if	( ! ::strcmp( "UT2003details.txt", pinfo ) ) {
			__details( "UT2003" );
		}
		else if	( ! ::strcmp( "UTdetails.txt", pinfo ) ) {
			__details( "UT" );
		}
		else {
			throw CError( "No such file" );
		}
	}

	catch 	( CError e ) {
		::HTTP_html( "en" );
		::printf( "<html><body><p>Error: " );
		::HTML_quote( e.Error() );
		::printf( "</p></body></html>" );
		return	-1;
	}

	catch	( ... ) {
		::HTTP_html( "en" );
		::printf( "<html><body><p>Error: Unknown error</p></body></html>" );
		return	-1;
	}
    return	0;
}

// --------------------------------------------------------------------
// EOF: Screenshot.cxx
// --------------------------------------------------------------------
