// --------------------------------------------------------------------
// T3Dshot.cxx
// Whatis:  CGI for extracting a screenshot from an UNR file
// CGI arguments:
//
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 14-JUN-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CStorage.hxx"
#include    "CCache.hxx"
#include    "CTableFile.hxx"
#include	"CCgiArgs.hxx"
#include	"CMySqlWhere.hxx"
#include	"CUnUtils.hxx"
#include	"CPicture.hxx"
#include	"CPictureSourceT3D.hxx"
#include	"CPictureSourceJPG.hxx"
#include	"CPictureFilterAlphaBlend.hxx"
#include	"CPictureFilterScale.hxx"
#include	"CFurpileLogo.hxx"

// --------------------------------------------------------------------
// local:	The local data
// --------------------------------------------------------------------
static	CCgiArgs					cgi;
static	CMySqlConnect				db			( "quest", "", "UTCMS" );
static	CCache						pvcache		( "preview" );
static	CPictureFilterAlphaBlend	alphablend	( 0x1b, 0x00, 0x3e, 0xff );

// --------------------------------------------------------------------
// local:	Send the image data
// --------------------------------------------------------------------
static	void	__send_screenshot	( void ) {
	CMySqlWhere		w;
	CTableFile		file;
	data_file_tl	flist;
	data_file_t		filedata;

	// The file itself
	w << "file_idnt=" << (dword_t)::atol( cgi.Arg( "file_idnt" ) );
	flist = file.Select( db, w );
	if	( flist.size() == 0 ) {
		throw CError( w.Where(), "No such file" );
	}
	filedata = *(flist.begin());

	char	t3dfile	[1024];
	char	t3dpath	[1024];

	char	prevfile[1024];
	char	filepath[1024];

	::sprintf( 	t3dfile, "%d-file.%s",
				filedata.file_idnt,
				filedata.file_suff );

	pvcache.MakeDirname( t3dpath, t3dfile );

	if	( ! pvcache.Exist( t3dpath ) ) {
		CStorage	storage;
		storage.Load( t3dpath, filedata.file_idnt );
		pvcache.Cache( t3dpath );
	}

	int	camera = ::atoi( cgi.Arg( "camera" ) );
	if	( camera < 0 )	camera = 0;
	if	( camera > 2 )	camera = 2;

	::sprintf(	prevfile, "%d-sx-%d.jpg",
				filedata.file_idnt,
				camera );

	pvcache.MakeDirname( filepath, prevfile );

	// Create the file if it does not exist
	if	( ! pvcache.Exist( filepath ) ) {
		CPictureSourceT3D	myt3d( t3dpath );
		CPictureSourceJPG	myjpg( filepath, 70 );
		CPicture			mypicture;
		CFurpileLogo		logo( "Furpile.utx" );

		myt3d.Camera( camera );

		while	( ( myt3d.W() < 512 ) && ( myt3d.H() < 512 ) ) {
			myt3d.Factor( myt3d.Factor() * 1.2 );
		}


		mypicture.Load( myt3d );

		if	( mypicture.W() > 640 ) {
			CPictureFilterScale	scale( 640, (mypicture.H() * 640) / mypicture.W() );
			mypicture.Filter( scale );
		}

		mypicture.Filter( alphablend );
		logo.Plant( mypicture.PixmapRef() );
		mypicture.Save( myjpg );
		pvcache.Cache( filepath );
	}

	if	( ! pvcache.Exist( filepath ) ) {
		CPicture			mypicture;
		CPictureSourceT3D	myutx( t3dpath );
		CPictureSourceJPG	myjpg( filepath, 70 );
		CFurpileLogo		logo( "Furpile.utx" );

		mypicture.Load	( myutx );
		mypicture.Filter( alphablend );
		logo.Plant( mypicture.PixmapRef() );
		mypicture.Save	( myjpg );
		pvcache.Cache	( filepath );
	}

	struct	stat	mystat;

	::stat( filepath, &mystat );
	::HTTP_image( "jpeg", mystat.st_size );

	FILE *	strm = ::fopen( filepath, "rb" );
	int		chr;

	if	( strm ) {
		while	( ! feof( strm ) ) {
			chr = ::fgetc( strm );
			if	( chr >= 0 ) {
				::putchar( chr );
			}
		}
		::fclose( strm );
	}
}

// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {
	::srand( (unsigned int)::time( NULL ) );

	try	{
		__send_screenshot();

	}

	catch 	( CError e ) {
		::HTTP_text( "en" );
		::printf( "<p>Error: " );
		::HTML_quote( e.Error() );
		::printf( "</p>" );
		::fflush( stdout );
		::fclose( stdout );
		return	-1;
	}

	catch	( ... ) {
		::HTTP_text( "en" );
		::printf( "<p>Error: Unknown error</p>" );
		::fflush( stdout );
		::fclose( stdout );
		return	-1;
	}
	::fflush( stdout );
	::fclose( stdout );
    return	0;
}

// --------------------------------------------------------------------
// EOF: T3Dshot.cxx
// --------------------------------------------------------------------
