// --------------------------------------------------------------------
// Test.cxx
// Whatis:  Manipulates the file storage @ UTCMS
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 02-JUN-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include	"CUnMasterServer.hxx"

//---------------------------------------------------------------------------
const char *	typestring( unreal_server_t aT ) {
	if	( aT == unreal_server_ut )	return "UT";
	if	( aT == unreal_server_2003 )	return "UT2003";
    return "????";
}

//---------------------------------------------------------------------------
int main(int argc, char* argv[]) {
    if	( argc < 3 )	return 0 ;

	CUnMasterServerItem_tlci	loop;
	CUnMasterServer	myserver( argv[1], (word_t)::atol(argv[2]), unreal_server_2003 );


    for	( 	loop  = myserver.ServerList().begin();
            loop != myserver.ServerList().end();
            loop++ ) {

		CUnMasterServerItem	item( *loop );

		::printf( "  Address: %s", item.IpAddress() );
        ::printf( "  Port: %d", item.QueryPort() );
        ::printf( "  Type: %s\n", typestring( item.ServerType() ) );
    }
	return 0;
}

// --------------------------------------------------------------------
// EOF: Storage.cxx
// --------------------------------------------------------------------
