// --------------------------------------------------------------------
// Top10.cxx
// Whatis:  CGI for making the top10 rank lists
// CGI arguments:
//
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 29-DEC-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CTablePref.hxx"
#include    "CTableFile.hxx"
#include    "CTableAuth.hxx"
#include    "CTableRule.hxx"
#include    "CTableVote.hxx"
#include	"CCgiArgs.hxx"
#include	"CMySqlWhere.hxx"
#include    "CPreviewTemplate.hxx"
#include    "CPreviewScore.hxx"

// --------------------------------------------------------------------
// local:	The local data
// --------------------------------------------------------------------
static	CCgiArgs			cgi;
static	CMySqlConnect		db			( "quest", "", "UTCMS" );
static	char				previewer	[1024] = { 0 };

// --------------------------------------------------------------------
// local:	Database data
// --------------------------------------------------------------------
static	CTableRule			rule;
static	CTableFile			file;
static	CTableVote			vote;
static	data_file_t			filedata;
static	CTableAuth			auth;
static	data_auth_t			authdata;
static	dword_t				placing = 1;

// --------------------------------------------------------------------
// local:	Some needed stuff
// --------------------------------------------------------------------
static	CPreviewTemplate			previewtemplate;
static	CPreviewScore				previewscore;

// --------------------------------------------------------------------
// local:	Parser questions are sent here for answering
// --------------------------------------------------------------------
static	void	__answer	( const char * aQ ) {

	// ----------------------------------------------------------------
	// Local parsing
	// ----------------------------------------------------------------
	if		( ::cgi_parser( cgi, aQ ) )	;
	else if	( ! ::strcmp( aQ, "previewer" ) )		::printf( "%s", previewer );
	else if	( ! ::strcmp( aQ, "placing" ) )			::printf( "%d", placing );
	else if	( ! ::strcmp( aQ, "linepair" ) )		::printf( "%d", placing & 0x01 );

	// ----------------------------------------------------------------
	// Scoring
	// ----------------------------------------------------------------
	else if	( previewscore.Answer( filedata, cgi, aQ, db ) );

	// ----------------------------------------------------------------
	// Table parsing
	// ----------------------------------------------------------------
	else if	( ::MySqlTableParser( file.Layout(), "file", (const char *)(&filedata), aQ ) )	;
	else if	( ::MySqlTableParser( auth.Layout(), "auth", (const char *)(&authdata), aQ ) )	;

	// ----------------------------------------------------------------
	// Everything else goes to default parser
	// ----------------------------------------------------------------
	else	::my_default_answer( aQ );
}


// --------------------------------------------------------------------
// local:	Best files
// --------------------------------------------------------------------
static	void	__best_maps		( void ) {
	CMySqlWhere		w;
	data_file_tl	filelist;
	data_file_tli	fileloop;
	data_rule_tl	rulelist;

	previewtemplate.Execute( __answer, "tmpl-rank-bmap-head" );

	filelist = file.Select(	db, " where file_suff='unr' or file_suff='ut2' order by file_rate desc limit 0, 100" );

	for	( fileloop = filelist.begin(); fileloop != filelist.end(); fileloop++ ) {
		filedata = *fileloop;

		w = "";
		w << "rule_type=" << filedata.file_type << " and ";
		w << "rule_name='preview'";
		rulelist = rule.Select( db, w );
		if	( rulelist.size() > 0 ) {
			::strcpy( previewer, (*(rulelist.begin())).rule_rule );
		}
		else {
			*previewer = 0;
		}


		previewtemplate.Execute( __answer, "tmpl-rank-bmap-body" );
		placing++;
	}

	previewtemplate.Execute( __answer, "tmpl-rank-bmap-tail" );
}

// --------------------------------------------------------------------
// local:	Best authors
// --------------------------------------------------------------------
static	void	__best_authors	( void ) {
	data_auth_tl	authlist;
	data_auth_tli	authloop;

	previewtemplate.Execute( __answer, "tmpl-rank-baut-head" );

	authlist = auth.Select(	db, " order by auth_rate desc limit 0, 100" );

	for	( authloop = authlist.begin(); authloop != authlist.end(); authloop++ ) {
		authdata = *authloop;
		previewtemplate.Execute( __answer, "tmpl-rank-baut-body" );
		placing++;
	}

	previewtemplate.Execute( __answer, "tmpl-rank-baut-tail" );
}

// --------------------------------------------------------------------
// local:	Worst maps
// --------------------------------------------------------------------
static	void	__worst_maps	( void ) {
	CMySqlWhere		w;
	data_file_tl	filelist;
	data_file_tli	fileloop;
	data_rule_tl	rulelist;

	previewtemplate.Execute( __answer, "tmpl-rank-wmap-head" );

	filelist = file.Select(	db, " where file_suff='unr' or file_suff='ut2' order by file_rate asc limit 0, 100" );

	for	( fileloop = filelist.begin(); fileloop != filelist.end(); fileloop++ ) {
		filedata = *fileloop;

		w = "";
		w << "rule_type=" << filedata.file_type << " and ";
		w << "rule_name='preview'";
		rulelist = rule.Select( db, w );
		if	( rulelist.size() > 0 ) {
			::strcpy( previewer, (*(rulelist.begin())).rule_rule );
		}
		else {
			*previewer = 0;
		}


		previewtemplate.Execute( __answer, "tmpl-rank-wmap-body" );
		placing++;
	}

	previewtemplate.Execute( __answer, "tmpl-rank-wmap-tail" );
}

// --------------------------------------------------------------------
// local:	Worst authors
// --------------------------------------------------------------------
static	void	__worst_authors	( void ) {
	data_auth_tl	authlist;
	data_auth_tli	authloop;

	previewtemplate.Execute( __answer, "tmpl-rank-waut-head" );

	authlist = auth.Select(	db, " order by auth_rate asc limit 0, 100" );

	for	( authloop = authlist.begin(); authloop != authlist.end(); authloop++ ) {
		authdata = *authloop;
		previewtemplate.Execute( __answer, "tmpl-rank-waut-body" );
		placing++;
	}

	previewtemplate.Execute( __answer, "tmpl-rank-waut-tail" );
}

// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {
	::srand( (unsigned int)::time( NULL ) );
	::HTTP_text( "en" );

	try	{
		switch	( ::atol( cgi.Arg( "mode" ) ) ) {
			case	0:	__best_maps		();	break;
			case	1:	__best_authors	();	break;
			case	2:	__worst_maps	();	break;
			case	3:	__worst_authors	();	break;
			default	:	throw CError( cgi.Arg( "mode" ), "Invalid mode" );
		}
	}

	catch 	( CError e ) {
		::printf( "Error : " );
		::HTML_quote( e.Error() );
		::fflush( stdout );
		::fclose( stdout );
		return	-1;
	}

	catch	( ... ) {
		::printf( "Error : Unknown error" );
		::fflush( stdout );
		::fclose( stdout );
		return	-1;
	}

	::fflush( stdout );
	::fclose( stdout );
    return	0;
}

// --------------------------------------------------------------------
// EOF: PreviewTexture.cxx
// --------------------------------------------------------------------
