//---------------------------------------------------------------------------
#ifdef	__TURBOC__
#pragma hdrstop
#include <condefs.h>
#endif

#include	"CError.hxx"
#include	"CUnUtils.hxx"

#ifdef	__TURBOC__
//---------------------------------------------------------------------------
USEUNIT("src\CUnUtils.cpp");
USEUNIT("src\CError.cpp");
USEUNIT("src\CUnExport.cpp");
USEUNIT("src\CUnExportTable.cpp");
USEUNIT("src\CUnFile.cpp");
USEUNIT("src\CUnImport.cpp");
USEUNIT("src\CUnImportTable.cpp");
USEUNIT("src\CUnName.cpp");
USEUNIT("src\CUnNameTable.cpp");
USEUNIT("src\CUnObjectFlags.cpp");
USEUNIT("src\CIOConvert.cpp");
USEUNIT("src\PlatStr.cpp");
//---------------------------------------------------------------------------
#pragma argsused
#endif

int main(int argc, char* argv[]) {
	int	result;

	try	{
    	if	( argc < 2 ) {
			throw	CError( "Missing input file name" );
        }
        else {
			CUnUtils		utl( argv[1] );
			unr_package_tl	list;
			unr_package_tli	loop;

            list = utl.ImportList();
            for	( loop = list.begin(); loop != list.end(); loop++ ) {
            	::printf( "%s\n", (*loop).name );
            }
        }
        result = 0;
    }

    catch	( CError e ) {
    	::printf( "ERROR : %s : %s\n", argv[0], e.Error() );
        result = 1;
    }

    catch	( ... ) {
    	::printf( "ERROR : %s : Unknown error\n", argv[0] );
        result = 1;
    }

	return	result;
}

//---------------------------------------------------------------------------
