// --------------------------------------------------------------------
// CUnExport.cxx
// Whatis:  Unreal Export
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CUnExport.hxx"
#include	"CError.hxx"

// --------------------------------------------------------------------
// public:      Constructor #1
// --------------------------------------------------------------------
CUnExport::CUnExport( CUnFile & aUf ) {
	try {
	    CUnExport::Cleanup();
	    itsClass        = aUf.ReadIndex();
	    itsSuper        = aUf.ReadIndex();
	    itsPackage      = aUf.ReadDword();
	    itsObjectName   = aUf.ReadIndex();
	    itsFlags        = aUf.ReadDword();
	    itsSerialSize   = aUf.ReadIndex();
	    if  ( itsSerialSize > 0 ) itsSerialOffset = aUf.ReadIndex();
	}

	catch	( CError e ) {
		throw	CError( "CUnExport::CUnExport", e.Error() );
	}
}

// --------------------------------------------------------------------
// public:      Constructor #2
// --------------------------------------------------------------------
CUnExport::CUnExport() {
    CUnExport::Cleanup();
}

// --------------------------------------------------------------------
// public:      Destructor
// --------------------------------------------------------------------
CUnExport::~CUnExport() {
    CUnExport::Cleanup();
}


// --------------------------------------------------------------------
// public:      Clean it up
// --------------------------------------------------------------------
void        CUnExport::Cleanup( void ) {
    itsClass        = 0;
    itsSuper        = 0;
    itsPackage      = 0;
    itsObjectName   = 0;
    itsFlags        = 0;
    itsSerialSize   = 0;
    itsSerialOffset = 0;
}

// --------------------------------------------------------------------
dword_t             CUnExport::Class           ( void ) const { return itsClass; }
dword_t             CUnExport::Super           ( void ) const { return itsSuper; }
dword_t             CUnExport::Package         ( void ) const { return itsPackage; }
dword_t             CUnExport::ObjectName      ( void ) const { return itsObjectName; }
CUnObjectFlags_t    CUnExport::Flags           ( void ) const { return itsFlags; }
dword_t             CUnExport::SerialSize      ( void ) const { return itsSerialSize; }
dword_t             CUnExport::SerialOffset    ( void ) const { return itsSerialOffset; }

// --------------------------------------------------------------------
// EOF: CUnExport.cxx
// --------------------------------------------------------------------
