// --------------------------------------------------------------------
// CUnFile.hxx
// Whatis:	Unreal file	reader
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-NOV-2001		Created	this source
// --------------------------------------------------------------------
#ifndef	CUnFile_hxx
#define	CUnFile_hxx
#include	"UnTypes.hxx"	// Unreal file data	types (Package Flags)

// --------------------------------------------------------------------
// Declaration of the CUnFile class
// --------------------------------------------------------------------
class	CUnFile	{

	// ----------------------------------------------------------------
	public:		// Constructors
	// ----------------------------------------------------------------
	CUnFile	( const	char * );	// Use file	name

	// ----------------------------------------------------------------
	public:		// Destructor
	// ----------------------------------------------------------------
	~CUnFile();

	// ----------------------------------------------------------------
	private:	// Copy	constructor	and	assignment operators are lethal
				// and therefore made private (won't compile if	used)
	// ----------------------------------------------------------------
	CUnFile				 ( const CUnFile & );
	CUnFile	& operator = ( const CUnFile & );

	// ----------------------------------------------------------------
	public:		// Reading the data
	// ----------------------------------------------------------------
	byte_t			ReadByte	( void );
	word_t			ReadWord	( void );
	dword_t			ReadDword	( void );
	int1_t			ReadInt1	( void );
	int2_t			ReadInt2	( void );
	int4_t			ReadInt4	( void );
	dword_t			ReadIndex	( void );
	dword_t			ReadArrIdx	( void );
	void			ReadRawData	( void *, size_t );
	void			ReadText	( char *, size_t );
	float			ReadFloat	( void );

	// ----------------------------------------------------------------
	public:		// File	management
	// ----------------------------------------------------------------
	const char *	FileName	( void ) const;
	time_t			FileTime	( void ) const;
	size_t			FileSize	( void ) const;
	void			Seek		( long ) ;
	long			Offset		( void ) const;
	long			Size		( void ) ;

	// ----------------------------------------------------------------
	public:		// Accessing the instance data
	// ----------------------------------------------------------------
	dword_t			Signature			( void ) const;
	word_t			PackageVersion		( void ) const;
	word_t			LicenseeMode		( void ) const;
	dword_t			PackageFlags		( void ) const;
	bool			AllowDownload		( void ) const;
	bool			ClientOptional		( void ) const;
	bool			ServerSideOnly		( void ) const;
	bool			BrokenLinks			( void ) const;
	bool			Unsecure			( void ) const;
	bool			Need				( void ) const;
	dword_t			NameCount			( void ) const;
	dword_t			NameOffset			( void ) const;
	dword_t			ExportCount			( void ) const;
	dword_t			ExportOffset		( void ) const;
	dword_t			ImportCount			( void ) const;
	dword_t			ImportOffset		( void ) const;
	dword_t			HeritageCount		( void ) const;
	dword_t			HeritageOffset		( void ) const;
	const char *	GUID				( void ) const;
	dword_t			GenerationCount		( void ) const;
	const dword_tp	GenExportCount		( void ) const;
	const dword_tp	GenNameCount		( void ) const;
	FILE *			Stream				( void );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
	void		Cleanup		( void );
	void		Setup		( void );
	void		GuidNibble	( char * aB, char aN, const	char * aHx );
	void		GuidByte	( char * aB, char aN, const	char * aHx );
	void		GuidString	( const	char * aGuid, size_t aLen, const char *	aHx	);
	void		ReadGuid	( void );

	// ----------------------------------------------------------------
	private:	// Instance	data
	// ----------------------------------------------------------------
	char *		itsFileName;
	struct stat	itsFileStat;
	FILE *		itsStream;
	dword_t		itsSignature;
	word_t		itsPackageVersion;
	word_t		itsLicenseeMode;
	dword_t		itsPackageFlags;
	dword_t		itsNameCount;
	dword_t		itsNameOffset;
	dword_t		itsExportCount;
	dword_t		itsExportOffset;
	dword_t		itsImportCount;
	dword_t		itsImportOffset;
	dword_t		itsHeritageCount;
	dword_t		itsHeritageOffset;
	char		itsGUID[33];
	dword_t		itsGenerationCount;
	dword_tp	itsGenExportCount;
	dword_tp	itsGenNameCount;
};

// --------------------------------------------------------------------
// Derived data	types
// --------------------------------------------------------------------
typedef	class CUnFile				CUnFile_t;
typedef	class CUnFile *				CUnFile_tp;

#endif	// #ifdef  CUnFile_hxx
// --------------------------------------------------------------------
// EOF:	CUnFile.hxx
// --------------------------------------------------------------------
