// --------------------------------------------------------------------
// CUnName.cxx
// Whatis:  Unreal Name
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CUnName.hxx"
#include	"CError.hxx"

// --------------------------------------------------------------------
// public:      Constructor #1
// --------------------------------------------------------------------
CUnName::CUnName	( CUnFile & aUf ) {
	char	namebuf[256];
    CUnName::Cleanup();
	try {
		::memset( namebuf, 0, sizeof( namebuf ) );
	    aUf.ReadText( namebuf, sizeof( namebuf ) - 1 );
	    itsFlags = aUf.ReadDword();
		itsName 	= ::my_private_strdup( namebuf );
		itsLcName	= ::my_private_strdup( namebuf );
	    ::my_strlower( itsLcName );
	}
	catch ( CError e ) {
	    CUnName::Free();
		throw CError( "CUnName::CUnName", e.Error() );
	}
	catch ( ... ) {
	    CUnName::Free();
		throw;
	}
}

// --------------------------------------------------------------------
// public:      Constructor #2
// --------------------------------------------------------------------
CUnName::CUnName  () {
    CUnName::Cleanup();
}

// --------------------------------------------------------------------
// public:		Copy constructor and assignment operator
// --------------------------------------------------------------------
CUnName::CUnName				( const CUnName & aC ) {
    CUnName::Cleanup();
	itsName 	= ::my_private_strdup( aC.Name() );
	itsLcName	= ::my_private_strdup( aC.LcName() );
	itsFlags	= aC.Flags();
}

// --------------------------------------------------------------------
CUnName & CUnName::operator =	( const CUnName & aC ) {
    CUnName::Free();
	itsName 	= ::my_private_strdup( aC.Name() );
	itsLcName	= ::my_private_strdup( aC.LcName() );
	itsFlags	= aC.Flags();
	return *this;
}

// --------------------------------------------------------------------
// public:      Destructor
// --------------------------------------------------------------------
CUnName::~CUnName () {
    CUnName::Free();
}

// --------------------------------------------------------------------
// private:     Clean it up
// --------------------------------------------------------------------
void    CUnName::Free	( void ) {
	if	( itsName ) 	delete [] itsName;
	if	( itsLcName )	delete [] itsLcName;
	CUnName::Cleanup();
}

// --------------------------------------------------------------------
void    CUnName::Cleanup( void ) {
	itsName		= NULL;
	itsLcName	= NULL;
    itsFlags	= 0;
}

// --------------------------------------------------------------------
const char *            CUnName::Name    ( void ) const { return itsName ? itsName : ""; }
const char *            CUnName::LcName  ( void ) const { return itsLcName ? itsLcName : ""; }
CUnObjectFlags_t        CUnName::Flags   ( void ) const { return itsFlags; }

// --------------------------------------------------------------------
// EOF: CUnName.cxx
// --------------------------------------------------------------------
