// --------------------------------------------------------------------
// CUnName.hxx
// Whatis:  Unreal Name
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#ifndef CUnName_hxx
#define CUnName_hxx
#include    "CUnObjectFlags.hxx"

// --------------------------------------------------------------------
// Declaration of the CUnName class
// --------------------------------------------------------------------
class   CUnName {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CUnName ( CUnFile & );
    CUnName ();

    // ----------------------------------------------------------------
    public:     // Copy constructor and assignment operator
    // ----------------------------------------------------------------
	CUnName					( const CUnName & );
	CUnName & operator = 	( const CUnName & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CUnName();

    // ----------------------------------------------------------------
    public:     // Accessing instance data
    // ----------------------------------------------------------------
    const char *            Name    ( void ) const;
    const char *            LcName  ( void ) const;
    CUnObjectFlags_t        Flags   ( void ) const;

    // ----------------------------------------------------------------
    private:    // Private helpers
    // ----------------------------------------------------------------
    void                Cleanup	( void );
	void				Free	( void );

    // ----------------------------------------------------------------
    private:    // Instance data
    // ----------------------------------------------------------------
    char *              itsName;
    char *              itsLcName;
    CUnObjectFlags_t    itsFlags;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef class CUnName               CUnName_t;
typedef class CUnName *             CUnName_tp;
typedef list <class CUnName>        CUnName_tl;
typedef CUnName_tl::iterator        CUnName_tli;
typedef CUnName_tl::const_iterator  CUnName_tlci;

#endif  // #ifdef  CUnName_hxx
// --------------------------------------------------------------------
// EOF: CUnName.hxx
// --------------------------------------------------------------------
