// --------------------------------------------------------------------
// CMySqlConnect.hxx
// Whatis:  Connection to MySQL database
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#ifndef CMySqlConnect_hxx
#define CMySqlConnect_hxx
#include    "Platform.hxx"
#ifdef	WIN32
#include	<windows.h>
#endif
#include    <mysql.h>

// --------------------------------------------------------------------
// Declaration of the CMySqlConnect class
// --------------------------------------------------------------------
class   CMySqlConnect {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CMySqlConnect ( const char * aUser,
                    const char * aPass,
                    const char * aDbas,
                    const char * aHost = NULL );

    // ----------------------------------------------------------------
    private:    // Copy constructor and assignment operator are lethal
                // Therefore they are made private
    // ----------------------------------------------------------------
    CMySqlConnect              ( const CMySqlConnect & );
    CMySqlConnect & operator = ( const CMySqlConnect & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CMySqlConnect();

    // ----------------------------------------------------------------
    public:     // Accessing instance data
    // ----------------------------------------------------------------
    MYSQL *     Mysql   ( void )    { return &itsMysql; }

    // ----------------------------------------------------------------
    private:    // Instance data
    // ----------------------------------------------------------------
    MYSQL       itsMysql;
    bool        itsConnect;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef class CMySqlConnect               CMySqlConnect_t;
typedef class CMySqlConnect *             CMySqlConnect_tp;

#endif  // #ifdef  CMySqlConnect_hxx
// --------------------------------------------------------------------
// EOF: CMySqlConnect.hxx
// --------------------------------------------------------------------
