// --------------------------------------------------------------------
// CMySqlWhere.hxx
// Whatis:  Class especially suitable for making where statements
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#ifndef     CMySqlWhere_hxx
#define     CMySqlWhere_hxx
#include    "Platform.hxx"

// --------------------------------------------------------------
// The quote class used for quoting strings for SQL
// --------------------------------------------------------------
class   CMySqlQuote {

    // ----------------------------------------------------------
    public: // Constructor and destructor
    // ----------------------------------------------------------
     CMySqlQuote    ();
    ~CMySqlQuote    ();

    // ----------------------------------------------------------
    public: // Copy Constructor and assignment operator
    // ----------------------------------------------------------
    CMySqlQuote              ( const CMySqlQuote & );
    CMySqlQuote & operator = ( const CMySqlQuote & );

    // ----------------------------------------------------------
    public:     // Interface
    // ----------------------------------------------------------
    const char *    Quote   ( void ) const;
    const char *    Quote   ( const char * );

    // ----------------------------------------------------------
    private:    // Instance data
    // ----------------------------------------------------------
    char *			itsQuote;
};

// --------------------------------------------------------------
// Class declaration
// --------------------------------------------------------------
class   CMySqlWhere {

    // ----------------------------------------------------------
    public: // Constructor and destructor
    // ----------------------------------------------------------
     CMySqlWhere    ();
    ~CMySqlWhere    ();

    // ----------------------------------------------------------
    public: // Copy constructor and assignment operators
    // ----------------------------------------------------------
    CMySqlWhere                 ( const CMySqlWhere & );
    CMySqlWhere &   operator =  ( const CMySqlWhere & );
    CMySqlWhere &   operator =  ( const char * );

    // ----------------------------------------------------------
    public: // Streaming operators
    // ----------------------------------------------------------
    CMySqlWhere & operator << ( const char * );
    CMySqlWhere & operator << ( const byte_tp );
    CMySqlWhere & operator << ( dword_t );
    CMySqlWhere & operator << ( word_t );
    CMySqlWhere & operator << ( byte_t );
    CMySqlWhere & operator << ( double );
    CMySqlWhere & operator << ( bool );
    CMySqlWhere & operator << ( time_t );

    // ----------------------------------------------------------
    public: // Output
    // ----------------------------------------------------------
    const char *    Where   ( void ) const { return itsWhere; }

    // ----------------------------------------------------------
    private:    // Instance data
    // ----------------------------------------------------------
    char    itsWhere[8192];
};

typedef class CMySqlWhere     CMySqlWhere_t;
typedef class CMySqlWhere *   CMySqlWhere_tp;

#endif      // #ifndef CMySqlWhere_hxx
// --------------------------------------------------------------
// EOF: CMySqlWhere.hxx
// --------------------------------------------------------------
