// --------------------------------------------------------------------
// CTableArep.hxx
// Whatis:  arep table access class
// Arepors: Esko 'Varpu' Ilola  EIL
// History: EIL 03-JUL-2002     Created this source
// --------------------------------------------------------------------
#ifndef CTableArep_hxx
#define CTableArep_hxx
#include    "CMySqlData.hxx"

// --------------------------------------------------------------------
// Data structure carrying the select data
// --------------------------------------------------------------------
typedef struct {
	char	arep_find[101];		// Author name to be replaced
	char	arep_fnam[65];		// First name of the author  
	char	arep_nnam[65];		// Nickname of the author    
	char	arep_lnam[65];		// Last name of the author   
}   data_arep_t,
*   data_arep_tp,
**  data_arep_th;
typedef list <data_arep_t>               data_arep_tl;
typedef data_arep_tl::iterator           data_arep_tli;
typedef data_arep_tl::const_iterator     data_arep_tlci;

// --------------------------------------------------------------------
// Declaration of the CTableArep class
// --------------------------------------------------------------------
class   CTableArep : public CMySqlData {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CTableArep ();

    // ----------------------------------------------------------------
    private:    // Copy constructor and assignment operator are lethal
                // Therefore they are made private
    // ----------------------------------------------------------------
    CTableArep              ( const CTableArep & );
    CTableArep & operator = ( const CTableArep & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CTableArep();

    // ----------------------------------------------------------------
    public:     // Interface
    // ----------------------------------------------------------------
    data_arep_tl   		Select  (  	CMySqlConnect_t &,
                                	const char *,
                                	bool = false );

    data_arep_tl		Select  (  	CMySqlConnect_t & aDb,
                            		const CMySqlWhere & aW ) { return Select( aDb, aW.Where() ); }

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const char *,
                                	bool = false );

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { return Count( aDb, aW.Where() ); }

    void                Insert  (   CMySqlConnect_t &,
                                    data_arep_tp );

    void                Update  (   CMySqlConnect_t &,
                                    data_arep_tp );

    void                Delete  (   CMySqlConnect_t &,
                                    data_arep_tp = NULL );

    void                Delete  (   CMySqlConnect_t &,
                                    const char * );

    void                Delete  (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { Delete( aDb, aW.Where() ); }

    // ----------------------------------------------------------------
    public:     // Retrieve layout descriptor
    // ----------------------------------------------------------------
    data_struct_descriptor_tp   Layout  ( void ) const;
};

#endif  // #ifdef  CTableArep_hxx
// --------------------------------------------------------------------
// EOF: CTableArep.hxx
// --------------------------------------------------------------------
